/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.logging.SimpleFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class MemoryLogHandler
extends Handler
implements INotificationSupport {
    private static final int DEFAULT_SIZE = 1000;
    private final int size;
    private final String id;
    private final LogRecord[] buffer;
    private int start;
    private int count;
    private EventDispatcher dispatcher;

    public MemoryLogHandler(String string) {
        this.size = 1000;
        this.id = string;
        this.setFormatter(new SimpleFormatter());
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public MemoryLogHandler(String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = n;
        this.id = string;
        this.setFormatter(new SimpleFormatter());
        this.buffer = new LogRecord[n];
        this.start = 0;
        this.count = 0;
    }

    @Override
    public synchronized void addNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher(this);
        }
        this.dispatcher.addNotificationListener(eventType, iNotificationListener);
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = null;
            ++n;
        }
        this.start = 0;
        this.count = 0;
        this.triggerChanged(null, null, null);
    }

    @Override
    public void close() throws SecurityException {
        this.setLevel(Level.OFF);
    }

    @Override
    public void flush() {
    }

    public String getId() {
        return this.id;
    }

    public synchronized LogRecord[] getLogRecords() {
        LogRecord[] logRecordArray = new LogRecord[this.count];
        int n = 0;
        while (n < this.count) {
            int n2 = (this.start + n) % this.buffer.length;
            logRecordArray[n] = this.buffer[n2];
            ++n;
        }
        return logRecordArray;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.count) {
            int n2 = (this.start + n) % this.buffer.length;
            try {
                stringBuilder.append(this.getFormatter().format(this.buffer[n2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        int n = (this.start + this.count) % this.buffer.length;
        this.buffer[n] = logRecord;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
        this.triggerChanged(null, null, logRecord);
    }

    public synchronized void push(Handler handler) {
        int n = 0;
        while (n < this.count) {
            int n2 = (this.start + n) % this.buffer.length;
            handler.publish(this.buffer[n2]);
            ++n;
        }
        this.clear();
    }

    @Override
    public synchronized void removeNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(eventType, iNotificationListener);
        if (this.dispatcher.isEmpty()) {
            this.dispatcher = null;
        }
    }

    protected void triggerChanged(Object object, Object object2, Object object3) {
        AttributeChangedEvent attributeChangedEvent = new AttributeChangedEvent(this, object, object2, object3);
        this.triggerEvent(attributeChangedEvent);
    }

    protected void triggerEvent(Event event) {
        if (this.dispatcher == null) {
            return;
        }
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

