/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.charset.ICharsetAccess;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;

public class StringLocator
extends CommonLocator
implements ICharsetAccess {
    private final String content;
    private String charset = System.getProperty("file.encoding");
    private String fullName;
    private String localName;
    private String type;

    public StringLocator(String string, String string2) {
        this.content = string;
        this.setFullName(string2);
    }

    public StringLocator(String string, String string2, String string3) {
        this.content = string;
        if (StringTools.isEmpty(string3)) {
            this.setFullName(string2);
        } else {
            this.setFullName(String.valueOf(string2) + "." + string3);
        }
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.getContent() != null;
    }

    protected byte[] getBytes() {
        byte[] byArray;
        try {
            byArray = this.getContent().getBytes(this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = this.getContent().getBytes();
        }
        return byArray;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String string) {
        return null;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        byte[] byArray = this.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public long getLength() throws IOException {
        return this.getBytes().length;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        byte[] byArray = this.getBytes();
        return new RandomAccessByteArray(byArray);
    }

    @Override
    public Reader getReader() throws IOException {
        return new StringReader(this.getContent());
    }

    @Override
    public Reader getReader(String string) throws IOException {
        return new StringReader(this.getContent());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public Writer getWriter(String string) throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return new ILocator[0];
    }

    @Override
    public void rename(String string) throws IOException {
        this.setFullName(string);
    }

    @Override
    public void setCharset(String string) {
        this.charset = string;
    }

    protected void setFullName(String string) {
        this.fullName = string;
        this.localName = FileTools.getBaseName(string);
        this.type = FileTools.getExtension(string, this.getType());
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }
}

