/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import de.intarsys.tools.geometry.TransformedShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;

public class ApplySpaceChangeShape
extends TransformedShape {
    private final AffineTransform sourceTransform;
    private final AffineTransform targetTransform;

    public static TransformedShape create(Shape shape, AffineTransform affineTransform) {
        ApplySpaceChangeShape applySpaceChangeShape;
        if (shape instanceof ApplySpaceChangeShape && (applySpaceChangeShape = (ApplySpaceChangeShape)shape).getTargetTransform().equals(affineTransform)) {
            return ApplySpaceChangeShape.create(applySpaceChangeShape.getBaseShape(), applySpaceChangeShape.getSourceTransform(), affineTransform);
        }
        return ApplySpaceChangeShape.create(shape, (AffineTransform)affineTransform.clone(), affineTransform);
    }

    public static TransformedShape create(Shape shape, AffineTransform affineTransform, AffineTransform affineTransform2) {
        return new ApplySpaceChangeShape(shape, affineTransform, affineTransform2);
    }

    public static TransformedShape setTransform(Shape shape, AffineTransform affineTransform) {
        if (shape instanceof ApplySpaceChangeShape) {
            ApplySpaceChangeShape applySpaceChangeShape = (ApplySpaceChangeShape)shape;
            return new ApplySpaceChangeShape(applySpaceChangeShape.getBaseShape(), applySpaceChangeShape.getSourceTransform(), affineTransform);
        }
        return new ApplySpaceChangeShape(shape, IDENTITY, affineTransform);
    }

    protected ApplySpaceChangeShape(ApplySpaceChangeShape applySpaceChangeShape) {
        super(applySpaceChangeShape);
        this.sourceTransform = applySpaceChangeShape.sourceTransform;
        this.targetTransform = (AffineTransform)applySpaceChangeShape.targetTransform.clone();
    }

    protected ApplySpaceChangeShape(Shape shape, AffineTransform affineTransform, AffineTransform affineTransform2) {
        super(shape);
        this.sourceTransform = affineTransform;
        this.targetTransform = affineTransform2;
    }

    @Override
    protected Shape apply() {
        if (this.targetTransform.equals(this.sourceTransform)) {
            return this.getBaseShape();
        }
        if (this.getBaseShape() instanceof Area) {
            return new Area(this.getTransform().createTransformedShape(this.getBaseShape()));
        }
        return this.getTransform().createTransformedShape(this.getBaseShape());
    }

    @Override
    public Object clone() {
        return new ApplySpaceChangeShape(this);
    }

    public AffineTransform getSourceTransform() {
        return this.sourceTransform;
    }

    public AffineTransform getTargetTransform() {
        return this.targetTransform;
    }

    @Override
    public AffineTransform getTransform() {
        try {
            if (this.targetTransform.equals(this.sourceTransform)) {
                return new AffineTransform();
            }
            AffineTransform affineTransform = this.targetTransform.createInverse();
            affineTransform.concatenate(this.sourceTransform);
            return affineTransform;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new AffineTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }
}

