/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.collection.ArrayIterator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Args
implements IArgs {
    private static final Binding[] EMPTY = new Binding[0];
    private static final Object UNDEFINED = new Object();
    private Binding[] entries = EMPTY;
    private int ptr = 0;

    public static Args create() {
        return new Args();
    }

    public static Args createIndexed(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return new Args(arrayList);
    }

    public static Args createIndexed(Object object, Object object2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        return new Args(arrayList);
    }

    public static Args createIndexed(Object object, Object object2, Object object3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        return new Args(arrayList);
    }

    public static Args createNamed(String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        return new Args(hashMap);
    }

    public static Args createNamed(String string, Object object, String string2, Object object2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        hashMap.put(string2, object2);
        return new Args(hashMap);
    }

    public Args() {
    }

    public Args(Args args) {
        if (args == null) {
            return;
        }
        this.ptr = args.ptr;
        if (this.ptr > 0) {
            this.entries = new Binding[this.ptr];
            int n = 0;
            while (n < this.ptr) {
                Binding binding = args.entries[n];
                Object object = binding.value;
                this.entries[n] = object instanceof IArgs ? new Binding(binding.name, ((IArgs)object).copy()) : new Binding(binding.name, object);
                ++n;
            }
        }
    }

    public Args(List list) {
        this.ptr = list.size();
        this.entries = new Binding[this.ptr];
        int n = 0;
        while (n < this.ptr) {
            this.entries[n] = new Binding(null, list.get(n));
            ++n;
        }
    }

    public Args(Map map) {
        this.ptr = map.size();
        this.entries = new Binding[this.ptr];
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            this.entries[n++] = new Binding(string, v);
        }
    }

    public Args(Object[] objectArray) {
        if (objectArray != null) {
            this.ptr = objectArray.length;
            this.entries = new Binding[this.ptr];
            int n = 0;
            while (n < this.ptr) {
                this.entries[n] = new Binding(null, objectArray[n]);
                ++n;
            }
        }
    }

    @Override
    public IArgs.IBinding add(Object object) {
        this.ensureCapacity(this.ptr);
        Binding binding = new Binding(null, object);
        this.entries[this.ptr++] = binding;
        return binding;
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new ArrayIterator(this.entries, this.ptr);
    }

    @Override
    public void clear() {
        int n = 0;
        while (n < this.ptr) {
            this.entries[n] = null;
            ++n;
        }
        this.ptr = 0;
    }

    @Override
    public IArgs copy() {
        return new Args(this);
    }

    @Override
    public IArgs.IBinding declare(String string) {
        Binding binding;
        int n = 0;
        while (n < this.ptr) {
            binding = this.entries[n];
            if (string.equals(binding.name)) {
                return binding;
            }
            ++n;
        }
        n = 0;
        while (n < this.ptr) {
            binding = this.entries[n];
            if (binding.name == null) {
                binding.name = string;
                return binding;
            }
            ++n;
        }
        this.ensureCapacity(this.ptr);
        binding = new Binding(string);
        this.entries[this.ptr++] = binding;
        return binding;
    }

    protected void ensureCapacity(int n) {
        if (n >= this.entries.length) {
            Binding[] bindingArray = new Binding[n + 4];
            System.arraycopy(this.entries, 0, bindingArray, 0, this.entries.length);
            this.entries = bindingArray;
        }
    }

    @Override
    public Object get(int n) {
        if (n < 0 || n >= this.ptr) {
            return null;
        }
        if (this.entries[n].isDefined()) {
            return this.entries[n].value;
        }
        return null;
    }

    @Override
    public Object get(int n, Object object) {
        if (n < 0 || n >= this.ptr) {
            return object;
        }
        if (this.entries[n].isDefined()) {
            return this.entries[n].value;
        }
        return object;
    }

    @Override
    public Object get(String string) {
        int n = 0;
        while (n < this.ptr) {
            Binding binding = this.entries[n];
            if (string.equals(binding.name) && binding.isDefined()) {
                return binding.value;
            }
            ++n;
        }
        return null;
    }

    @Override
    public Object get(String string, Object object) {
        int n = 0;
        while (n < this.ptr) {
            Binding binding = this.entries[n];
            if (string.equals(binding.name) && binding.isDefined()) {
                return binding.value;
            }
            ++n;
        }
        return object;
    }

    @Override
    public boolean isDefined(String string) {
        int n = 0;
        while (n < this.ptr) {
            Binding binding = this.entries[n];
            if (string.equals(binding.name)) {
                return binding.isDefined();
            }
            ++n;
        }
        return false;
    }

    public boolean isIndexed() {
        return true;
    }

    public boolean isNamed() {
        int n = 0;
        while (n < this.ptr) {
            Binding binding = this.entries[n];
            if (binding.name != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Set names() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < this.ptr) {
            Binding binding = this.entries[n];
            if (binding.name != null) {
                hashSet.add(binding.name);
            }
            ++n;
        }
        return hashSet;
    }

    @Override
    public IArgs.IBinding put(int n, Object object) {
        Binding binding;
        if (n >= this.ptr) {
            this.ensureCapacity(n);
            int n2 = this.ptr;
            while (n2 < n) {
                this.entries[n2] = new Binding(null);
                ++n2;
            }
            this.entries[n] = binding = new Binding(null, object);
            this.ptr = n + 1;
        } else {
            binding = this.entries[n];
            this.entries[n].setValue(object);
        }
        return binding;
    }

    @Override
    public IArgs.IBinding put(String string, Object object) {
        int n = 0;
        while (n < this.ptr) {
            Binding binding = this.entries[n];
            if (string.equals(binding.name)) {
                Binding binding2 = binding;
                binding.setValue(object);
                return binding2;
            }
            ++n;
        }
        this.ensureCapacity(this.ptr);
        Binding binding = new Binding(string, object);
        this.entries[this.ptr++] = binding;
        return binding;
    }

    @Override
    public int size() {
        return this.ptr;
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }

    @Override
    public void undefine(int n) {
        if (n < this.ptr) {
            this.entries[n].setValue(UNDEFINED);
        }
    }

    @Override
    public void undefine(String string) {
        int n = 0;
        while (n < this.ptr) {
            Binding binding = this.entries[n];
            if (string.equals(binding.name)) {
                Binding binding2 = binding;
                binding.setValue(UNDEFINED);
            }
            ++n;
        }
    }

    static class Binding
    implements IArgs.IBinding {
        protected String name;
        protected Object value;

        protected Binding(String string) {
            this.name = string;
            this.value = UNDEFINED;
        }

        protected Binding(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return this.value == UNDEFINED ? null : this.value;
        }

        @Override
        public boolean isDefined() {
            return this.value != UNDEFINED;
        }

        @Override
        public void setValue(Object object) {
            this.value = object;
        }

        public String toString() {
            return this.name + ":" + this.value;
        }
    }
}

