/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.digest.Digest;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.monitor.Trace;
import java.security.MessageDigest;
import java.util.logging.Level;

public class Digester
implements IDigester {
    private MessageDigest messageDigest;
    private String algorithmName;

    protected Digester(String string, MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
        this.algorithmName = string;
    }

    protected IDigest basicDigest() {
        byte[] byArray = this.getMessageDigest().digest();
        return new Digest(this.getAlgorithmName(), byArray);
    }

    @Override
    public IDigest digest() {
        try {
            Trace.get().sample(Level.FINE, "digest enter");
            IDigest iDigest = this.basicDigest();
            return iDigest;
        }
        finally {
            Trace.get().sample(Level.FINE, "digest leave");
        }
    }

    @Override
    public IDigest digest(byte[] byArray) {
        return this.digest(byArray, 0, byArray.length);
    }

    @Override
    public IDigest digest(byte[] byArray, int n, int n2) {
        try {
            Trace.get().sample(Level.FINE, "digest enter");
            this.update(byArray, n, n2);
            IDigest iDigest = this.basicDigest();
            return iDigest;
        }
        finally {
            Trace.get().sample(Level.FINE, "digest leave");
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    protected MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    @Override
    public void reset() {
        this.getMessageDigest().reset();
    }

    public String toString() {
        return this.getAlgorithmName();
    }

    @Override
    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.getMessageDigest().update(byArray, n, n2);
    }
}

