/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.conditions;

import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.ConditionGroup;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Or
implements ConditionGroup {
    private static final long serialVersionUID = 4475481127736826653L;
    private List<Condition> conditions;

    public Or() {
        this(null);
    }

    public Or(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean isTrue(Object element) {
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.isTrue(element)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Or clone() throws CloneNotSupportedException {
        Or result = (Or)super.clone();
        if (result.conditions != null) {
            ArrayList<Condition> clonedConditions = new ArrayList<Condition>(this.conditions.size());
            for (Condition condition : result.conditions) {
                clonedConditions.add(condition.clone());
            }
            result.conditions = clonedConditions;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.conditions == null || this.conditions.size() == 0) {
            result.append("false");
        } else {
            result.append("(");
            boolean first = true;
            for (Condition condition : this.conditions) {
                if (first) {
                    first = false;
                } else {
                    result.append(" || ");
                }
                result.append(condition);
            }
            result.append(")");
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Or or = (Or)o;
        return !(this.conditions == null ? or.conditions != null : !((Object)this.conditions).equals(or.conditions));
    }

    public int hashCode() {
        return this.conditions != null ? ((Object)this.conditions).hashCode() : 0;
    }
}

