/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.jul.xml;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.jul.xml.LoggingEventSchemaConstants;
import de.huxhorn.sulky.stax.GenericStreamReader;
import de.huxhorn.sulky.stax.StaxUtilities;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventReader
implements GenericStreamReader<LoggingEvent>,
LoggingEventSchemaConstants {
    private final Logger logger = LoggerFactory.getLogger(LoggingEventReader.class);
    private static final String MESSAGE_SEPARATOR = ": ";

    public LoggingEvent read(XMLStreamReader reader) throws XMLStreamException {
        LoggingEvent result = null;
        String rootNamespace = NAMESPACE_URI;
        int type = reader.getEventType();
        if (7 == type) {
            do {
                reader.next();
            } while ((type = reader.getEventType()) != 1 || !"record".equals(reader.getLocalName()));
            rootNamespace = null;
        }
        if (1 == type && "record".equals(reader.getLocalName())) {
            String paramStr;
            String messageStr;
            String threadStr;
            reader.nextTag();
            result = new LoggingEvent();
            String dateStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"date");
            String millisStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"millis");
            Long timeStamp = null;
            if (millisStr != null) {
                try {
                    timeStamp = Long.parseLong(millisStr);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (timeStamp == null && dateStr != null && this.logger.isInfoEnabled()) {
                this.logger.info("Parsing date hasn't been implemented since millis is mandatory in Schema.");
            }
            result.setTimeStamp(timeStamp);
            String sequenceStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"sequence");
            try {
                result.setSequenceNumber(Long.valueOf(Long.parseLong(sequenceStr)));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            String loggerStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"logger");
            result.setLogger(loggerStr);
            result.setLevel(this.resolveLevel(StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"level")));
            String classStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"class");
            String methodStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"method");
            if (classStr != null || methodStr != null) {
                ExtendedStackTraceElement[] callStack = new ExtendedStackTraceElement[]{new ExtendedStackTraceElement(classStr, methodStr, null, -1)};
                result.setCallStack(callStack);
            }
            if ((threadStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"thread")) != null) {
                try {
                    long threadId = Long.parseLong(threadStr);
                    result.setThreadInfo(new ThreadInfo(Long.valueOf(threadId), null, null, null));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if ((messageStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"message")) != null) {
                result.setMessage(new Message(messageStr));
            }
            String keyStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"key");
            String catalogStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"catalog");
            ArrayList<String> paramList = new ArrayList<String>();
            while ((paramStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"param")) != null) {
                paramList.add(paramStr);
            }
            if ((keyStr != null || catalogStr != null || paramList.size() > 0) && this.logger.isInfoEnabled()) {
                this.logger.info("Ignoring the following message infos: key={}, catalog={}, params={}", new Object[]{keyStr, catalogStr, paramList});
            }
            result.setThrowable(this.readThrowableInfo(reader));
            reader.require(2, null, "record");
            do {
                reader.next();
            } while ((type = reader.getEventType()) != 8 && type != 1);
            return result;
        }
        return result;
    }

    private ThrowableInfo readThrowableInfo(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "exception".equals(reader.getLocalName())) {
            ExtendedStackTraceElement current;
            reader.nextTag();
            ThrowableInfo result = new ThrowableInfo();
            String messageStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"message");
            if (messageStr != null) {
                String className;
                int separatorIndex = messageStr.indexOf(MESSAGE_SEPARATOR);
                if (separatorIndex >= 0) {
                    className = messageStr.substring(0, separatorIndex);
                    messageStr = messageStr.substring(separatorIndex + MESSAGE_SEPARATOR.length());
                } else {
                    className = messageStr;
                    messageStr = null;
                }
                result.setMessage(messageStr);
                result.setName(className);
            }
            ArrayList<ExtendedStackTraceElement> stackTraceList = new ArrayList<ExtendedStackTraceElement>();
            while ((current = this.parseFrame(reader)) != null) {
                stackTraceList.add(current);
            }
            result.setStackTrace(stackTraceList.toArray(new ExtendedStackTraceElement[stackTraceList.size()]));
            reader.require(2, null, "exception");
            reader.nextTag();
            return result;
        }
        return null;
    }

    private ExtendedStackTraceElement parseFrame(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "frame".equals(reader.getLocalName())) {
            reader.nextTag();
            String classStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"class");
            String methodStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"method");
            String lineStr = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"line");
            int line = -1;
            if (lineStr != null) {
                try {
                    line = Integer.parseInt(lineStr);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            reader.require(2, null, "frame");
            reader.nextTag();
            return new ExtendedStackTraceElement(classStr, methodStr, null, line);
        }
        return null;
    }

    private LoggingEvent.Level resolveLevel(String levelStr) {
        if (levelStr == null) {
            return null;
        }
        int levelIntValue = 0;
        try {
            levelIntValue = Integer.parseInt(levelStr);
        }
        catch (NumberFormatException ex) {
            try {
                Level level = Level.parse(levelStr);
                levelIntValue = level.intValue();
            }
            catch (IllegalArgumentException ex2) {
                // empty catch block
            }
        }
        if (levelIntValue <= Level.FINEST.intValue()) {
            return LoggingEvent.Level.TRACE;
        }
        if (levelIntValue <= Level.FINE.intValue()) {
            return LoggingEvent.Level.DEBUG;
        }
        if (levelIntValue <= Level.INFO.intValue()) {
            return LoggingEvent.Level.INFO;
        }
        if (levelIntValue <= Level.WARNING.intValue()) {
            return LoggingEvent.Level.WARN;
        }
        return LoggingEvent.Level.ERROR;
    }
}

