/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.ins.internal;

import com.vladsch.flexmark.ext.ins.Ins;
import com.vladsch.flexmark.ext.ins.InsExtension;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class InsNodeRenderer
implements NodeRenderer {
    private final String insStyleHtmlOpen;
    private final String insStyleHtmlClose;

    public InsNodeRenderer(DataHolder options) {
        this.insStyleHtmlOpen = (String)InsExtension.INS_STYLE_HTML_OPEN.getFrom(options);
        this.insStyleHtmlClose = (String)InsExtension.INS_STYLE_HTML_CLOSE.getFrom(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Ins.class, (CustomNodeRenderer)new CustomNodeRenderer<Ins>(){

            public void render(Ins node, NodeRendererContext context, HtmlWriter html) {
                InsNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Ins node, NodeRendererContext context, HtmlWriter html) {
        if (this.insStyleHtmlOpen == null || this.insStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag((CharSequence)"ins");
            } else {
                html.srcPos(node.getText()).withAttr().tag((CharSequence)"ins");
            }
            context.renderChildren((Node)node);
            html.tag((CharSequence)"/ins");
        } else {
            html.raw((CharSequence)this.insStyleHtmlOpen);
            context.renderChildren((Node)node);
            html.raw((CharSequence)this.insStyleHtmlClose);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer apply(DataHolder options) {
            return new InsNodeRenderer(options);
        }
    }
}

