/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.map.Map;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.layer.VectorLayer;
import com.vaadin.flow.component.map.configuration.source.VectorSource;
import com.vaadin.flow.component.map.events.FeatureEventDetails;
import com.vaadin.flow.component.map.events.MapEventUtil;
import tools.jackson.databind.node.ArrayNode;

@DomEvent(value="map-feature-drop")
public class MapFeatureDropEvent
extends ComponentEvent<Map> {
    private final Feature feature;
    private final VectorLayer layer;
    private final VectorSource vectorSource;
    private final Coordinate coordinate;
    private final Coordinate startCoordinate;

    public MapFeatureDropEvent(Map source, boolean fromClient, @EventData(value="event.detail.feature.id") String featureId, @EventData(value="event.detail.layer.id") String layerId, @EventData(value="event.detail.coordinate") ArrayNode coordinate, @EventData(value="event.detail.startCoordinate") ArrayNode startCoordinate) {
        super((Component)source, fromClient);
        FeatureEventDetails featureEventDetails = MapEventUtil.getFeatureEventDetails(source.getRawConfiguration(), layerId, featureId);
        this.layer = featureEventDetails.getLayer();
        this.vectorSource = featureEventDetails.getSource();
        this.feature = featureEventDetails.getFeature();
        this.coordinate = MapEventUtil.getCoordinate(coordinate);
        this.startCoordinate = MapEventUtil.getCoordinate(startCoordinate);
    }

    public Feature getFeature() {
        return this.feature;
    }

    public VectorLayer getLayer() {
        return this.layer;
    }

    public VectorSource getVectorSource() {
        return this.vectorSource;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Coordinate getStartCoordinate() {
        return this.startCoordinate;
    }
}

