/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.endpointransfermapper;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.vaadin.hilla.endpointransfermapper.PageMapper;
import com.vaadin.hilla.endpointransfermapper.PageableMapper;
import com.vaadin.hilla.endpointransfermapper.UUIDMapper;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointTransferMapper {
    private Map<Class<?>, Class<?>> endpointToTransfer = new HashMap();
    private Map<Class<?>, Mapper<?, ?>> mappers = new HashMap();
    private final SimpleModule jacksonModule = new SimpleModule();

    public EndpointTransferMapper() {
        this.registerMapper(new PageableMapper());
        this.registerMapper(new UUIDMapper());
        this.registerMapper(new PageMapper());
    }

    private <ENDPOINTTYPE, TRANSFERTYPE> void registerMapper(final Mapper<ENDPOINTTYPE, TRANSFERTYPE> mapper) {
        final Class<ENDPOINTTYPE> endpointType = mapper.getEndpointType();
        final Class<TRANSFERTYPE> transferType = mapper.getTransferType();
        this.endpointToTransfer.put(endpointType, mapper.getTransferType());
        this.mappers.put(endpointType, mapper);
        StdDelegatingSerializer serializer = new StdDelegatingSerializer((Converter)new StdConverter<ENDPOINTTYPE, TRANSFERTYPE>(){

            public TRANSFERTYPE convert(ENDPOINTTYPE value) {
                return mapper.toTransferType(value);
            }

            public JavaType getInputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)endpointType);
            }

            public JavaType getOutputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)transferType);
            }
        });
        this.jacksonModule.addSerializer(endpointType, (JsonSerializer)serializer);
        StdDelegatingDeserializer deserializer = new StdDelegatingDeserializer((Converter)new StdConverter<TRANSFERTYPE, ENDPOINTTYPE>(){

            public ENDPOINTTYPE convert(TRANSFERTYPE value) {
                return mapper.toEndpointType(value);
            }

            public JavaType getInputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)transferType);
            }

            public JavaType getOutputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)endpointType);
            }
        });
        this.jacksonModule.addDeserializer(endpointType, (JsonDeserializer)deserializer);
    }

    public Module getJacksonModule() {
        return this.jacksonModule;
    }

    public Class<?> getTransferType(Class<?> endpointType) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.endpointToTransfer.entrySet()) {
            if (!entry.getKey().isAssignableFrom(endpointType)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getTransferType(String endpointType) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.endpointToTransfer.entrySet()) {
            if (!entry.getKey().getName().equals(endpointType)) continue;
            return entry.getValue().getName();
        }
        return null;
    }

    public <T> Mapper getMapper(Class<T> endpointType) {
        for (Class<T> clazz : this.endpointToTransfer.keySet()) {
            if (!clazz.isAssignableFrom(endpointType)) continue;
            return this.mappers.get(clazz);
        }
        return null;
    }

    public Object toTransferType(Object endpointValue) {
        if (endpointValue == null) {
            return null;
        }
        Class<?> endpointValueType = endpointValue.getClass();
        Mapper mapper = this.getMapper(endpointValueType);
        if (mapper == null) {
            return endpointValue;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Mapping from endpoint type ({}) to transfer type ({})", (Object)endpointValueType.getName(), (Object)mapper.getTransferType().getName());
        }
        return mapper.toTransferType(endpointValue);
    }

    public <T> T toEndpointType(Object transferValue, Class<T> endpointType) {
        if (transferValue == null) {
            return null;
        }
        Mapper mapper = this.getMapper(endpointType);
        if (mapper == null) {
            return (T)transferValue;
        }
        this.getLogger().debug("Mapping from transfer type (" + transferValue.getClass().getName() + ") to endpoint type (" + endpointType.getName() + ")");
        return (T)mapper.toEndpointType(transferValue);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public static interface Mapper<ENDPOINTTYPE, TRANSFERTYPE> {
        public Class<? extends ENDPOINTTYPE> getEndpointType();

        public Class<? extends TRANSFERTYPE> getTransferType();

        public TRANSFERTYPE toTransferType(ENDPOINTTYPE var1);

        public ENDPOINTTYPE toEndpointType(TRANSFERTYPE var1);
    }
}

