/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import java.io.Serializable;
import java.util.stream.Stream;

public abstract class AbstractPropertyMap
extends NodeMap {
    public AbstractPropertyMap(StateNode node) {
        super(node);
    }

    public void setProperty(String name, Serializable value, boolean emitChange) {
        assert (name != null);
        assert (AbstractPropertyMap.isValidValueType(value));
        if (this.hasSignal(name)) {
            NodeMap.SignalBinding b = (NodeMap.SignalBinding)super.get(name);
            this.put(name, new NodeMap.SignalBinding(b.signal(), b.registration(), value), emitChange);
        } else {
            this.put(name, value, emitChange);
        }
    }

    public boolean hasProperty(String name) {
        return this.contains(name);
    }

    public void removeProperty(String name) {
        super.remove(name);
    }

    public void removeAllProperties() {
        super.clear();
    }

    public Serializable getProperty(String name) {
        return this.get(name);
    }

    public Stream<String> getPropertyNames() {
        return this.keySet().stream();
    }

    public static boolean isValidValueType(Serializable value) {
        if (value == null) {
            return true;
        }
        Class<?> type = ReflectTools.convertPrimitiveType(value.getClass());
        return JacksonCodec.canEncodeWithoutTypeInfo(type) || StateNode.class.isAssignableFrom(type);
    }

    public boolean hasSignal(String key) {
        NodeMap.SignalBinding binding;
        Serializable serializable = super.get(key);
        return serializable instanceof NodeMap.SignalBinding && (binding = (NodeMap.SignalBinding)serializable).signal() != null && binding.registration() != null;
    }

    @Override
    public void updateFromClient(String key, Serializable value) {
        if (this.hasSignal(key)) {
            NodeMap.SignalBinding b = (NodeMap.SignalBinding)super.get(key);
            super.updateFromClient(key, new NodeMap.SignalBinding(b.signal(), b.registration(), value));
        } else {
            super.updateFromClient(key, value);
        }
    }

    public void bindSignal(Element owner, String name, Signal<?> signal) {
        Registration registration;
        NodeMap.SignalBinding binding;
        Serializable serializable = super.get(name);
        NodeMap.SignalBinding previousSignalBinding = serializable instanceof NodeMap.SignalBinding ? (binding = (NodeMap.SignalBinding)serializable) : null;
        if (signal != null && this.hasSignal(name)) {
            throw new BindingActiveException();
        }
        Registration registration2 = registration = signal != null ? ElementEffect.bind(owner, signal, (element, value) -> this.setPropertyFromSignal(name, value)) : null;
        if (signal == null && previousSignalBinding != null) {
            if (previousSignalBinding.registration() != null) {
                previousSignalBinding.registration().remove();
            }
            this.put(name, this.get(name), false);
        } else {
            this.put(name, new NodeMap.SignalBinding(signal, registration, this.get(name)), false);
        }
    }

    protected abstract void setPropertyFromSignal(String var1, Object var2);
}

