/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.handler.MessageContextImpl;
import com.sun.xml.ws.handler.MessageContextUtil;
import com.sun.xml.ws.server.Tie;
import com.sun.xml.ws.server.WSDLPublisher;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import com.sun.xml.ws.transport.http.servlet.ServletConnectionImpl;
import com.sun.xml.ws.util.exception.JAXWSExceptionBase;
import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.handler.MessageContext;

public class WSServletDelegate {
    private Tie tie = new Tie();
    private ServletContext servletContext;
    private List<com.sun.xml.ws.server.RuntimeEndpointInfo> jaxwsInfo;
    private Localizer defaultLocalizer;
    private LocalizableMessageFactory messageFactory;
    private Map fixedUrlPatternEndpoints;
    private List pathUrlPatternEndpoints;
    private Map localizerMap;
    private WSDLPublisher publisher;
    private boolean publishWSDL;
    private boolean publishStatusPage;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.servlet.http");

    public void init(ServletConfig servletConfig) throws ServletException {
        this.defaultLocalizer = new Localizer();
        this.localizerMap = new HashMap();
        this.localizerMap.put(this.defaultLocalizer.getLocale(), this.defaultLocalizer);
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.wsservlet");
        this.servletContext = servletConfig.getServletContext();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.initialize", new Object[0])));
        }
        this.fixedUrlPatternEndpoints = new HashMap();
        this.pathUrlPatternEndpoints = new ArrayList();
        this.jaxwsInfo = (List)this.servletContext.getAttribute("com.sun.xml.ws.server.http.info");
        if (this.jaxwsInfo == null) {
            this.warnMissingContextInformation();
        } else {
            HashMap<String, com.sun.xml.ws.server.RuntimeEndpointInfo> endpointsByName = new HashMap<String, com.sun.xml.ws.server.RuntimeEndpointInfo>();
            for (com.sun.xml.ws.server.RuntimeEndpointInfo info : this.jaxwsInfo) {
                if (endpointsByName.containsKey(info.getName())) {
                    logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.duplicateEndpointName", info.getName())));
                    continue;
                }
                endpointsByName.put(info.getName(), info);
                this.registerEndpointUrlPattern(info);
                try {
                    info.injectContext();
                    info.beginService();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    throw new ServletException(e.getMessage());
                }
            }
        }
        String publishWSDLParam = this.servletContext.getInitParameter("com.sun.xml.ws.server.http.publishWSDL");
        this.publishWSDL = publishWSDLParam == null ? true : Boolean.valueOf(publishWSDLParam);
        String publishStatusPageParam = this.servletContext.getInitParameter("com.sun.xml.ws.server.http.publishStatusPage");
        this.publishStatusPage = publishStatusPageParam == null ? true : Boolean.valueOf(publishStatusPageParam);
        this.publisher = new WSDLPublisher(this.servletContext, this.jaxwsInfo);
    }

    public void destroy() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.destroy", new Object[0])));
        }
        if (this.jaxwsInfo != null) {
            for (com.sun.xml.ws.server.RuntimeEndpointInfo info : this.jaxwsInfo) {
                try {
                    info.endService();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            com.sun.xml.ws.server.RuntimeEndpointInfo targetEndpoint = this.getEndpointFor(request);
            if (targetEndpoint != null) {
                String query = request.getQueryString();
                if (query != null && (query.startsWith("wsdl") || query.startsWith("xsd="))) {
                    this.publisher.handle(targetEndpoint, this.fixedUrlPatternEndpoints, request, response);
                    return;
                }
                BindingImpl binding = (BindingImpl)targetEndpoint.getBinding();
                if (binding.getBindingId().equals("http://www.w3.org/2004/08/wsdl/http")) {
                    this.handle(request, response, targetEndpoint);
                } else {
                    this.writeWebServicesHtmlPage(request, response);
                }
            } else {
                Localizer localizer = this.getLocalizerFor((ServletRequest)request);
                this.writeNotFoundErrorPage(localizer, response, "Invalid Request");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServletException(e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            com.sun.xml.ws.server.RuntimeEndpointInfo targetEndpoint = this.getEndpointFor(request);
            if (targetEndpoint != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.gotRequestForEndpoint", targetEndpoint.getName())));
                }
            } else {
                Localizer localizer = this.getLocalizerFor((ServletRequest)request);
                this.writeNotFoundErrorPage(localizer, response, "Invalid request");
                return;
            }
            this.handle(request, response, targetEndpoint);
        }
        catch (JAXWSExceptionBase e) {
            logger.log(Level.SEVERE, this.defaultLocalizer.localize(e), (Throwable)((Object)e));
            response.setStatus(500);
        }
        catch (Throwable e) {
            if (e instanceof Localizable) {
                logger.log(Level.SEVERE, this.defaultLocalizer.localize((Localizable)((Object)e)), e);
            } else {
                logger.log(Level.SEVERE, "caught throwable", e);
            }
            response.setStatus(500);
        }
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, com.sun.xml.ws.server.RuntimeEndpointInfo targetEndpoint) throws Exception {
        WebServiceContext wsCtxt = targetEndpoint.getWebServiceContext();
        MessageContextImpl msgCtxt = new MessageContextImpl();
        wsCtxt.setMessageContext(msgCtxt);
        msgCtxt.put("javax.xml.ws.servlet.context", this.servletContext);
        msgCtxt.setScope("javax.xml.ws.servlet.context", MessageContext.Scope.APPLICATION);
        msgCtxt.put("javax.xml.ws.servlet.session", request.getSession());
        msgCtxt.setScope("javax.xml.ws.servlet.session", MessageContext.Scope.APPLICATION);
        msgCtxt.put("javax.xml.ws.servlet.request", request);
        msgCtxt.setScope("javax.xml.ws.servlet.request", MessageContext.Scope.APPLICATION);
        msgCtxt.put("javax.xml.ws.servlet.response", response);
        msgCtxt.setScope("javax.xml.ws.servlet.response", MessageContext.Scope.APPLICATION);
        MessageContextUtil.setHttpRequestMethod(msgCtxt, request.getMethod());
        if (request.getQueryString() != null) {
            MessageContextUtil.setQueryString(msgCtxt, request.getQueryString());
        }
        if (request.getPathInfo() != null) {
            MessageContextUtil.setPathInfo(msgCtxt, request.getPathInfo());
        }
        ServletConnectionImpl connection = new ServletConnectionImpl(request, response);
        MessageContextUtil.setHttpRequestHeaders(msgCtxt, connection.getHeaders());
        this.tie.handle(connection, targetEndpoint);
    }

    protected void writeNotFoundErrorPage(Localizer localizer, HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title", new Object[0])));
        out.println("</title></head>");
        out.println("<body>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.notFound", message)));
        out.println("</body>");
        out.println("</html>");
    }

    protected void writeInvalidMethodType(Localizer localizer, HttpServletResponse response, String message) throws IOException {
        response.setStatus(405);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title", new Object[0])));
        out.println("</title></head>");
        out.println("<body>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.method", message)));
        out.println("</body>");
        out.println("</html>");
    }

    protected void warnMissingContextInformation() {
        logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.missingContextInformation", new Object[0])));
    }

    protected static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration enums = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (enums.hasMoreElements()) {
            String headerName = (String)enums.nextElement();
            String headerValue = req.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    public void registerEndpointUrlPattern(RuntimeEndpointInfo info) {
        String urlPattern = ((com.sun.xml.ws.server.RuntimeEndpointInfo)info).getUrlPattern();
        if (urlPattern.indexOf("*.") != -1) {
            logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.ignoringImplicitUrlPattern", ((com.sun.xml.ws.server.RuntimeEndpointInfo)info).getName())));
        } else if (urlPattern.endsWith("/*")) {
            this.pathUrlPatternEndpoints.add(info);
        } else if (this.fixedUrlPatternEndpoints.containsKey(urlPattern)) {
            logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.duplicateEndpointUrlPattern", ((com.sun.xml.ws.server.RuntimeEndpointInfo)info).getName())));
        } else {
            this.fixedUrlPatternEndpoints.put(urlPattern, info);
        }
    }

    protected String getValidPathForEndpoint(com.sun.xml.ws.server.RuntimeEndpointInfo info) {
        String s = info.getUrlPattern();
        if (s.endsWith("/*")) {
            return s.substring(0, s.length() - 2);
        }
        return s;
    }

    protected com.sun.xml.ws.server.RuntimeEndpointInfo getEndpointFor(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        com.sun.xml.ws.server.RuntimeEndpointInfo result = (com.sun.xml.ws.server.RuntimeEndpointInfo)this.fixedUrlPatternEndpoints.get(path);
        if (result == null) {
            for (com.sun.xml.ws.server.RuntimeEndpointInfo candidate : this.pathUrlPatternEndpoints) {
                if (!path.startsWith(this.getValidPathForEndpoint(candidate))) continue;
                result = candidate;
                break;
            }
        }
        return result;
    }

    protected boolean checkContentType(MimeHeaders headers) {
        String[] contentTypes = headers.getHeader("Content-Type");
        return contentTypes != null && contentTypes.length >= 1 && contentTypes[0].indexOf("text/xml") != -1;
    }

    protected boolean checkContentLength(MimeHeaders headers) {
        int length;
        String[] contentLength = headers.getHeader("Content-Length");
        return contentLength != null && contentLength.length > 0 && (length = new Integer(contentLength[0]).intValue()) > 0;
    }

    boolean checkForContent(MimeHeaders headers) {
        return this.checkContentType(headers) && this.checkContentLength(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Localizer getLocalizerFor(ServletRequest request) {
        Locale locale = request.getLocale();
        if (locale.equals(this.defaultLocalizer.getLocale())) {
            return this.defaultLocalizer;
        }
        Map map = this.localizerMap;
        synchronized (map) {
            Localizer localizer = (Localizer)this.localizerMap.get(locale);
            if (localizer == null) {
                localizer = new Localizer(locale);
                this.localizerMap.put(locale, localizer);
            }
            return localizer;
        }
    }

    protected QName getFaultServerQName() {
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    private void writeWebServicesHtmlPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.publishStatusPage) {
            Localizer localizer = this.getLocalizerFor((ServletRequest)request);
            response.setStatus(200);
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<html>");
            out.println("<head><title>");
            out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title", new Object[0])));
            out.println("</title></head>");
            out.println("<body>");
            out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title2", new Object[0])));
            if (this.jaxwsInfo == null) {
                out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.noInfoAvailable", new Object[0])));
            } else {
                out.println("<table width='100%' border='1'>");
                out.println("<tr>");
                out.println("<td>");
                out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.portName", new Object[0])));
                out.println("</td>");
                out.println("<td>");
                out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.status", new Object[0])));
                out.println("</td>");
                out.println("<td>");
                out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.information", new Object[0])));
                out.println("</td>");
                out.println("</tr>");
                String baseAddress = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                for (com.sun.xml.ws.server.RuntimeEndpointInfo info : this.jaxwsInfo) {
                    String endpointAddress = baseAddress + this.getValidPathForEndpoint(info);
                    out.println("<tr>");
                    out.println("<td>" + info.getName() + "</td>");
                    out.println("<td>");
                    if (info.isDeployed()) {
                        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.status.active", new Object[0])));
                    } else {
                        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.status.error", new Object[0])));
                    }
                    out.println("</td>");
                    out.println("<td>");
                    out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.information.table", endpointAddress, info.getPortName(), info.getImplementor().getClass().getName())));
                    out.println("</td>");
                    out.println("</tr>");
                }
                out.println("</table>");
            }
            out.println("</body>");
            out.println("</html>");
        }
    }
}

