/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.jersey.server.impl.model.parameter;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

/**
 *
 * @author Paul.Sandoz@Sun.Com
 */
public final class HttpContextInjectableProvider implements 
        InjectableProvider<Context, Type> {
        
    private static final class HttpContextInjectable extends AbstractHttpContextInjectable<Object> {
        public Object getValue(HttpContext context) {
            return context;
        }
    }
    
    private static final class HttpContextRequestInjectable extends AbstractHttpContextInjectable<Object> {
        public Object getValue(HttpContext context) {
            return context.getRequest();
        }
    }
    
    private static final class UriInfoInjectable extends AbstractHttpContextInjectable<UriInfo> {
        public UriInfo getValue(HttpContext context) {
            return context.getUriInfo();
        }
    }
    
    private final Map<Type, Injectable> injectables;
    
    public HttpContextInjectableProvider() {        
        injectables = new HashMap<Type, Injectable>();
        
        HttpContextRequestInjectable re = new HttpContextRequestInjectable();
        injectables.put(HttpHeaders.class, re);
        injectables.put(Request.class, re);
        injectables.put(SecurityContext.class, re);
        
        injectables.put(HttpContext.class, new HttpContextInjectable());
        
        injectables.put(UriInfo.class, new UriInfoInjectable());
        injectables.put(ExtendedUriInfo.class, new UriInfoInjectable());
    }
    
    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }
        
    public Injectable getInjectable(ComponentContext ic, Context a, Type c) {
        return injectables.get(c);
    }
}