/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.template;

import com.sun.jersey.api.view.Viewable;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.spi.template.ResolvedViewable;
import com.sun.jersey.spi.template.TemplateContext;
import com.sun.jersey.spi.template.TemplateContextException;
import com.sun.jersey.spi.template.TemplateProcessor;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.UriInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateFactory
implements TemplateContext {
    private final Set<TemplateProcessor> templates;

    public TemplateFactory(ProviderServices providerServices) {
        this.templates = providerServices.getProvidersAndServices(TemplateProcessor.class);
    }

    @Override
    public Set<TemplateProcessor> getTemplateProcessors() {
        return this.templates;
    }

    @Override
    public ResolvedViewable resolveViewable(Viewable v) {
        if (v.isTemplateNameAbsolute()) {
            return this.resolveAbsoluteViewable(v);
        }
        if (v.getResolvingClass() != null) {
            return this.resolveRelativeViewable(v, v.getResolvingClass());
        }
        if (v.getModel() == null) {
            throw new TemplateContextException("The model of the view MUST not be null");
        }
        return this.resolveRelativeViewable(v, v.getModel().getClass());
    }

    @Override
    public ResolvedViewable resolveViewable(Viewable v, UriInfo ui) {
        if (v.isTemplateNameAbsolute()) {
            return this.resolveAbsoluteViewable(v);
        }
        if (v.getResolvingClass() != null) {
            return this.resolveRelativeViewable(v, v.getResolvingClass());
        }
        List mrs = ui.getMatchedResources();
        if (mrs == null || mrs.size() == 0) {
            throw new TemplateContextException("There is no last matching resource available");
        }
        return this.resolveRelativeViewable(v, mrs.get(0).getClass());
    }

    @Override
    public ResolvedViewable resolveViewable(Viewable v, Class<?> resolvingClass) {
        if (v.isTemplateNameAbsolute()) {
            return this.resolveAbsoluteViewable(v);
        }
        if (v.getResolvingClass() != null) {
            return this.resolveRelativeViewable(v, v.getResolvingClass());
        }
        if (resolvingClass == null) {
            throw new TemplateContextException("Resolving class MUST not be null");
        }
        return this.resolveRelativeViewable(v, resolvingClass);
    }

    private ResolvedViewable resolveAbsoluteViewable(Viewable v) {
        for (TemplateProcessor t : this.getTemplateProcessors()) {
            String resolvedPath = t.resolve(v.getTemplateName());
            if (resolvedPath == null) continue;
            return new ResolvedViewable(t, resolvedPath, v.getModel());
        }
        return null;
    }

    private ResolvedViewable resolveRelativeViewable(Viewable v, Class<?> resolvingClass) {
        String resolvedPath;
        String absolutePath;
        Class<?> c;
        String path = v.getTemplateName();
        if (path == null || path.length() == 0) {
            path = "index";
        }
        for (c = resolvingClass; c != Object.class; c = c.getSuperclass()) {
            absolutePath = this.getAbsolutePath(c, path);
            for (TemplateProcessor t : this.getTemplateProcessors()) {
                resolvedPath = t.resolve(absolutePath);
                if (resolvedPath == null) continue;
                return new ResolvedViewable(t, resolvedPath, v.getModel(), c);
            }
        }
        for (c = resolvingClass; c != Object.class; c = c.getSuperclass()) {
            absolutePath = this.getAbsoluteName(c, path);
            for (TemplateProcessor t : this.getTemplateProcessors()) {
                resolvedPath = t.resolve(absolutePath);
                if (resolvedPath == null) continue;
                return new ResolvedViewable(t, resolvedPath, v.getModel(), c);
            }
        }
        return null;
    }

    private String getAbsolutePath(Class<?> resourceClass, String path) {
        return this.getAbsolutePath(resourceClass) + '/' + path;
    }

    private String getAbsolutePath(Class<?> resourceClass) {
        return '/' + resourceClass.getName().replace('.', '/').replace('$', '/');
    }

    private String getAbsoluteName(Class<?> resourceClass, String path) {
        return '/' + resourceClass.getName() + '.' + path;
    }
}

