/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClasspathResourceHelper;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceCache;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.WebappResourceHelper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class ResourceManager {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern CONFIG_MIMETYPE_PATTERN = Pattern.compile("[a-z-]*/[a-z0-9.\\*-]*");
    private ResourceHelper webappHelper = WebappResourceHelper.getInstance();
    private ResourceHelper classpathHelper = ClasspathResourceHelper.getInstance();
    private ResourceCache cache;
    private List<Pattern> compressableTypes;
    private ReentrantLock lock = new ReentrantLock();

    public ResourceManager(ResourceCache cache) {
        this.cache = cache;
        this.initCompressableTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceInfo findResource(String libraryName, String resourceName, String contentType, FacesContext ctx) {
        String localePrefix = this.getLocalePrefix(ctx);
        ResourceInfo info = this.getFromCache(resourceName, libraryName, localePrefix);
        if (info != null) return info;
        boolean compressable = this.isCompressable(contentType, ctx);
        if (compressable) {
            this.lock.lock();
            try {
                info = this.getFromCache(resourceName, libraryName, localePrefix);
                if (info != null || (info = this.doLookup(libraryName, resourceName, localePrefix, compressable, ctx)) == null) return info;
                this.addToCache(info);
                return info;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            info = this.doLookup(libraryName, resourceName, localePrefix, compressable, ctx);
            if (info == null) return info;
            this.addToCache(info);
        }
        return info;
    }

    private ResourceInfo doLookup(String libraryName, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        String resName;
        ResourceInfo info;
        LibraryInfo library = null;
        if (libraryName != null) {
            library = this.findLibrary(libraryName, localePrefix, ctx);
            if (library == null && localePrefix != null) {
                library = this.findLibrary(libraryName, null, ctx);
            }
            if (library == null) {
                return null;
            }
        }
        if ((info = this.findResource(library, resName = this.trimLeadingSlash(resourceName), localePrefix, compressable, ctx)) == null && localePrefix != null) {
            info = this.findResource(library, resName, null, compressable, ctx);
        }
        return info;
    }

    private ResourceInfo getFromCache(String name, String library, String localePrefix) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(name, library, localePrefix);
    }

    private void addToCache(ResourceInfo info) {
        if (this.cache == null) {
            return;
        }
        this.cache.add(info);
    }

    LibraryInfo findLibrary(String libraryName, String localePrefix, FacesContext ctx) {
        LibraryInfo library = this.webappHelper.findLibrary(libraryName, localePrefix, ctx);
        if (library == null) {
            library = this.classpathHelper.findLibrary(libraryName, localePrefix, ctx);
        }
        return library;
    }

    private ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        if (library != null) {
            return library.getHelper().findResource(library, resourceName, localePrefix, compressable, ctx);
        }
        ResourceInfo resource = this.webappHelper.findResource(null, resourceName, localePrefix, compressable, ctx);
        if (resource == null) {
            resource = this.classpathHelper.findResource(null, resourceName, localePrefix, compressable, ctx);
        }
        return resource;
    }

    private String getLocalePrefix(FacesContext context) {
        String localePrefix = null;
        String appBundleName = context.getApplication().getMessageBundle();
        if (null != appBundleName) {
            Locale locale = context.getApplication().getViewHandler().calculateLocale(context);
            try {
                ResourceBundle appBundle = ResourceBundle.getBundle(appBundleName, locale, Util.getCurrentLoader(ResourceManager.class));
                localePrefix = appBundle.getString("javax.faces.resource.localePrefix");
            }
            catch (MissingResourceException ignored) {
                // empty catch block
            }
        }
        return localePrefix;
    }

    private String trimLeadingSlash(String s) {
        if (s.charAt(0) == '/') {
            return s.substring(1);
        }
        return s;
    }

    private boolean isCompressable(String contentType, FacesContext ctx) {
        if (contentType == null || ctx.isProjectStage(ProjectStage.Development)) {
            return false;
        }
        if (this.compressableTypes != null && !this.compressableTypes.isEmpty()) {
            for (Pattern p : this.compressableTypes) {
                boolean matches = p.matcher(contentType).matches();
                if (!matches) continue;
                return true;
            }
        }
        return false;
    }

    private void initCompressableTypes() {
        String[] values;
        WebConfiguration config = WebConfiguration.getInstance();
        String value = config.getOptionValue(WebConfiguration.WebContextInitParameter.CompressableMimeTypes);
        if (value != null && value.length() > 0 && (values = Util.split(value, ",")) != null) {
            for (String s : values) {
                String pattern = s.trim();
                if (!this.isPatternValid(pattern)) continue;
                if (pattern.endsWith("/*")) {
                    pattern = pattern.substring(0, pattern.indexOf("/*"));
                    pattern = pattern + "/[a-z0-9.-]*";
                }
                if (this.compressableTypes == null) {
                    this.compressableTypes = new ArrayList<Pattern>(values.length);
                }
                try {
                    this.compressableTypes.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException pse) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "Mime type {0} doesn't match expected pattern {1}: ignoring.", new Object[]{pattern, pse.getPattern()});
                }
            }
        }
    }

    private boolean isPatternValid(String input) {
        return CONFIG_MIMETYPE_PATTERN.matcher(input).matches();
    }
}

