/**
 * Sencha GXT 3.1.1 - Sencha for GWT
 * Copyright(c) 2007-2014, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://www.sencha.com/products/gxt/license/
 */
package com.sencha.gxt.chart.client.draw.sprite;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.sencha.gxt.chart.client.draw.sprite.SpriteUpEvent.SpriteUpHandler;

/**
 * Fired when the mouse is released over a sprite in the draw component.
 */
public class SpriteUpEvent extends GwtEvent<SpriteUpHandler> {

  /**
   * A widget that implements this interface is a public source of
   * {@link SpriteUpEvent} events.
   */
  public interface HasSpriteUpHandlers {

    /**
     * Adds a {@link SpriteUpHandler} handler for {@link SpriteUpEvent} events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    HandlerRegistration addSpriteUpHandler(SpriteUpHandler handler);
  }

  /**
   * Handler class for {@link SpriteUpEvent} events.
   */
  public interface SpriteUpHandler extends EventHandler {

    /**
     * Fired when the mouse is released over a {@link Sprite}.
     * 
     * @param event the fired event
     */
    void onSpriteUp(SpriteUpEvent event);
  }

  /**
   * Handler type.
   */
  private static Type<SpriteUpHandler> TYPE;

  /**
   * Gets the type associated with this event.
   * 
   * @return returns the handler type
   */
  public static Type<SpriteUpHandler> getType() {
    if (TYPE == null) {
      TYPE = new Type<SpriteUpHandler>();
    }
    return TYPE;
  }

  private final Sprite sprite;
  private final Event event;

  /**
   * Creates a new event with the given sprite.
   * 
   * @param sprite the sprite that caused the event
   */
  public SpriteUpEvent(Sprite sprite, Event event) {
    this.sprite = sprite;
    this.event = event;
  }

  @Override
  public Type<SpriteUpHandler> getAssociatedType() {
    return getType();
  }

  /**
   * Returns the browser event that initiated the selection event.
   * 
   * @return the browser event that initiated the selection event
   */
  public Event getBrowserEvent() {
    return event;
  }

  /**
   * Returns the sprite that caused the event.
   * 
   * @return the sprite that caused the event
   */
  public Sprite getSprite() {
    return sprite;
  }

  @Override
  protected void dispatch(SpriteUpHandler handler) {
    handler.onSpriteUp(this);
  }

}
