/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.orientechnologies.common.console.DefaultConsoleReader;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODiscardedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStartupException;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.OLocalClusterStrategy;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLSyncCluster;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OCopyDatabaseChunkTask;
import com.orientechnologies.orient.server.distributed.task.ORestartNodeTask;
import com.orientechnologies.orient.server.distributed.task.OSyncDatabaseTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedDatabase;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedMessageService;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedRequest;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedResponse;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class OHazelcastPlugin
extends ODistributedAbstractPlugin
implements MembershipListener,
EntryListener<String, Object>,
OCommandOutputListener {
    public static final String CONFIG_DATABASE_PREFIX = "database.";
    protected static final String NODE_NAME_ENV = "ORIENTDB_NODE_NAME";
    protected static final String CONFIG_NODE_PREFIX = "node.";
    protected static final String CONFIG_DBSTATUS_PREFIX = "dbstatus.";
    protected static final int DEPLOY_DB_MAX_RETRIES = 10;
    protected String nodeId;
    protected String hazelcastConfigFile = "hazelcast.xml";
    protected Map<String, Member> activeNodes = new ConcurrentHashMap<String, Member>();
    protected OHazelcastDistributedMessageService messageService;
    protected long timeOffset = 0L;
    protected Date startedOn = new Date();
    protected volatile ODistributedServerManager.NODE_STATUS status = ODistributedServerManager.NODE_STATUS.OFFLINE;
    protected String membershipListenerRegistration;
    protected volatile HazelcastInstance hazelcastInstance;
    protected long lastClusterChangeOn;
    protected List<ODistributedLifecycleListener> listeners = new ArrayList<ODistributedLifecycleListener>();

    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        super.config(iServer, iParams);
        if (this.nodeName == null) {
            this.assignNodeName();
        }
        for (OServerParameterConfiguration param : iParams) {
            if (!param.name.equalsIgnoreCase("configuration.hazelcast")) continue;
            this.hazelcastConfigFile = OSystemVariableResolver.resolveSystemVariables((String)param.value);
        }
    }

    public void startup() {
        if (!this.enabled) {
            return;
        }
        OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.setValue((Object)-1);
        super.startup();
        this.status = ODistributedServerManager.NODE_STATUS.STARTING;
        String localNodeName = this.getLocalNodeName();
        this.activeNodes.clear();
        try {
            this.hazelcastInstance = this.configureHazelcast();
            this.nodeId = this.hazelcastInstance.getCluster().getLocalMember().getUuid();
            OLogManager.instance().info((Object)this, "Starting distributed server '%s' (hzID=%s) dbDir='%s'...", new Object[]{localNodeName, this.nodeId, this.serverInstance.getDatabaseDirectory()});
            this.timeOffset = System.currentTimeMillis() - this.hazelcastInstance.getCluster().getClusterTime();
            this.activeNodes.put(localNodeName, this.hazelcastInstance.getCluster().getLocalMember());
            this.membershipListenerRegistration = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)this);
            OServer.registerServerInstance((String)localNodeName, (OServer)this.serverInstance);
            IMap configurationMap = (IMap)this.getConfigurationMap();
            configurationMap.addEntryListener((EntryListener)this, true);
            for (Member m : this.hazelcastInstance.getCluster().getMembers()) {
                if (m.getUuid().equals(this.getLocalNodeId())) continue;
                String memberName = this.getNodeName(m);
                if (memberName != null) {
                    this.activeNodes.put(memberName, m);
                    continue;
                }
                if (m.equals(this.hazelcastInstance.getCluster().getLocalMember())) continue;
                ODistributedServerLog.warn((Object)((Object)this), (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot find configuration for member: %s", (Object[])new Object[]{m});
            }
            ODocument cfg = this.getLocalNodeConfiguration();
            ORecordInternal.setRecordSerializer((ORecord)cfg, (ORecordSerializer)ODatabaseDocumentTx.getDefaultSerializer());
            configurationMap.put((Object)(CONFIG_NODE_PREFIX + this.nodeId), (Object)cfg);
            if (!configurationMap.containsKey((Object)(CONFIG_NODE_PREFIX + this.nodeId))) {
                ODistributedServerLog.error((Object)((Object)this), (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on registering local node on cluster", (Object[])new Object[0]);
                throw new ODistributedStartupException("Error on registering local node on cluster");
            }
            this.messageService = new OHazelcastDistributedMessageService(this);
            this.installNewDatabases(true);
            this.loadDistributedDatabases();
            this.setNodeStatus(ODistributedServerManager.NODE_STATUS.ONLINE);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on starting distributed plugin", (Throwable)e, (Object[])new Object[0]);
            throw new ODistributedStartupException("Error on starting distributed plugin", (Throwable)e);
        }
    }

    public Throwable convertException(Throwable original) {
        if (original instanceof HazelcastException || original instanceof HazelcastInstanceNotActiveException) {
            return new IOException("Hazelcast wrapped exception: " + original.getMessage(), original.getCause());
        }
        return original;
    }

    public long getDistributedTime(long iTime) {
        return iTime - this.timeOffset;
    }

    public void sendShutdown() {
        this.shutdown();
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        OLogManager.instance().warn((Object)this, "Shutting down node %s...", new Object[]{this.getLocalNodeName()});
        super.shutdown();
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN);
        if (this.messageService != null) {
            this.messageService.shutdown();
        }
        this.activeNodes.clear();
        if (this.membershipListenerRegistration != null) {
            this.hazelcastInstance.getCluster().removeMembershipListener(this.membershipListenerRegistration);
        }
        if (this.hazelcastInstance != null) {
            try {
                this.hazelcastInstance.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on shutting down Hazelcast instance", (Throwable)e, new Object[0]);
            }
            finally {
                this.hazelcastInstance = null;
            }
        }
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
    }

    public ODocument getClusterConfiguration() {
        if (!this.enabled) {
            return null;
        }
        HazelcastInstance instance = this.getHazelcastInstance();
        if (instance == null) {
            return null;
        }
        ODocument cluster = new ODocument();
        cluster.field("localName", (Object)instance.getName());
        cluster.field("localId", (Object)instance.getCluster().getLocalMember().getUuid());
        ArrayList<ODocument> members = new ArrayList<ODocument>();
        cluster.field("members", members, new OType[]{OType.EMBEDDEDLIST});
        for (Member member : this.activeNodes.values()) {
            members.add(this.getNodeConfigurationById(member.getUuid()));
        }
        return cluster;
    }

    public ODocument getNodeConfigurationById(String iNodeId) {
        ODocument doc = (ODocument)this.getConfigurationMap().get(CONFIG_NODE_PREFIX + iNodeId);
        if (doc == null) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Cannot find node with id '%s'", (Object[])new Object[]{iNodeId});
        }
        return doc;
    }

    public ODocument getLocalNodeConfiguration() {
        ODocument nodeCfg = new ODocument();
        nodeCfg.field("id", (Object)this.getLocalNodeId());
        nodeCfg.field("name", (Object)this.getLocalNodeName());
        nodeCfg.field("startedOn", (Object)this.startedOn);
        nodeCfg.field("status", (Object)this.getNodeStatus());
        ArrayList listeners = new ArrayList();
        nodeCfg.field("listeners", listeners, new OType[]{OType.EMBEDDEDLIST});
        for (OServerNetworkListener listener : this.serverInstance.getNetworkListeners()) {
            HashMap<String, String> listenerCfg = new HashMap<String, String>();
            listeners.add(listenerCfg);
            listenerCfg.put("protocol", listener.getProtocolType().getSimpleName());
            listenerCfg.put("listen", listener.getListeningAddress(true));
        }
        nodeCfg.field("databases", this.getManagedDatabases());
        return nodeCfg;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ODistributedServerManager.NODE_STATUS getNodeStatus() {
        return this.status;
    }

    public void setNodeStatus(ODistributedServerManager.NODE_STATUS iStatus) {
        if (this.status.equals((Object)iStatus)) {
            return;
        }
        this.status = iStatus;
        ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"updated node status to '%s'", (Object[])new Object[]{this.status});
    }

    public boolean checkNodeStatus(ODistributedServerManager.NODE_STATUS iStatus2Check) {
        return this.status.equals((Object)iStatus2Check);
    }

    public ODistributedServerManager.DB_STATUS getDatabaseStatus(String iNode, String iDatabaseName) {
        ODistributedServerManager.DB_STATUS status = (ODistributedServerManager.DB_STATUS)this.getConfigurationMap().get(CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName);
        return status != null ? status : ODistributedServerManager.DB_STATUS.OFFLINE;
    }

    public void setDatabaseStatus(String iNode, String iDatabaseName, ODistributedServerManager.DB_STATUS iStatus) {
        this.getConfigurationMap().put(CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName, iStatus);
    }

    public Object sendRequest(String iDatabaseName, Collection<String> iClusterNames, Collection<String> iTargetNodes, OAbstractRemoteTask iTask, ODistributedRequest.EXECUTION_MODE iExecutionMode) {
        this.checkForClusterRebalance(iDatabaseName);
        OHazelcastDistributedRequest req = new OHazelcastDistributedRequest(this.getLocalNodeName(), iDatabaseName, iTask, iExecutionMode);
        ODatabaseDocumentInternal currentDatabase = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (currentDatabase != null && currentDatabase.getUser() != null) {
            req.setUserRID(currentDatabase.getUser().getIdentity().getIdentity());
        }
        OHazelcastDistributedDatabase db = this.messageService.getDatabase(iDatabaseName);
        if (iTargetNodes == null || iTargetNodes.isEmpty()) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"No nodes configured for partition '%s.%s' request: %s", (Object[])new Object[]{iDatabaseName, iClusterNames, req});
            throw new ODistributedException("No nodes configured for partition '" + iDatabaseName + "." + iClusterNames + "' request: " + req);
        }
        if (db == null) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed database '%s' not found", (Object[])new Object[]{iDatabaseName});
            throw new ODistributedException("Distributed database '" + iDatabaseName + "' not found on server '" + this.getLocalNodeName() + "'");
        }
        ODistributedResponse response = db.send2Nodes(req, iClusterNames, iTargetNodes, iExecutionMode);
        if (response != null) {
            return response.getPayload();
        }
        return null;
    }

    public Set<String> getManagedDatabases() {
        return this.messageService != null ? this.messageService.getDatabases() : Collections.EMPTY_SET;
    }

    public String getLocalNodeName() {
        return this.nodeName;
    }

    public String getLocalNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(ODatabaseInternal iDatabase) {
        String dbUrl = OSystemVariableResolver.resolveSystemVariables((String)iDatabase.getURL());
        if (dbUrl.startsWith("plocal:")) {
            String dbDirectory = this.serverInstance.getDatabaseDirectory();
            if (!dbUrl.substring("plocal:".length()).startsWith(dbDirectory)) {
                return;
            }
        } else if (dbUrl.startsWith("remote:")) {
            return;
        }
        ODatabaseDocumentInternal currDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            if (this.getConfigurationMap().containsKey(CONFIG_DATABASE_PREFIX + iDatabase.getName())) {
                throw new ODistributedException("Cannot create a new database with the same name of one available distributed");
            }
            OHazelcastDistributedDatabase distribDatabase = this.messageService.registerDatabase(iDatabase.getName());
            distribDatabase.configureDatabase(false, false, null).setOnline();
            this.onOpen(iDatabase);
        }
        finally {
            ODatabaseRecordThreadLocal.INSTANCE.set(currDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(ODatabaseInternal iDatabase) {
        String dbUrl = OSystemVariableResolver.resolveSystemVariables((String)iDatabase.getURL());
        if (dbUrl.startsWith("plocal:")) {
            String dbDirectory = this.serverInstance.getDatabaseDirectory();
            if (!dbUrl.substring("plocal:".length()).startsWith(dbDirectory)) {
                return;
            }
        } else if (dbUrl.startsWith("remote:")) {
            return;
        }
        ODatabaseDocumentInternal currDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            Map map = this.cachedDatabaseConfiguration;
            synchronized (map) {
                block15: {
                    ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
                    if (cfg != null) break block15;
                    return;
                }
                if (!(iDatabase.getStorage() instanceof ODistributedStorage) || ((ODistributedStorage)iDatabase.getStorage()).getDistributedManager().isOffline()) {
                    ODistributedStorage storage = (ODistributedStorage)this.storages.get(iDatabase.getURL());
                    if (storage == null) {
                        storage = new ODistributedStorage(this.serverInstance, (OAbstractPaginatedStorage)iDatabase.getStorage().getUnderlying());
                        ODistributedStorage oldStorage = this.storages.putIfAbsent(iDatabase.getURL(), storage);
                        if (oldStorage != null) {
                            storage = oldStorage;
                        }
                    }
                    iDatabase.replaceStorage((OStorage)storage);
                    this.installDbClustersLocalStrategy(iDatabase);
                }
            }
        }
        finally {
            ODatabaseRecordThreadLocal.INSTANCE.set(currDb);
        }
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
        ODistributedConfiguration cfg;
        if (OScenarioThreadLocal.INSTANCE.getRunMode() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return;
        }
        String dbUrl = OSystemVariableResolver.resolveSystemVariables((String)iDatabase.getURL());
        if (dbUrl.startsWith("plocal:")) {
            String dbDirectory = this.serverInstance.getDatabaseDirectory();
            if (!dbUrl.substring("plocal:".length()).startsWith(dbDirectory)) {
                return;
            }
        } else if (dbUrl.startsWith("remote:")) {
            return;
        }
        if ((cfg = this.getDatabaseConfiguration(iDatabase.getName())) == null) {
            return;
        }
        this.installClustersOfClass(iDatabase, iClass);
    }

    public void onDrop(ODatabaseInternal iDatabase) {
        super.onDrop(iDatabase);
        String dbName = iDatabase.getName();
        this.getConfigurationMap().remove(CONFIG_DBSTATUS_PREFIX + this.getLocalNodeName() + "." + dbName);
        int availableNodes = this.getAvailableNodes(dbName);
        if (availableNodes == 0) {
            this.getConfigurationMap().remove(CONFIG_DATABASE_PREFIX + dbName);
        }
    }

    public ODocument getStats() {
        ODocument doc = new ODocument();
        HashMap nodes = new HashMap();
        doc.field("nodes", nodes);
        HashMap<String, Object> localNode = new HashMap<String, Object>();
        doc.field("localNode", localNode);
        localNode.put("name", this.getLocalNodeName());
        localNode.put("averageResponseTime", this.messageService.getAverageResponseTime());
        HashMap databases = new HashMap();
        localNode.put("databases", databases);
        for (String string : this.messageService.getDatabases()) {
            HashMap db = new HashMap();
            databases.put(string, db);
        }
        for (Map.Entry entry : this.hazelcastInstance.getConfig().getQueueConfigs().entrySet()) {
            String queueName = (String)entry.getKey();
            if (!queueName.startsWith("orientdb.node.")) continue;
            IQueue queue = this.hazelcastInstance.getQueue(queueName);
            String[] names = queueName.split("\\.");
            HashMap<String, Serializable> node = (HashMap<String, Serializable>)nodes.get(names[2]);
            if (node == null) {
                node = new HashMap<String, Serializable>();
                nodes.put(names[2], node);
            }
            if (names[3].equals("response")) {
                node.put("responses", Integer.valueOf(queue.size()));
                continue;
            }
            String dbName = names[3];
            HashMap<String, Integer> db = (HashMap<String, Integer>)node.get(dbName);
            if (db == null) {
                db = new HashMap<String, Integer>(2);
                node.put(dbName, db);
            }
            db.put("requests", queue.size());
            Object lastMessage = queue.peek();
            if (lastMessage == null) continue;
            db.put("lastMessage", (Integer)((Object)lastMessage.toString()));
        }
        return doc;
    }

    public String getNodeName(Member iMember) {
        if (iMember == null) {
            return "?";
        }
        ODocument cfg = this.getNodeConfigurationById(iMember.getUuid());
        if (cfg != null) {
            return (String)cfg.field("name");
        }
        return "ext:" + iMember.getUuid();
    }

    public Set<String> getRemoteNodeIds() {
        return this.activeNodes.keySet();
    }

    public void memberAdded(MembershipEvent iEvent) {
        this.updateLastClusterChange();
        ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"added new node id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), this.getNodeName(iEvent.getMember())});
    }

    public void updateLastClusterChange() {
        this.lastClusterChangeOn = System.currentTimeMillis();
    }

    public void memberRemoved(MembershipEvent iEvent) {
        this.updateLastClusterChange();
        Member member = iEvent.getMember();
        String nodeName = this.getNodeName(member);
        if (nodeName != null) {
            for (ODistributedLifecycleListener l : this.listeners) {
                l.onNodeLeft(nodeName);
            }
            if (this.messageService != null) {
                for (String dbName : this.messageService.getDatabases()) {
                    this.messageService.getDatabase(dbName).unlockRecords(nodeName);
                    try {
                        if (this.getConfigurationMap().remove(CONFIG_DBSTATUS_PREFIX + nodeName + "." + dbName) == null) continue;
                        ODistributedServerLog.debug((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"removed dbstatus for '%s.%s' that just left: %s", (Object[])new Object[]{nodeName, dbName});
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "error on removing dbstatus for '%s.%s'", new Object[]{nodeName, dbName});
                    }
                }
            }
            this.activeNodes.remove(nodeName);
            if (this.messageService != null) {
                this.messageService.handleUnreachableNode(nodeName);
            }
            ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"node removed id=%s name=%s", (Object[])new Object[]{member, nodeName});
            if (nodeName.startsWith("ext:")) {
                List<String> registeredNodes = this.getRegisteredNodes();
                ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"removed node id=%s name=%s has not being recognized. Remove the node manually (registeredNodes=%s)", (Object[])new Object[]{member, nodeName, registeredNodes});
            }
        }
        this.serverInstance.getClientConnectionManager().pushDistribCfg2Clients(this.getClusterConfiguration());
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    public void entryAdded(EntryEvent<String, Object> iEvent) {
        if (iEvent.getMember() == null) {
            return;
        }
        String key = (String)iEvent.getKey();
        if (key.startsWith(CONFIG_NODE_PREFIX)) {
            if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember())) {
                ODocument cfg = (ODocument)iEvent.getValue();
                String nodeName = (String)cfg.field("name");
                if (nodeName.equals(this.getLocalNodeName())) {
                    ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), (String)this.getNodeName(iEvent.getMember()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)("Found a new node with the same name as current: '" + nodeName + "'. The node has been excluded. Change the name in its config/orientdb-dserver-config.xml file"), (Object[])new Object[0]);
                    throw new ODistributedException("Found a new node with the same name as current: '" + nodeName + "'. The node has been excluded. Change the name in its config/orientdb-dserver-config.xml file");
                }
                for (ODistributedLifecycleListener l : this.listeners) {
                    if (l.onNodeJoining(nodeName)) continue;
                    ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), (String)this.getNodeName(iEvent.getMember()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"denied node to join the cluster id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), this.getNodeName(iEvent.getMember())});
                    return;
                }
                this.activeNodes.put(nodeName, iEvent.getMember());
                ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), (String)this.getNodeName(iEvent.getMember()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"added node configuration id=%s name=%s, now %d nodes are configured", (Object[])new Object[]{iEvent.getMember(), this.getNodeName(iEvent.getMember()), this.activeNodes.size()});
                this.installNewDatabases(false);
            }
            for (ODistributedLifecycleListener l : this.listeners) {
                l.onNodeJoined(this.nodeName);
            }
        } else if (key.startsWith(CONFIG_DATABASE_PREFIX)) {
            String databaseName = key.substring(CONFIG_DATABASE_PREFIX.length());
            this.checkDatabaseEvent(iEvent, databaseName);
            if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember())) {
                this.installNewDatabases(false);
            }
        } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), (String)this.getNodeName(iEvent.getMember()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"received new status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
        }
    }

    public void entryUpdated(EntryEvent<String, Object> iEvent) {
        String key = (String)iEvent.getKey();
        String eventNodeName = this.getNodeName(iEvent.getMember());
        if (key.startsWith(CONFIG_NODE_PREFIX)) {
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"updated node configuration id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), eventNodeName});
            ODocument cfg = (ODocument)iEvent.getValue();
            this.activeNodes.put((String)cfg.field("name"), iEvent.getMember());
            this.updateLastClusterChange();
        } else if (key.startsWith(CONFIG_DATABASE_PREFIX)) {
            if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember())) {
                String databaseName = key.substring(CONFIG_DATABASE_PREFIX.length());
                ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"update configuration db=%s", (Object[])new Object[]{databaseName});
                this.checkDatabaseEvent(iEvent, databaseName);
            }
        } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"received updated status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
            this.updateLastClusterChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryRemoved(EntryEvent<String, Object> iEvent) {
        String key = (String)iEvent.getKey();
        if (key.startsWith(CONFIG_NODE_PREFIX)) {
            String nName = this.getNodeName(iEvent.getMember());
            if (nName != null) {
                ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"removed node configuration id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), nName});
                this.activeNodes.remove(nName);
            }
            this.updateLastClusterChange();
        } else if (key.startsWith(CONFIG_DATABASE_PREFIX)) {
            Map map = this.cachedDatabaseConfiguration;
            synchronized (map) {
                this.cachedDatabaseConfiguration.remove(key.substring(CONFIG_DATABASE_PREFIX.length()));
            }
            this.updateLastClusterChange();
        } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), (String)this.getNodeName(iEvent.getMember()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"received removed status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
            this.updateLastClusterChange();
        }
    }

    public void entryEvicted(EntryEvent<String, Object> iEvent) {
    }

    public void mapEvicted(MapEvent event) {
    }

    public void mapCleared(MapEvent event) {
    }

    public boolean isNodeAvailable(String iNodeName, String iDatabaseName) {
        return this.getDatabaseStatus(iNodeName, iDatabaseName) != ODistributedServerManager.DB_STATUS.OFFLINE;
    }

    public boolean isNodeOnline(String iNodeName, String iDatabaseName) {
        return this.getDatabaseStatus(iNodeName, iDatabaseName) == ODistributedServerManager.DB_STATUS.ONLINE;
    }

    public boolean isOffline() {
        return this.status != ODistributedServerManager.NODE_STATUS.ONLINE;
    }

    public void waitUntilOnline() throws InterruptedException {
        while (!this.status.equals((Object)ODistributedServerManager.NODE_STATUS.ONLINE)) {
            Thread.sleep(100L);
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        while (this.hazelcastInstance == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return this.hazelcastInstance;
    }

    public Lock getLock(String iName) {
        return this.getHazelcastInstance().getLock(iName);
    }

    public String toString() {
        return this.getLocalNodeName();
    }

    public Serializable executeOnLocalNode(ODistributedRequest req, ODatabaseDocumentTx database) {
        if (database != null && !(database.getStorage() instanceof ODistributedStorage)) {
            throw new ODistributedException("Distributed storage was not installed for database '" + database.getName() + "'. Implementation found: " + database.getStorage().getClass().getName());
        }
        OAbstractRemoteTask task = req.getTask();
        try {
            Serializable result;
            if (database != null) {
                ((ODistributedStorage)database.getStorage()).setLastOperationId(req.getId());
            }
            if ((result = (Serializable)task.execute(this.serverInstance, (ODistributedServerManager)this, database)) instanceof Throwable && !(result instanceof OException)) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), (String)req.getSenderNodeName(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on executing request %d (%s) on local node: ", (Throwable)((Throwable)result), (Object[])new Object[]{req.getId(), req.getTask()});
            }
            return result;
        }
        catch (Throwable e) {
            if (!(e instanceof OException)) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), (String)req.getSenderNodeName(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on executing distributed request %d on local node: %s", (Throwable)e, (Object[])new Object[]{req.getId(), req.getTask()});
            }
            return e;
        }
    }

    public OHazelcastDistributedMessageService getMessageService() {
        return this.messageService;
    }

    public void updateCachedDatabaseConfiguration(String iDatabaseName, ODocument cfg, boolean iSaveToDisk, boolean iDeployToCluster) {
        boolean updated = super.updateCachedDatabaseConfiguration(iDatabaseName, cfg, iSaveToDisk);
        if (updated && iDeployToCluster) {
            ORecordInternal.setRecordSerializer((ORecord)cfg, (ORecordSerializer)ODatabaseDocumentTx.getDefaultSerializer());
            this.getConfigurationMap().put(CONFIG_DATABASE_PREFIX + iDatabaseName, cfg);
        }
    }

    public long getLastClusterChangeOn() {
        return this.lastClusterChangeOn;
    }

    public void onMessage(String iText) {
        if (iText.startsWith("\r\n")) {
            iText = iText.substring(2);
        } else if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().info((Object)this, iText, new Object[0]);
    }

    public int getAvailableNodes(String iDatabaseName) {
        int availableNodes = 0;
        for (Map.Entry<String, Member> entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable(entry.getKey(), iDatabaseName)) continue;
            ++availableNodes;
        }
        return availableNodes;
    }

    public Map<String, Object> getConfigurationMap() {
        return this.getHazelcastInstance().getMap("orientdb");
    }

    public boolean installDatabase(boolean iStartup, String databaseName, ODocument config) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(databaseName);
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Current node started as %s for database '%s'", (Object[])new Object[]{cfg.getServerRole(this.nodeName), databaseName});
        Boolean hotAlignment = (Boolean)config.field("hotAlignment");
        boolean backupDatabase = iStartup && hotAlignment != null && hotAlignment == false;
        Set configuredDatabases = this.serverInstance.getAvailableStorageNames().keySet();
        if (configuredDatabases.contains(databaseName) && !backupDatabase) {
            return false;
        }
        OHazelcastDistributedDatabase distrDatabase = this.messageService.registerDatabase(databaseName);
        String queueName = OHazelcastDistributedMessageService.getRequestQueueName(this.messageService.manager.getLocalNodeName(), databaseName);
        this.messageService.getQueue(queueName);
        queueName = OHazelcastDistributedMessageService.getRequestQueueName(this.messageService.manager.getLocalNodeName(), databaseName + ".insert");
        this.messageService.getQueue(queueName);
        for (int retry = 0; retry < 10; ++retry) {
            if (!this.requestDatabase(distrDatabase, backupDatabase, databaseName, retry > 0)) continue;
            return true;
        }
        return false;
    }

    protected boolean requestDatabase(OHazelcastDistributedDatabase distrDatabase, boolean backupDatabase, String databaseName, boolean iAskToAllNodes) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(databaseName);
        List nodes = cfg.getServers(null, this.getLocalNodeName());
        ArrayList<String> selectedNodes = new ArrayList<String>();
        if (!iAskToAllNodes) {
            for (String f : nodes) {
                if (!this.isNodeAvailable(f, databaseName)) continue;
                selectedNodes.add(f);
                break;
            }
        }
        if (selectedNodes.isEmpty()) {
            selectedNodes.addAll(nodes);
        }
        ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"requesting deploy of database '%s' on local server...", (Object[])new Object[]{databaseName});
        Map results = (Map)this.sendRequest(databaseName, null, selectedNodes, (OAbstractRemoteTask)new OSyncDatabaseTask(OSyncDatabaseTask.MODE.FULL_REPLACE), ODistributedRequest.EXECUTION_MODE.RESPONSE);
        ODistributedServerLog.debug((Object)((Object)this), (String)this.getLocalNodeName(), (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"deploy returned: %s", (Object[])new Object[]{results});
        String dbPath = this.serverInstance.getDatabaseDirectory() + databaseName;
        for (Map.Entry r : results.entrySet()) {
            Object value = r.getValue();
            if (value instanceof Boolean) continue;
            if (value instanceof ODiscardedResponse) {
                ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"requesting deploy of database '%s' on local server failed, retrying...", (Object[])new Object[]{databaseName});
                return false;
            }
            if (value instanceof Throwable) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing database %s in %s", (Throwable)((Exception)value), (Object[])new Object[]{databaseName, dbPath});
                continue;
            }
            if (value instanceof ODistributedDatabaseChunk) {
                if (backupDatabase) {
                    this.backupCurrentDatabase(databaseName);
                }
                Set<String> toSyncClusters = this.installDatabaseFromNetwork(dbPath, databaseName, distrDatabase, (String)r.getKey(), (ODistributedDatabaseChunk)value);
                for (String cl : toSyncClusters) {
                    OCommandExecutorSQLSyncCluster.replaceCluster(this, this.serverInstance, databaseName, cl);
                }
                return true;
            }
            throw new IllegalArgumentException("Type " + value + " not supported");
        }
        throw new ODistributedException("No response received from remote nodes for auto-deploy of database");
    }

    protected void backupCurrentDatabase(String iDatabaseName) {
        Orient.instance().unregisterStorageByName(iDatabaseName);
        String providedBackupDirectoryPath = OGlobalConfiguration.DISTRIBUTED_BACKUP_DIRECTORY.getValueAsString();
        if (providedBackupDirectoryPath == null || OIOUtils.getStringContent((Object)providedBackupDirectoryPath).trim().isEmpty()) {
            return;
        }
        File providedPathFile = new File(providedBackupDirectoryPath);
        File backupParentPath = providedPathFile.isAbsolute() ? new File(providedBackupDirectoryPath) : new File(this.serverInstance.getDatabaseDirectory() + providedBackupDirectoryPath);
        File backupFullPath = new File(backupParentPath, iDatabaseName);
        if (!backupParentPath.exists()) {
            backupParentPath.mkdirs();
        } else if (backupFullPath.exists()) {
            OFileUtils.deleteRecursively((File)backupFullPath);
        }
        String dbPath = this.serverInstance.getDatabaseDirectory() + iDatabaseName;
        ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"moving existent database '%s' located in '%s' to '%s' and get a fresh copy from a remote node...", (Object[])new Object[]{iDatabaseName, dbPath, backupFullPath});
        File oldDirectory = new File(dbPath);
        if (!oldDirectory.renameTo(backupFullPath)) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on moving existent database '%s' located in '%s' to '%s'. Deleting old database...", (Object[])new Object[]{iDatabaseName, dbPath, backupFullPath});
            OFileUtils.deleteRecursively((File)oldDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> installDatabaseFromNetwork(final String dbPath, final String databaseName, OHazelcastDistributedDatabase distrDatabase, final String iNode, final ODistributedDatabaseChunk value) {
        distrDatabase.setWaitForMessage(value.getLastOperationId());
        final String fileName = Orient.getTempPath() + "install_" + databaseName + ".zip";
        String localNodeName = this.getLocalNodeName();
        ODistributedServerLog.info((Object)((Object)this), (String)localNodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"copying remote database '%s' to: %s", (Object[])new Object[]{databaseName, fileName});
        final File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            throw new ODistributedException("Error on creating temp database file to install locally", (Throwable)e);
        }
        File completedFile = new File(file.getAbsolutePath() + ".completed");
        if (completedFile.exists()) {
            completedFile.delete();
        }
        try {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.currentThread().setName("OrientDB installDatabase node=" + OHazelcastPlugin.this.nodeName + " db=" + databaseName);
                        ODistributedDatabaseChunk chunk = value;
                        FileOutputStream fOut = new FileOutputStream(fileName, false);
                        try {
                            long fileSize = OHazelcastPlugin.this.writeDatabaseChunk(1, chunk, fOut);
                            int chunkNum = 2;
                            while (!chunk.last) {
                                Object result = OHazelcastPlugin.this.sendRequest(databaseName, null, Collections.singleton(iNode), (OAbstractRemoteTask)new OCopyDatabaseChunkTask(chunk.filePath, chunkNum, chunk.offset + (long)chunk.buffer.length), ODistributedRequest.EXECUTION_MODE.RESPONSE);
                                if (!(result instanceof Boolean)) {
                                    if (result instanceof Exception) {
                                        ODistributedServerLog.error((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing database %s in %s (chunk #%d)", (Throwable)((Exception)result), (Object[])new Object[]{databaseName, dbPath, chunkNum});
                                    } else if (result instanceof ODistributedDatabaseChunk) {
                                        chunk = (ODistributedDatabaseChunk)result;
                                        fileSize += OHazelcastPlugin.this.writeDatabaseChunk(chunkNum, chunk, fOut);
                                    }
                                }
                                ++chunkNum;
                            }
                            fOut.flush();
                            new File(file.getAbsolutePath() + ".completed").createNewFile();
                            ODistributedServerLog.info((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"database copied correctly, size=%s", (Object[])new Object[]{OFileUtils.getSizeAsString((long)fileSize)});
                        }
                        finally {
                            try {
                                fOut.flush();
                                fOut.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception e) {
                        ODistributedServerLog.error((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{databaseName, fileName});
                        throw new ODistributedException("Error on transferring database", (Throwable)e);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{databaseName, fileName});
            throw new ODistributedException("Error on transferring database", (Throwable)e);
        }
        final ODatabaseDocumentTx db = this.installDatabaseOnLocalNode(distrDatabase, databaseName, dbPath, iNode, fileName);
        if (db != null) {
            db.close();
            OStorage stg = Orient.instance().getStorage(databaseName);
            if (stg != null) {
                stg.close();
            }
            Lock lock = this.getLock("orientdb." + databaseName + ".cfg");
            lock.lock();
            try {
                final ODistributedConfiguration cfg = this.getDatabaseConfiguration(db.getName());
                distrDatabase.configureDatabase(false, true, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        boolean distribCfgDirty = OHazelcastPlugin.this.installDbClustersForLocalNode((ODatabaseInternal)db, cfg);
                        if (distribCfgDirty) {
                            OLogManager.instance().warn((Object)this, "Distributed configuration modified", new Object[0]);
                            OHazelcastPlugin.this.updateCachedDatabaseConfiguration(db.getName(), cfg.serialize(), true, true);
                        }
                        return null;
                    }
                });
            }
            finally {
                lock.unlock();
            }
            db.activateOnCurrentThread();
            db.close();
        }
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(db.getName());
        Set localManagedClusters = cfg.getClustersOnServer(localNodeName);
        Set sourceNodeClusters = cfg.getClustersOnServer(iNode);
        localManagedClusters.removeAll(sourceNodeClusters);
        HashSet<String> toSynchClusters = new HashSet<String>();
        for (String cl : localManagedClusters) {
            if (cfg.getServers(cl, localNodeName).isEmpty()) continue;
            toSynchClusters.add(cl);
        }
        return toSynchClusters;
    }

    public void propagateSchemaChanges(ODatabaseInternal iDatabase) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
        if (cfg == null) {
            return;
        }
        for (OClass c : iDatabase.getMetadata().getSchema().getClasses()) {
            if (c.getClusterSelection() instanceof OLocalClusterStrategy) continue;
            this.installClustersOfClass(iDatabase, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void installClustersOfClass(ODatabaseInternal iDatabase, OClass iClass) {
        String databaseName = iDatabase.getName();
        if (!(iClass.getClusterSelection() instanceof OLocalClusterStrategy)) {
            ((OClassImpl)iClass).setClusterSelectionInternal((OClusterSelectionStrategy)new OLocalClusterStrategy((ODistributedServerManager)this, databaseName, iClass));
        }
        if (iClass.isAbstract()) {
            return;
        }
        int[] clusterIds = iClass.getClusterIds();
        ArrayList<String> clusterNames = new ArrayList<String>(clusterIds.length);
        for (int clusterId : clusterIds) {
            clusterNames.add(iDatabase.getClusterNameById(clusterId));
        }
        boolean distributedCfgDirty = false;
        Lock lock = this.getLock("orientdb." + databaseName + ".cfg");
        lock.lock();
        try {
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
            Set servers = cfg.getServers(null);
            for (String server : servers) {
                String bestCluster = cfg.getLocalCluster(clusterNames, server);
                if (bestCluster != null) continue;
                String newClusterName = (iClass.getName() + "_" + server).toLowerCase();
                HashSet<String> cfgClusterNames = new HashSet<String>();
                for (String cl : cfg.getClusterNames()) {
                    cfgClusterNames.add(cl);
                }
                if (cfgClusterNames.contains(newClusterName)) {
                    ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"class %s, change mastership of cluster '%s' (id=%d) to node '%s'", (Object[])new Object[]{iClass, newClusterName, iDatabase.getClusterIdByName(newClusterName), server});
                    cfg.setMasterServer(newClusterName, server);
                    distributedCfgDirty = true;
                    continue;
                }
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"class %s, creation of new cluster '%s' (id=%d)", (Object[])new Object[]{iClass, newClusterName, iDatabase.getClusterIdByName(newClusterName)});
                OScenarioThreadLocal.RUN_MODE currentDistributedMode = OScenarioThreadLocal.INSTANCE.getRunMode();
                if (currentDistributedMode != OScenarioThreadLocal.RUN_MODE.DEFAULT) {
                    OScenarioThreadLocal.INSTANCE.setRunMode(OScenarioThreadLocal.RUN_MODE.DEFAULT);
                }
                try {
                    iClass.addCluster(newClusterName);
                }
                catch (OCommandSQLParsingException e) {
                    if (!e.getMessage().endsWith("already exists")) {
                        throw e;
                    }
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on creating cluster '%s' in class '%s'", (Object[])new Object[]{newClusterName, iClass});
                    throw new ODistributedException("Error on creating cluster '" + newClusterName + "' in class '" + iClass + "'", (Throwable)e);
                }
                finally {
                    if (currentDistributedMode != OScenarioThreadLocal.RUN_MODE.DEFAULT) {
                        OScenarioThreadLocal.INSTANCE.setRunMode(OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED);
                    }
                }
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"class '%s', set mastership of cluster '%s' (id=%d) to '%s'", (Object[])new Object[]{iClass, newClusterName, iDatabase.getClusterIdByName(newClusterName), server});
                cfg.setMasterServer(newClusterName, server);
                distributedCfgDirty = true;
            }
            if (distributedCfgDirty) {
                boolean deployToCluster = this.isNodeOnline(this.getLocalNodeName(), databaseName);
                this.updateCachedDatabaseConfiguration(databaseName, cfg.serialize(), true, deployToCluster);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void checkDatabaseEvent(EntryEvent<String, Object> iEvent, String databaseName) {
        this.updateLastClusterChange();
        this.installNewDatabases(false);
        this.updateCachedDatabaseConfiguration(databaseName, (ODocument)iEvent.getValue(), true, false);
        this.serverInstance.getClientConnectionManager().pushDistribCfg2Clients(this.getClusterConfiguration());
        this.updateLastClusterChange();
    }

    protected boolean installDbClustersForLocalNode(ODatabaseInternal iDatabase, ODistributedConfiguration cfg) {
        String nodeName = this.getLocalNodeName();
        ODistributedConfiguration.ROLES role = cfg.getServerRole(nodeName);
        if (role != ODistributedConfiguration.ROLES.MASTER) {
            return false;
        }
        if (iDatabase.isClosed()) {
            this.getServerInstance().openDatabase(iDatabase);
        }
        OSchema schema = iDatabase.getDatabaseOwner().getMetadata().getSchema();
        boolean distribCfgDirty = false;
        for (Object cl : iDatabase.getClusterNames()) {
            if (!this.assignLocalClusters(iDatabase, cfg, (String)cl)) continue;
            distribCfgDirty = true;
        }
        for (OClass c : schema.getClasses()) {
            if (!this.installLocalClusterPerClass(iDatabase, cfg, c)) continue;
            distribCfgDirty = true;
        }
        return distribCfgDirty;
    }

    protected void installDbClustersLocalStrategy(ODatabaseInternal iDatabase) {
        if (iDatabase.isClosed()) {
            this.getServerInstance().openDatabase(iDatabase);
        }
        OSchema schema = iDatabase.getDatabaseOwner().getMetadata().getSchema();
        for (OClass c : schema.getClasses()) {
            ((OClassImpl)c).setClusterSelectionInternal((OClusterSelectionStrategy)new OLocalClusterStrategy((ODistributedServerManager)this, iDatabase.getName(), c));
        }
    }

    protected void assignNodeName() {
        this.nodeName = OSystemVariableResolver.resolveVariable((String)NODE_NAME_ENV);
        if (this.nodeName != null) {
            this.nodeName = this.nodeName.trim();
            if (this.nodeName.isEmpty()) {
                this.nodeName = null;
            }
        }
        if (this.nodeName == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println();
            System.out.println();
            System.out.println("+---------------------------------------------------------------+");
            System.out.println("|         WARNING: FIRST DISTRIBUTED RUN CONFIGURATION          |");
            System.out.println("+---------------------------------------------------------------+");
            System.out.println("| This is the first time that the server is running as          |");
            System.out.println("| distributed. Please type the name you want to assign to the   |");
            System.out.println("| current server node.                                          |");
            System.out.println("|                                                               |");
            System.out.println("| To avoid this message set the environment variable or JVM     |");
            System.out.println("| setting ORIENTDB_NODE_NAME to the server node name to use.    |");
            System.out.println("+---------------------------------------------------------------+");
            System.out.print("\nNode name [BLANK=auto generate it]: ");
            DefaultConsoleReader reader = new DefaultConsoleReader();
            try {
                this.nodeName = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.nodeName != null) {
                this.nodeName = this.nodeName.trim();
                if (this.nodeName.isEmpty()) {
                    this.nodeName = null;
                }
            }
        }
        if (this.nodeName == null) {
            this.nodeName = "node" + System.currentTimeMillis();
        }
        OLogManager.instance().warn((Object)this, "Assigning distributed node name: %s", new Object[]{this.nodeName});
        boolean found = false;
        OServerConfiguration cfg = this.serverInstance.getConfiguration();
        for (OServerHandlerConfiguration h : cfg.handlers) {
            if (!h.clazz.equals(((Object)((Object)this)).getClass().getName())) continue;
            for (OServerParameterConfiguration p : h.parameters) {
                if (!p.name.equals("nodeName")) continue;
                found = true;
                p.value = this.nodeName;
                break;
            }
            if (!found) {
                h.parameters = (OServerParameterConfiguration[])OArrays.copyOf((Object[])h.parameters, (int)(h.parameters.length + 1));
                h.parameters[h.parameters.length - 1] = new OServerParameterConfiguration("nodeName", this.nodeName);
            }
            try {
                this.serverInstance.saveConfiguration();
                break;
            }
            catch (IOException e) {
                throw new OConfigurationException("Cannot save server configuration", (Throwable)e);
            }
        }
    }

    protected HazelcastInstance configureHazelcast() throws FileNotFoundException {
        FileSystemXmlConfig config = new FileSystemXmlConfig(this.hazelcastConfigFile);
        config.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDistributedDatabases() {
        for (Map.Entry storageEntry : this.serverInstance.getAvailableStorageNames().entrySet()) {
            String databaseName = (String)storageEntry.getKey();
            if (this.messageService.getDatabase(databaseName) != null) continue;
            ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Opening database '%s'...", (Object[])new Object[]{databaseName});
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(databaseName);
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Current node started as %s for database '%s'", (Object[])new Object[]{cfg.getServerRole(this.nodeName), databaseName});
            boolean hotAlignment = cfg.isHotAlignment();
            OServerUserConfiguration replicatorUser = this.serverInstance.getUser("replicator");
            if (!this.getConfigurationMap().containsKey(CONFIG_DATABASE_PREFIX + databaseName)) {
                ODocument cfgDoc = cfg.serialize();
                ORecordInternal.setRecordSerializer((ORecord)cfgDoc, (ORecordSerializer)ODatabaseDocumentTx.getDefaultSerializer());
                this.getConfigurationMap().put(CONFIG_DATABASE_PREFIX + databaseName, cfgDoc);
            }
            OHazelcastDistributedDatabase db = this.messageService.registerDatabase(databaseName).configureDatabase(hotAlignment, hotAlignment, null);
            ODatabaseDocumentTx database = (ODatabaseDocumentTx)this.serverInstance.openDatabase("document", databaseName, replicatorUser.name, replicatorUser.password, null);
            try {
                cfg = this.getDatabaseConfiguration(databaseName);
                boolean distribCfgDirty = this.installDbClustersForLocalNode((ODatabaseInternal)database, cfg);
                if (!distribCfgDirty) continue;
                OLogManager.instance().info((Object)this, "Distributed configuration modified", new Object[0]);
                this.updateCachedDatabaseConfiguration(databaseName, cfg.serialize(), true, true);
            }
            finally {
                database.close();
            }
        }
    }

    protected void installNewDatabases(boolean iStartup) {
        if (this.activeNodes.size() <= 1) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.getConfigurationMap().entrySet()) {
            if (!entry.getKey().startsWith(CONFIG_DATABASE_PREFIX)) continue;
            String databaseName = entry.getKey().substring(CONFIG_DATABASE_PREFIX.length());
            ODocument config = (ODocument)entry.getValue();
            Boolean autoDeploy = (Boolean)config.field("autoDeploy");
            if (autoDeploy == null || !autoDeploy.booleanValue()) continue;
            this.installDatabase(iStartup, databaseName, config);
        }
    }

    protected long writeDatabaseChunk(int iChunkId, ODistributedDatabaseChunk chunk, FileOutputStream out) throws IOException {
        ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"- writing chunk #%d offset=%d size=%s", (Object[])new Object[]{iChunkId, chunk.offset, OFileUtils.getSizeAsString((long)chunk.buffer.length)});
        out.write(chunk.buffer);
        return chunk.buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODatabaseDocumentTx installDatabaseOnLocalNode(OHazelcastDistributedDatabase distrDatabase, String databaseName, String dbPath, String iNode, String iDatabaseCompressedFile) {
        ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"installing database '%s' to: %s...", (Object[])new Object[]{databaseName, dbPath});
        try {
            File f = new File(iDatabaseCompressedFile);
            final File fCompleted = new File(iDatabaseCompressedFile + ".completed");
            new File(dbPath).mkdirs();
            ODatabaseDocumentTx db = new ODatabaseDocumentTx("plocal:" + dbPath);
            FileInputStream in = new FileInputStream(f){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int read;
                    while ((read = super.read(b, off, len)) <= 0) {
                        if (fCompleted.exists()) {
                            return 0;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    return read;
                }
            };
            try {
                db.restore((InputStream)in, null, null, (OCommandOutputListener)this);
            }
            finally {
                in.close();
            }
            db.close();
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"installed database '%s'", (Object[])new Object[]{databaseName});
            return db;
        }
        catch (IOException e) {
            ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on copying database '%s' on local server", (Throwable)e, (Object[])new Object[]{databaseName});
            return null;
        }
    }

    protected ODocument loadDatabaseConfiguration(String iDatabaseName, File file) {
        ODocument cfg;
        if (this.hazelcastInstance != null && (cfg = (ODocument)this.getConfigurationMap().get(CONFIG_DATABASE_PREFIX + iDatabaseName)) != null) {
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"loaded database configuration from active cluster", (Object[])new Object[0]);
            this.updateCachedDatabaseConfiguration(iDatabaseName, cfg, false, false);
            return cfg;
        }
        return super.loadDatabaseConfiguration(iDatabaseName, file);
    }

    protected void checkForClusterRebalance(String iDatabaseName) {
        long timeout;
        if (this.activeNodes.size() <= 1) {
            return;
        }
        if (this.getAvailableNodes(iDatabaseName) <= 1) {
            return;
        }
        long averageResponseTime = this.messageService.getAverageResponseTime();
        if (averageResponseTime > (timeout = OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong()) * 75L / 100L) {
            long sleep = Math.abs(timeout - averageResponseTime);
            if (sleep > 3000L) {
                sleep = 3000L;
            }
            ODistributedServerLog.debug((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"slowing down request to avoid to fill queues. Wait for %dms (timeout=%d, averageResponseTime=%d)...", (Object[])new Object[]{sleep, timeout, averageResponseTime});
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized boolean assignLocalClusters(ODatabaseInternal iDatabase, ODistributedConfiguration cfg, String iClusterName) {
        String bestCluster;
        if (iClusterName.endsWith("_" + this.nodeName) && (bestCluster = cfg.getMasterServer(iClusterName)) == null) {
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"change mastership of cluster '%s' (id=%d) to local node '%s'", (Object[])new Object[]{iClusterName, iDatabase.getClusterIdByName(iClusterName), this.nodeName});
            cfg.setMasterServer(iClusterName, this.nodeName);
            return true;
        }
        return false;
    }

    private synchronized boolean installLocalClusterPerClass(ODatabaseInternal iDatabase, ODistributedConfiguration cfg, OClass iClass) {
        ((OClassImpl)iClass).setClusterSelectionInternal((OClusterSelectionStrategy)new OLocalClusterStrategy((ODistributedServerManager)this, iDatabase.getName(), iClass));
        if (iClass.isAbstract()) {
            return false;
        }
        int[] clusterIds = iClass.getClusterIds();
        ArrayList<String> clusterNames = new ArrayList<String>(clusterIds.length);
        for (int clusterId : clusterIds) {
            clusterNames.add(iDatabase.getClusterNameById(clusterId));
        }
        String bestCluster = cfg.getLocalCluster(clusterNames, this.nodeName);
        if (bestCluster == null) {
            String newClusterName = (iClass.getName() + "_" + this.getLocalNodeName()).toLowerCase();
            HashSet<String> cfgClusterNames = new HashSet<String>();
            for (String cl : cfg.getClusterNames()) {
                cfgClusterNames.add(cl.toLowerCase());
            }
            if (cfgClusterNames.contains(newClusterName)) {
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"class '%s', change mastership of cluster '%s' (id=%d) to local node '%s'", (Object[])new Object[]{iClass, newClusterName, iDatabase.getClusterIdByName(newClusterName), this.nodeName});
                cfg.setMasterServer(newClusterName, this.nodeName);
            } else {
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"class '%s', creation of new local cluster '%s' (id=%d)", (Object[])new Object[]{iClass, newClusterName, iDatabase.getClusterIdByName(newClusterName)});
                OScenarioThreadLocal.RUN_MODE currentDistributedMode = OScenarioThreadLocal.INSTANCE.getRunMode();
                if (currentDistributedMode != OScenarioThreadLocal.RUN_MODE.DEFAULT) {
                    OScenarioThreadLocal.INSTANCE.setRunMode(OScenarioThreadLocal.RUN_MODE.DEFAULT);
                }
                try {
                    iClass.addCluster(newClusterName);
                }
                catch (OCommandSQLParsingException e) {
                    if (!e.getMessage().endsWith("already exists")) {
                        throw e;
                    }
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on creating cluster '%s' in class '%s': ", (Object[])new Object[]{newClusterName, iClass, e});
                    throw new ODistributedException("Error on creating cluster '" + newClusterName + "' in class '" + iClass + "'", (Throwable)e);
                }
                finally {
                    if (currentDistributedMode != OScenarioThreadLocal.RUN_MODE.DEFAULT) {
                        OScenarioThreadLocal.INSTANCE.setRunMode(OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED);
                    }
                }
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"class '%s', set mastership of cluster '%s' (id=%d) to '%s'", (Object[])new Object[]{iClass, newClusterName, iDatabase.getClusterIdByName(newClusterName), this.nodeName});
                cfg.setMasterServer(newClusterName, this.nodeName);
            }
            return true;
        }
        return false;
    }

    public OHazelcastPlugin registerLifecycleListener(ODistributedLifecycleListener iListener) {
        this.listeners.add(iListener);
        return this;
    }

    public OHazelcastPlugin unregisterLifecycleListener(ODistributedLifecycleListener iListener) {
        this.listeners.remove(iListener);
        return this;
    }

    public void disconnectNode(String iNode) {
        HashSet<String> databases = new HashSet<String>();
        for (Map.Entry<String, Object> entry : this.getConfigurationMap().entrySet()) {
            String nodeDb;
            if (!entry.getKey().toString().startsWith(CONFIG_DBSTATUS_PREFIX) || !(nodeDb = entry.getKey().toString().substring(CONFIG_DBSTATUS_PREFIX.length())).startsWith(iNode)) continue;
            databases.add(entry.getKey());
        }
        for (String k : databases) {
            this.getConfigurationMap().put(k, ODistributedServerManager.DB_STATUS.OFFLINE);
        }
        IQueue queue = this.messageService.getQueue(OHazelcastDistributedMessageService.getResponseQueueName(iNode));
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"sending request of restarting node '%s'...", (Object[])new Object[]{iNode});
        OHazelcastDistributedResponse response = new OHazelcastDistributedResponse(-1L, this.nodeName, iNode, (Serializable)new ORestartNodeTask());
        try {
            queue.clear();
            if (!queue.offer((Object)response, OGlobalConfiguration.DISTRIBUTED_QUEUE_TIMEOUT.getValueAsLong(), TimeUnit.MILLISECONDS)) {
                throw new ODistributedException("Timeout on dispatching restart node request to node '" + iNode + "'");
            }
        }
        catch (InterruptedException e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Interrupted request to restart node '%s'", (Object[])new Object[]{iNode});
        }
    }

    private List<String> getRegisteredNodes() {
        ArrayList<String> registeredNodes = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.getConfigurationMap().entrySet()) {
            if (!entry.getKey().toString().startsWith(CONFIG_NODE_PREFIX)) continue;
            registeredNodes.add(entry.getKey().toString().substring(CONFIG_NODE_PREFIX.length()));
        }
        return registeredNodes;
    }

    public Set<String> getAvailableNodeNames(String iDatabaseName) {
        HashSet<String> nodes = new HashSet<String>();
        for (Map.Entry<String, Member> entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable(entry.getKey(), iDatabaseName)) continue;
            nodes.add(entry.getKey());
        }
        return nodes;
    }
}

