/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;

public class OHazelcastDistributedResponse
implements ODistributedResponse,
Externalizable {
    private long requestId;
    private String executorNodeName;
    private String senderNodeName;
    private Object payload;

    public OHazelcastDistributedResponse() {
    }

    public OHazelcastDistributedResponse(long iRequestId, String executorNodeName, String senderNodeName, Serializable payload) {
        this.requestId = iRequestId;
        this.executorNodeName = executorNodeName;
        this.senderNodeName = senderNodeName;
        this.payload = payload;
    }

    public boolean isExecutedOnLocalNode() {
        return this.getExecutorNodeName().equals(this.getSenderNodeName());
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String getExecutorNodeName() {
        return this.executorNodeName;
    }

    public String getSenderNodeName() {
        return this.senderNodeName;
    }

    public void setSenderNodeName(String senderNodeName) {
        this.senderNodeName = senderNodeName;
    }

    public Object getPayload() {
        return this.payload;
    }

    public ODistributedResponse setPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public ODistributedResponse setExecutorNodeName(String executorNodeName) {
        this.executorNodeName = executorNodeName;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.requestId);
        out.writeUTF(this.executorNodeName);
        out.writeUTF(this.senderNodeName);
        out.writeObject(this.payload);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.requestId = in.readLong();
        this.executorNodeName = in.readUTF();
        this.senderNodeName = in.readUTF();
        this.payload = (Serializable)in.readObject();
    }

    public String toString() {
        if (this.payload == null) {
            return "null";
        }
        if (this.payload.getClass().isArray()) {
            return Arrays.toString((Object[])this.payload);
        }
        return this.payload.toString();
    }
}

