/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OCopyDatabaseChunkTask;
import com.orientechnologies.orient.server.distributed.task.OSyncClusterTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLSyncCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "SYNC CLUSTER";
    public static final String KEYWORD_SYNC = "SYNC";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    private String clusterName;
    private OSyncClusterTask.MODE mode = OSyncClusterTask.MODE.FULL_REPLACE;

    public OCommandExecutorSQLSyncCluster parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLSyncCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_SYNC)) {
            throw new OCommandSQLParsingException("Keyword SYNC not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLSyncCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
            throw new OCommandSQLParsingException("Keyword CLUSTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLSyncCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Expected <cluster>. Use " + this.getSyntax(), this.parserText, pos);
        }
        this.clusterName = word.toString();
        if (this.clusterName == null) {
            throw new OCommandSQLParsingException("Cluster is null. Use " + this.getSyntax(), this.parserText, pos);
        }
        if ((pos = OCommandExecutorSQLSyncCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) > -1) {
            this.mode = OSyncClusterTask.MODE.valueOf((String)word.toString());
        }
        return this;
    }

    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLSyncCluster.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.CLUSTER, "sync", ORole.PERMISSION_UPDATE);
        String dbUrl = database.getURL();
        String path = dbUrl.substring(dbUrl.indexOf(":") + 1);
        OServer serverInstance = OServer.getInstanceByPath((String)path);
        OHazelcastPlugin dManager = (OHazelcastPlugin)serverInstance.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = database.getName();
        try {
            switch (this.mode) {
                case FULL_REPLACE: {
                    return OCommandExecutorSQLSyncCluster.replaceCluster(dManager, database, serverInstance, databaseName, this.clusterName);
                }
            }
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Cannot execute synchronization of cluster", (Throwable)e);
        }
        return "Mode not supported";
    }

    public static Object replaceCluster(OHazelcastPlugin dManager, ODatabaseDocumentInternal database, OServer serverInstance, String databaseName, String clusterName) throws IOException {
        return OCommandExecutorSQLSyncCluster.replaceCluster(dManager, serverInstance, databaseName, clusterName);
    }

    public static Object replaceCluster(OHazelcastPlugin dManager, OServer serverInstance, String databaseName, String clusterName) {
        ODistributedConfiguration cfg = dManager.getDatabaseConfiguration(databaseName);
        String dbPath = serverInstance.getDatabaseDirectory() + databaseName;
        String nodeName = dManager.getLocalNodeName();
        List nodesWhereClusterIsCfg = cfg.getServers(clusterName, null);
        nodesWhereClusterIsCfg.remove(nodeName);
        if (nodesWhereClusterIsCfg.isEmpty()) {
            throw new OCommandExecutionException("Cannot synchronize cluster '" + clusterName + "' because is not configured on any running nodes");
        }
        OSyncClusterTask task = new OSyncClusterTask(clusterName);
        Map results = (Map)dManager.sendRequest(databaseName, null, nodesWhereClusterIsCfg, (OAbstractRemoteTask)task, ODistributedRequest.EXECUTION_MODE.RESPONSE);
        File tempFile = null;
        OutputStream out = null;
        try {
            tempFile = new File(Orient.getTempPath() + "/backup_" + databaseName + "_" + clusterName + "_toInstall.zip");
            if (tempFile.exists()) {
                tempFile.delete();
            } else {
                tempFile.getParentFile().mkdirs();
            }
            tempFile.createNewFile();
            long fileSize = 0L;
            out = new FileOutputStream(tempFile, false);
            for (Map.Entry r : results.entrySet()) {
                Object value = r.getValue();
                if (value instanceof Boolean) continue;
                if (value instanceof Throwable) {
                    ODistributedServerLog.error(null, (String)nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing cluster %s in %s", (Throwable)((Exception)value), (Object[])new Object[]{databaseName, dbPath});
                    continue;
                }
                if (!(value instanceof ODistributedDatabaseChunk)) continue;
                ODistributedDatabaseChunk chunk = (ODistributedDatabaseChunk)value;
                File completedFile = new File(tempFile.getAbsolutePath() + ".completed");
                if (completedFile.exists()) {
                    completedFile.delete();
                }
                fileSize = OCommandExecutorSQLSyncCluster.writeDatabaseChunk(nodeName, 1, chunk, (FileOutputStream)out);
                int chunkNum = 2;
                while (!chunk.last) {
                    Object result = dManager.sendRequest(databaseName, null, Collections.singleton(r.getKey()), (OAbstractRemoteTask)new OCopyDatabaseChunkTask(chunk.filePath, chunkNum, chunk.offset + (long)chunk.buffer.length), ODistributedRequest.EXECUTION_MODE.RESPONSE);
                    if (!(result instanceof Boolean)) {
                        if (result instanceof Exception) {
                            ODistributedServerLog.error(null, (String)nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing database %s in %s (chunk #%d)", (Throwable)((Exception)result), (Object[])new Object[]{databaseName, dbPath, chunkNum});
                        } else if (result instanceof ODistributedDatabaseChunk) {
                            chunk = (ODistributedDatabaseChunk)result;
                            fileSize += OCommandExecutorSQLSyncCluster.writeDatabaseChunk(nodeName, chunkNum, chunk, (FileOutputStream)out);
                        }
                    }
                    ++chunkNum;
                }
                out.flush();
                new File(tempFile.getAbsolutePath() + ".completed").createNewFile();
            }
            String tempDirectoryPath = Orient.getTempPath() + "/backup_" + databaseName + "_" + clusterName + "_toInstall";
            File tempDirectory = new File(tempDirectoryPath);
            tempDirectory.mkdirs();
            OZIPCompressionUtil.uncompressDirectory((InputStream)new FileInputStream(tempFile), (String)tempDirectory.getAbsolutePath(), null);
            OAbstractPaginatedStorage stg = (OAbstractPaginatedStorage)OCommandExecutorSQLSyncCluster.getDatabase().getStorage().getUnderlying();
            OPaginatedCluster cluster = (OPaginatedCluster)stg.getClusterByName(clusterName);
            File tempClusterFile = new File(tempDirectoryPath + "/" + clusterName + ".pcl");
            cluster.replaceFile(tempClusterFile);
            OCommandExecutorSQLSyncCluster.getDatabase().getLocalCache().invalidate();
            String string = String.format("Cluster correctly replaced, transferred %d bytes", fileSize);
            return string;
        }
        catch (Exception e) {
            ODistributedServerLog.error(null, (String)nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{databaseName, tempFile});
            throw new ODistributedException("Error on transferring database", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public String getSyntax() {
        return "SYNC CLUSTER <name> [-full_replace|-merge]";
    }

    protected static long writeDatabaseChunk(String iNodeName, int iChunkId, ODistributedDatabaseChunk chunk, FileOutputStream out) throws IOException {
        ODistributedServerLog.warn(null, (String)iNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"- writing chunk #%d offset=%d size=%s", (Object[])new Object[]{iChunkId, chunk.offset, OFileUtils.getSizeAsString((long)chunk.buffer.length)});
        out.write(chunk.buffer);
        return chunk.buffer.length;
    }
}

