/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.beans.PropertyChangeEvent;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import oracle.jdbc.TraceKey;
import oracle.jdbc.diagnostics.AbstractDiagnosable;
import oracle.jdbc.diagnostics.Diagnostic;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.MetricsImpl;
import oracle.jdbc.diagnostics.MutableTraceAttributes;
import oracle.jdbc.diagnostics.OracleTraceKey;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.diagnostics.TraceAttributes;
import oracle.jdbc.driver.PhysicalConnection;

public class ConnectionDiagnosable
extends AbstractDiagnosable {
    private static final String CLASS_NAME = ConnectionDiagnosable.class.getName();
    private MutableTraceAttributes currentTraceAttributes = new MutableTraceAttributes();
    private final PhysicalConnection physicalConnection;
    private static final Metrics DEFAULT_METRICS = new Metrics();
    private Metrics metrics = DEFAULT_METRICS;
    private final SqlDiagnostics sqlDiagnostics = new SqlDiagnostics();
    private final TenantDiagnostics tenantDiagnostics = new TenantDiagnostics();
    private boolean debugCurrentTenantEnabled = false;
    private boolean debugEnabled = false;
    protected Boolean isLoggingExplicitlyDisabled = false;
    private volatile boolean isDiagnoseFirstFailureEnabled = false;

    public ConnectionDiagnosable(PhysicalConnection physicalConnection) {
        this.physicalConnection = physicalConnection;
        if (ConnectionDiagnosable.isMetricsEnabled()) {
            this.metrics = new MetricsImpl();
        }
    }

    @Override
    public void begin(Metrics.ConnectionEvent event) {
        this.metrics.begin(event);
    }

    @Override
    public void begin(Metrics.ConnectionEvent event, int retryCount) {
        this.metrics.begin(event, retryCount);
    }

    @Override
    public void end(Metrics.ConnectionEvent event) {
        this.metrics.end(event);
    }

    @Override
    public void end(Metrics.ConnectionEvent event, int retryCount) {
        this.metrics.end(event, retryCount);
    }

    @Override
    public void onClose() {
        this.metrics.close();
    }

    protected void init() {
        int bufferSize = AbstractDiagnosable.IS_VALID_BUFFER_SIZE.test(String.valueOf(this.physicalConnection.diagnosticBufferSize)) ? this.physicalConnection.diagnosticBufferSize : Integer.parseInt("1000");
        this.diagnostic = Diagnostic.get(this.physicalConnection.diagnosticLoggerName, bufferSize);
        this.setDiagnoseFirstFailureEnabled(this.physicalConnection.isDiagnoseFirstFailureEnabled);
        this.setDebugEnabled(this.isLoggingExplicitlyDisabled != false ? false : this.physicalConnection.isLoggingEnabled || ConnectionDiagnosable.isGlobalDebugEnabled());
        this.setSensitiveEnabled(this.physicalConnection.isSensitiveDiagnosticsEnabled);
        this.sqlDiagnostics.init();
        this.tenantDiagnostics.init();
    }

    @Override
    protected void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    @Override
    protected void setDiagnoseFirstFailureEnabled(boolean enabled) {
        this.isDiagnoseFirstFailureEnabled = enabled;
    }

    @Override
    protected boolean isSensitivePermitted() {
        return this.physicalConnection.isPermitSensitiveDiagnostics;
    }

    @Override
    protected String getDiagnosticLoggerName() {
        return this.physicalConnection.diagnosticLoggerName;
    }

    @Override
    protected TraceAttributes getTraceAttributes() {
        return this.currentTraceAttributes;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object newValue = event.getNewValue();
        try {
            switch (event.getPropertyName()) {
                case "Event-Enable-DiagnoseFirstFailure-By-Conn-Prefix": {
                    if (((String)newValue).equalsIgnoreCase(this.physicalConnection.getNetConnectionIdPrefix())) {
                        this.setDiagnoseFirstFailureEnabled(true);
                    }
                    break;
                }
                case "Event-Disable-DiagnoseFirstFailure-By-Conn-Prefix": {
                    if (((String)newValue).equalsIgnoreCase(this.physicalConnection.getNetConnectionIdPrefix())) {
                        this.setDiagnoseFirstFailureEnabled(false);
                    }
                    break;
                }
                case "Event-Enable-DiagnoseFirstFailure-By-Tenant-Name": {
                    if (((String)newValue).equalsIgnoreCase(this.tenantDiagnostics.getCurrentTenantName())) {
                        this.setDiagnoseFirstFailureEnabled(true);
                    }
                    break;
                }
                case "Event-Disable-DiagnoseFirstFailure-By-Tenant-Name": {
                    if (((String)newValue).equalsIgnoreCase(this.tenantDiagnostics.getCurrentTenantName())) {
                        this.setDiagnoseFirstFailureEnabled(false);
                    }
                    break;
                }
                case "Event-Enable-Logging-By-Conn-Prefix": {
                    if (((String)newValue).equalsIgnoreCase(this.physicalConnection.getNetConnectionIdPrefix())) {
                        this.setDebugEnabled(true);
                    }
                    break;
                }
                case "Event-Disable-Logging-By-Conn-Prefix": {
                    if (((String)newValue).equalsIgnoreCase(this.physicalConnection.getNetConnectionIdPrefix())) {
                        this.setDebugEnabled(false);
                    }
                    break;
                }
                case "Event-Enable-Logging-By-Tenant-Name": {
                    if (((String)newValue).equalsIgnoreCase(this.tenantDiagnostics.getCurrentTenantName())) {
                        this.setDebugEnabled(true);
                    }
                    break;
                }
                case "Event-Disable-Logging-By-Tenant-Name": {
                    if (((String)newValue).equalsIgnoreCase(this.tenantDiagnostics.getCurrentTenantName())) {
                        this.setDebugEnabled(false);
                    }
                    break;
                }
                case "Event-Enable-Sensitive-Diagnostics-By-Conn-Prefix": {
                    if (((String)newValue).equalsIgnoreCase(this.physicalConnection.getNetConnectionIdPrefix())) {
                        this.setSensitiveEnabled(true);
                    }
                    break;
                }
                case "Event-Disable-Sensitive-Diagnostics-By-Conn-Prefix": {
                    if (((String)newValue).equalsIgnoreCase(this.physicalConnection.getNetConnectionIdPrefix())) {
                        this.setSensitiveEnabled(false);
                    }
                    break;
                }
                case "Event-Enable-Sensitive-Diagnostics-By-Tenant-Name": {
                    if (((String)newValue).equalsIgnoreCase(this.tenantDiagnostics.getCurrentTenantName())) {
                        this.diagnostic.enableSensitive(true);
                    }
                    break;
                }
                case "Event-Disable-Sensitive-Diagnostics-By-Tenant-Name": {
                    if (((String)newValue).equalsIgnoreCase(this.tenantDiagnostics.getCurrentTenantName())) {
                        this.diagnostic.enableSensitive(false);
                    }
                    break;
                }
                case "Event-Update-Diagnostic-Level-By-Conn-Prefix": {
                    if (((Object[])newValue)[0].equals(this.physicalConnection.getNetConnectionIdPrefix())) {
                        this.diagnostic.setLoggingLevel((String)((Object[])newValue)[1]);
                    }
                    break;
                }
                case "Event-Update-Diagnostic-Level-By-Tenant-Name": {
                    if (((Object[])newValue)[0].equals(this.tenantDiagnostics.getCurrentTenantName())) {
                        this.diagnostic.setLoggingLevel((String)((Object[])newValue)[1]);
                    }
                    break;
                }
                case "Event-Update-DiagnoseFirstFailure-Size-By-Conn-Prefix": {
                    if (((Object[])newValue)[0].equals(this.physicalConnection.getNetConnectionIdPrefix()) && IS_VALID_BUFFER_SIZE.test(String.valueOf((Integer)((Object[])newValue)[1]))) {
                        this.diagnostic.setDiagnoseFirstFailureBufferSize((Integer)((Object[])newValue)[1]);
                    }
                    break;
                }
                case "Event-Update-DiagnoseFirstFailure-Size-By-Tenant-Name": {
                    if (((Object[])newValue)[0].equals(this.tenantDiagnostics.getCurrentTenantName()) && IS_VALID_BUFFER_SIZE.test(String.valueOf((Integer)((Object[])newValue)[1]))) {
                        this.diagnostic.setDiagnoseFirstFailureBufferSize((Integer)((Object[])newValue)[1]);
                    }
                    break;
                }
                case "Event-Dump-DiagnoseFirstFailure": {
                    if (this.isDiagnoseFirstFailureEnabled) {
                        this.diagnostic.dumpDiagnoseFirstFailure(false);
                    }
                    break;
                }
                default: {
                    this.abstractPropertyChange(event);
                    break;
                }
            }
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
    }

    void enableDebugTenant(String tenantName) {
        this.tenantDiagnostics.enableDebugTenant(tenantName);
    }

    protected void dumpDiagnoseFirstFailure() throws SQLException {
        if (this.isDiagnoseFirstFailureEnabled) {
            this.diagnostic.dumpDiagnoseFirstFailure(true);
        }
    }

    protected void addConfig(Properties properties) {
        this.diagnostic.addConfig(properties);
    }

    @Override
    public final void beginCurrentSql(String originalSql) {
        this.sqlDiagnostics.beginCurrentSql(originalSql);
    }

    @Override
    public final void endCurrentSql() {
        this.sqlDiagnostics.endCurrentSql();
    }

    protected void setTraceAttribute(TraceKey key, String value) {
        this.currentTraceAttributes.set(key, value);
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public final boolean isDiagnoseFirstFailureEnabled() {
        return this.isDiagnoseFirstFailureEnabled;
    }

    private class SqlDiagnostics {
        private final Set<Integer> debugSqlsSet = new HashSet<Integer>();
        private static final int LOG_SQL_DEPTH = 8;
        private int top = -1;
        private final boolean[] rememberDebugEnabled = new boolean[8];
        private String currentSql = null;
        private final String[] rememberCurrentSql = new String[8];
        private long sqlExecutionStartTime;

        private SqlDiagnostics() {
        }

        void init() {
            if (((ConnectionDiagnosable)ConnectionDiagnosable.this).physicalConnection.debugSQLs != null) {
                ConnectionDiagnosable.this.physicalConnection.getOracleJsonFactory().createJsonTextValue(new StringReader(((ConnectionDiagnosable)ConnectionDiagnosable.this).physicalConnection.debugSQLs)).asJsonArray().forEach(debugSql -> this.debugSqlsSet.add(debugSql.asJsonString().getString().hashCode()));
            }
        }

        public final void beginCurrentSql(String originalSql) {
            assert (this.top < 7);
            ++this.top;
            Function<String, Boolean> contains = sql -> sql != null && this.debugSqlsSet.contains(sql.hashCode());
            this.rememberDebugEnabled[this.top] = ConnectionDiagnosable.this.debugEnabled;
            boolean debugCurrentSql = contains.apply(originalSql);
            if (!ConnectionDiagnosable.this.debugEnabled) {
                ConnectionDiagnosable.this.debugEnabled = debugCurrentSql;
            }
            this.rememberCurrentSql[this.top] = this.currentSql;
            this.currentSql = originalSql;
            ConnectionDiagnosable.this.setTraceAttribute(OracleTraceKey.SQL, this.currentSql);
            this.sqlExecutionStartTime = System.currentTimeMillis();
        }

        public final void endCurrentSql() {
            long sqlExecutionTime = System.currentTimeMillis() - this.sqlExecutionStartTime;
            ConnectionDiagnosable.this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "endCurrentSql", "sql={0}, time={1}ms", (String)null, null, (Object)this.currentSql, (Object)sqlExecutionTime);
            assert (this.top > -1);
            this.currentSql = this.rememberCurrentSql[this.top];
            ConnectionDiagnosable.this.debugEnabled = this.rememberDebugEnabled[this.top];
            --this.top;
            ConnectionDiagnosable.this.setTraceAttribute(OracleTraceKey.SQL, this.currentSql);
        }
    }

    private class TenantDiagnostics {
        private final Map<String, String> canonicalTenantNames = new IdentityHashMap<String, String>();
        private String currentTenantName = null;
        private final Set<String> debugTenantsSet = new HashSet<String>();

        private TenantDiagnostics() {
        }

        void init() {
            if (((ConnectionDiagnosable)ConnectionDiagnosable.this).physicalConnection.debugTenants != null) {
                ConnectionDiagnosable.this.physicalConnection.getOracleJsonFactory().createJsonTextValue(new StringReader(((ConnectionDiagnosable)ConnectionDiagnosable.this).physicalConnection.debugTenants)).asJsonArray().forEach(debugTenant -> this.debugTenantsSet.add(this.canonicalTenantName(debugTenant.asJsonString().getString())));
            }
        }

        public final void enableDebugTenant(String tenantName) {
            if (tenantName != null) {
                this.setCurrentTenantName(tenantName);
                if (this.isDebugCurrentTenant()) {
                    ConnectionDiagnosable.this.debugEnabled = true;
                }
            }
        }

        private void setCurrentTenantName(String name) {
            String n = this.canonicalTenantName(name);
            if (!n.equals(this.currentTenantName)) {
                this.currentTenantName = n;
                ConnectionDiagnosable.this.setTraceAttribute(OracleTraceKey.TENANT, this.currentTenantName);
            }
        }

        public final String getCurrentTenantName() {
            return this.currentTenantName;
        }

        private boolean isDebugCurrentTenant() {
            ConnectionDiagnosable.this.debugCurrentTenantEnabled = this.debugTenantsSet.contains(this.currentTenantName);
            return ConnectionDiagnosable.this.debugCurrentTenantEnabled;
        }

        public final boolean isDebugTenantEnabled(String tenantName) {
            return this.debugTenantsSet.contains(tenantName.hashCode());
        }

        private String canonicalTenantName(String tenantName) {
            String t = this.canonicalTenantNames.get(tenantName);
            if (t == null) {
                this.canonicalTenantNames.put(tenantName, tenantName);
                t = tenantName;
            }
            return t;
        }
    }
}

