/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.driver.NTFDCNConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;

class NTFDCNConnectionGroup
implements Monitor {
    private static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS = 16;
    private ArrayList<NTFDCNConnection> dcnListenerConnections = new ArrayList();
    private final String groupId;
    private int noOfRegistrationsInThisGroup = 0;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    NTFDCNConnectionGroup(String groupId) {
        this.groupId = groupId;
    }

    NTFDCNConnection getNTFDCNConnection() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            ++this.noOfRegistrationsInThisGroup;
            if (this.noOfRegistrationsInThisGroup > MAX_NTF_CONNECTIONS) {
                int minimumRegistrations = this.noOfRegistrationsInThisGroup;
                NTFDCNConnection connectionWithMinimumRegistrations = this.dcnListenerConnections.get(0);
                for (NTFDCNConnection listenerConnection : this.dcnListenerConnections) {
                    int numberOfRegistrationsInConnection = listenerConnection.getNumberOfRegistrations();
                    if (numberOfRegistrationsInConnection >= minimumRegistrations) continue;
                    connectionWithMinimumRegistrations = listenerConnection;
                    minimumRegistrations = numberOfRegistrationsInConnection;
                }
                connectionWithMinimumRegistrations.incrementNumberOfRegistrations(1);
                NTFDCNConnection nTFDCNConnection = connectionWithMinimumRegistrations;
                return nTFDCNConnection;
            }
            NTFDCNConnection nTFDCNConnection = null;
            return nTFDCNConnection;
        }
    }

    void startDCNListenerConnection(String instanceName, String serviceName, String userName, OpaqueString password, Properties connectionProps, ArrayList<String> listenerAddresses, String clientId, int numberOfRegistrations) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            assert (clientId != null) : "dcnConnectionId is null";
            String connClass = "notify" + clientId;
            NTFDCNConnection dcnListenerConnection = new NTFDCNConnection(clientId, listenerAddresses, instanceName, serviceName, userName, password, connectionProps, connClass, numberOfRegistrations);
            this.dcnListenerConnections.add(dcnListenerConnection);
            dcnListenerConnection.setDaemon(true);
            dcnListenerConnection.start();
        }
    }

    void stopNTFDCNConnection(String clientId) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (clientId == null || clientId.length() == 0) {
                return;
            }
            for (NTFDCNConnection listenerConnection : this.dcnListenerConnections) {
                if (listenerConnection == null || !clientId.equals(listenerConnection.getClientId())) continue;
                listenerConnection.decrementNumberOfRegistrations(1);
                if (listenerConnection.getNumberOfRegistrations() <= 0) {
                    listenerConnection.setNeedToBeClosed(true);
                }
                break;
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

