/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.DatabasePreparer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public final class LiquibasePreparer
implements DatabasePreparer {
    private final String location;
    private final Contexts contexts;

    public static LiquibasePreparer forClasspathLocation(String location) {
        return new LiquibasePreparer(location, new Contexts());
    }

    public static LiquibasePreparer forClasspathLocation(String location, Contexts contexts) {
        return new LiquibasePreparer(location, contexts);
    }

    private LiquibasePreparer(String location, Contexts contexts) {
        this.location = location;
        this.contexts = contexts;
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        try (Connection connection = ds.getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase(this.location, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update(this.contexts);
        }
        catch (LiquibaseException e) {
            throw new SQLException(e);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof LiquibasePreparer && Objects.equals(this.location, ((LiquibasePreparer)obj).location);
    }

    public int hashCode() {
        return Objects.hashCode(this.location);
    }
}

