/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.Phaser;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

final class EmbeddedUtil {
    static final Logger LOG = LoggerFactory.getLogger(EmbeddedPostgres.class);
    static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%s/%s?user=%s";
    static final String PG_STOP_MODE = "fast";
    static final String PG_STOP_WAIT_S = "5";
    static final String PG_SUPERUSER = "postgres";
    static final Duration DEFAULT_PG_STARTUP_WAIT = Duration.ofSeconds(10L);
    static final String LOCK_FILE_NAME = "epg-lock";

    private EmbeddedUtil() {
    }

    static File getWorkingDirectory() {
        File tempWorkingDirectory = new File(System.getProperty("java.io.tmpdir"), "embedded-pg");
        return new File(System.getProperty("ot.epg.working-dir", tempWorkingDirectory.getPath()));
    }

    static void mkdirs(File dir) {
        if (!(dir.mkdirs() || dir.isDirectory() && dir.exists())) {
            throw new IllegalStateException("could not create " + dir);
        }
    }

    static String getOS() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "Windows";
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return "Darwin";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "Linux";
        }
        throw new UnsupportedOperationException("Unknown OS " + SystemUtils.OS_NAME);
    }

    static String getArchitecture() {
        return "amd64".equals(SystemUtils.OS_ARCH) ? "x86_64" : SystemUtils.OS_ARCH;
    }

    static void extractTxz(InputStream stream, String targetDir) throws IOException {
        try (XZInputStream xzIn = new XZInputStream(stream);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)xzIn);){
            TarArchiveEntry entry;
            final Phaser phaser = new Phaser(1);
            while ((entry = tarIn.getNextTarEntry()) != null) {
                String individualFile = entry.getName();
                final File fsObject = new File(targetDir, individualFile);
                if (entry.isSymbolicLink() || entry.isLink()) {
                    Path target = FileSystems.getDefault().getPath(entry.getLinkName(), new String[0]);
                    Files.createSymbolicLink(fsObject.toPath(), target, new FileAttribute[0]);
                } else if (entry.isFile()) {
                    byte[] content = new byte[(int)entry.getSize()];
                    int read = tarIn.read(content, 0, content.length);
                    if (read == -1) {
                        throw new IllegalStateException("could not read " + individualFile);
                    }
                    EmbeddedUtil.mkdirs(fsObject.getParentFile());
                    AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(fsObject.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    phaser.register();
                    fileChannel.write(buffer, 0L, fileChannel, new CompletionHandler<Integer, Channel>(){

                        @Override
                        public void completed(Integer written, Channel channel) {
                            this.closeChannel(channel);
                        }

                        @Override
                        public void failed(Throwable error, Channel channel) {
                            LOG.error("Could not write file {}", (Object)fsObject.getAbsolutePath(), (Object)error);
                            this.closeChannel(channel);
                        }

                        private void closeChannel(Channel channel) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                                LOG.error("Unexpected error while closing the channel", (Throwable)e);
                            }
                            finally {
                                phaser.arriveAndDeregister();
                            }
                        }
                    });
                } else if (entry.isDirectory()) {
                    EmbeddedUtil.mkdirs(fsObject);
                } else {
                    throw new UnsupportedOperationException(String.format("Unsupported entry found: %s", individualFile));
                }
                if (!individualFile.startsWith("bin/") && !individualFile.startsWith("./bin/")) continue;
                fsObject.setExecutable(true);
            }
            phaser.arriveAndAwaitAdvance();
        }
    }
}

