/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.ea;

import com.mycila.testing.ea.Code;
import com.mycila.testing.ea.ExtendedAssert;
import java.io.PrintWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertionExceptionImpl
implements ExtendedAssert.AssertException {
    private final Class<? extends Throwable> exceptionClass;
    private String message;
    private MsgCheck msgCheck = MsgCheck.NONE;

    public AssertionExceptionImpl(Class<? extends Throwable> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    @Override
    public ExtendedAssert.AssertException withMessage(String message) {
        this.message = message;
        this.msgCheck = MsgCheck.EQ;
        return this;
    }

    @Override
    public ExtendedAssert.AssertException containingMessage(String message) {
        this.message = message;
        this.msgCheck = MsgCheck.IN;
        return this;
    }

    @Override
    public void whenRunning(Code code) {
        boolean failed;
        block19: {
            failed = true;
            try {
                code.run();
                failed = false;
            }
            catch (Throwable throwable) {
                if (!this.exceptionClass.isAssignableFrom(throwable.getClass())) {
                    ExtendedAssert.fail("Received bad exception class. Exception is:\n" + AssertionExceptionImpl.asString(throwable), throwable.getClass().getName(), this.exceptionClass.getName());
                }
                if (this.msgCheck == MsgCheck.NONE) break block19;
                String msgThrown = throwable.getMessage();
                if (this.message == null && msgThrown != null) {
                    ExtendedAssert.fail("Received bad exception message. Exception is:\n" + AssertionExceptionImpl.asString(throwable), msgThrown, "no message (null)");
                }
                if (this.message != null && msgThrown == null) {
                    switch (this.msgCheck) {
                        case EQ: {
                            ExtendedAssert.fail("Received bad exception message. Exception is:\n" + AssertionExceptionImpl.asString(throwable), "no message (null)", this.message);
                        }
                        case IN: {
                            ExtendedAssert.fail("Received bad exception message. Exception is:\n" + AssertionExceptionImpl.asString(throwable), "no message (null)", "message containing: " + this.message);
                        }
                    }
                }
                if (this.message == null || msgThrown == null) break block19;
                switch (this.msgCheck) {
                    case EQ: {
                        if (this.message.equals(msgThrown)) break;
                        ExtendedAssert.fail("Received bad exception message. Exception is:\n" + AssertionExceptionImpl.asString(throwable), msgThrown, this.message);
                    }
                    case IN: {
                        if (msgThrown.contains(this.message)) break;
                        ExtendedAssert.fail("Received bad exception message. Exception is:\n" + AssertionExceptionImpl.asString(throwable), msgThrown, "message containing: " + this.message);
                    }
                }
            }
        }
        if (!failed) {
            switch (this.msgCheck) {
                case NONE: {
                    ExtendedAssert.fail(String.format("Should have thrown Exception class '%s'", this.exceptionClass.getName()));
                }
                case EQ: {
                    ExtendedAssert.fail(String.format("Should have thrown Exception class '%s' with message '%s'", this.exceptionClass.getName(), this.message));
                }
                case IN: {
                    ExtendedAssert.fail(String.format("Should have thrown Exception class '%s' containing message '%s'", this.exceptionClass.getName(), this.message));
                }
            }
        }
    }

    private static String asString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MsgCheck {
        NONE,
        EQ,
        IN;

    }
}

