/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core.util;

import com.mycila.testing.core.util.Closeable;
import java.util.ArrayList;
import java.util.List;

public final class ShutdownHook {
    private static final ShutdownHook INSTANCE = new ShutdownHook();
    private final List<Closeable> clients = new ArrayList<Closeable>();
    private volatile boolean shutdownInProgress;

    private ShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                ShutdownHook.this.shutdownInProgress = true;
                for (Closeable closeable : ShutdownHook.this.clients) {
                    ShutdownHook.this.close(closeable);
                }
            }
        }, this.getClass().getName()));
    }

    public void add(Closeable closeable) {
        if (this.shutdownInProgress) {
            this.close(closeable);
        } else {
            this.clients.add(closeable);
        }
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ShutdownHook get() {
        return INSTANCE;
    }
}

