/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Host;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostRequest
extends BaseRequest<Host> {
    public HostRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<? extends Host> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public HostRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Host.class);
    }

    @Nonnull
    public CompletableFuture<Host> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Host get() throws ClientException {
        return (Host)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Host> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Host delete() throws ClientException {
        return (Host)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Host> patchAsync(@Nonnull Host sourceHost) {
        return this.sendAsync(HttpMethod.PATCH, sourceHost);
    }

    @Nullable
    public Host patch(@Nonnull Host sourceHost) throws ClientException {
        return (Host)this.send(HttpMethod.PATCH, sourceHost);
    }

    @Nonnull
    public CompletableFuture<Host> postAsync(@Nonnull Host newHost) {
        return this.sendAsync(HttpMethod.POST, newHost);
    }

    @Nullable
    public Host post(@Nonnull Host newHost) throws ClientException {
        return (Host)this.send(HttpMethod.POST, newHost);
    }

    @Nonnull
    public CompletableFuture<Host> putAsync(@Nonnull Host newHost) {
        return this.sendAsync(HttpMethod.PUT, newHost);
    }

    @Nullable
    public Host put(@Nonnull Host newHost) throws ClientException {
        return (Host)this.send(HttpMethod.PUT, newHost);
    }

    @Nonnull
    public HostRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

