/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ConversationMemberCollectionPage;
import com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberCollectionResponse;
import com.microsoft.graph.requests.ConversationMemberRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConversationMemberCollectionRequest
extends BaseEntityCollectionRequest<ConversationMember, ConversationMemberCollectionResponse, ConversationMemberCollectionPage> {
    public ConversationMemberCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConversationMemberCollectionResponse.class, ConversationMemberCollectionPage.class, ConversationMemberCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ConversationMember> postAsync(@Nonnull ConversationMember newConversationMember) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationMemberRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newConversationMember);
    }

    @Nonnull
    public ConversationMember post(@Nonnull ConversationMember newConversationMember) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationMemberRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newConversationMember);
    }

    @Nonnull
    public ConversationMemberCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

