/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.segments;

import com.levigo.jbig2.Bitmap;
import com.levigo.jbig2.Region;
import com.levigo.jbig2.SegmentHeader;
import com.levigo.jbig2.decoder.arithmetic.ArithmeticDecoder;
import com.levigo.jbig2.decoder.arithmetic.CX;
import com.levigo.jbig2.decoder.mmr.MMRDecompressor;
import com.levigo.jbig2.err.InvalidHeaderValueException;
import com.levigo.jbig2.io.SubInputStream;
import com.levigo.jbig2.segments.RegionSegmentInformation;
import com.levigo.jbig2.util.log.Logger;
import com.levigo.jbig2.util.log.LoggerFactory;
import java.io.IOException;

public class GenericRegion
implements Region {
    private final Logger log = LoggerFactory.getLogger(GenericRegion.class);
    private SubInputStream subInputStream;
    private long dataHeaderOffset;
    private long dataHeaderLength;
    private long dataOffset;
    private long dataLength;
    private RegionSegmentInformation regionInfo;
    private boolean useExtTemplates;
    private boolean isTPGDon;
    private byte gbTemplate;
    private boolean isMMREncoded;
    private short[] gbAtX;
    private short[] gbAtY;
    private boolean[] gbAtOverride;
    private boolean override;
    private Bitmap regionBitmap;
    private ArithmeticDecoder arithDecoder;
    private CX cx;
    private MMRDecompressor mmrDecompressor;

    public GenericRegion() {
    }

    public GenericRegion(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    private void parseHeader() throws IOException, InvalidHeaderValueException {
        this.regionInfo.parseHeader();
        this.subInputStream.readBits(3);
        if (this.subInputStream.readBit() == 1) {
            this.useExtTemplates = true;
        }
        if (this.subInputStream.readBit() == 1) {
            this.isTPGDon = true;
        }
        this.gbTemplate = (byte)(this.subInputStream.readBits(2) & 0xFL);
        if (this.subInputStream.readBit() == 1) {
            this.isMMREncoded = true;
        }
        if (!this.isMMREncoded) {
            int n = this.gbTemplate == 0 ? (this.useExtTemplates ? 12 : 4) : 1;
            this.readGbAtPixels(n);
        }
        this.computeSegmentDataStructure();
        this.checkInput();
    }

    private void readGbAtPixels(int n) throws IOException {
        this.gbAtX = new short[n];
        this.gbAtY = new short[n];
        for (int i = 0; i < n; ++i) {
            this.gbAtX[i] = this.subInputStream.readByte();
            this.gbAtY[i] = this.subInputStream.readByte();
        }
    }

    private void computeSegmentDataStructure() throws IOException {
        this.dataOffset = this.subInputStream.getStreamPosition();
        this.dataHeaderLength = this.dataOffset - this.dataHeaderOffset;
        this.dataLength = this.subInputStream.length() - this.dataHeaderLength;
    }

    private void checkInput() throws InvalidHeaderValueException {
        if (this.isMMREncoded && this.gbTemplate != 0) {
            this.log.info("gbTemplate should contain the value 0");
        }
    }

    public Bitmap getRegionBitmap() throws IOException {
        if (null == this.regionBitmap) {
            if (this.isMMREncoded) {
                if (null == this.mmrDecompressor) {
                    this.mmrDecompressor = new MMRDecompressor(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight(), new SubInputStream(this.subInputStream, this.dataOffset, this.dataLength));
                }
                this.regionBitmap = this.mmrDecompressor.uncompress();
            } else {
                this.updateOverrideFlags();
                int n = 0;
                if (this.arithDecoder == null) {
                    this.arithDecoder = new ArithmeticDecoder(this.subInputStream);
                }
                if (this.cx == null) {
                    this.cx = new CX(65536, 1);
                }
                this.regionBitmap = new Bitmap(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight());
                int n2 = this.regionBitmap.getWidth() + 7 & 0xFFFFFFF8;
                for (int i = 0; i < this.regionBitmap.getHeight(); ++i) {
                    if (this.isTPGDon) {
                        n ^= this.decodeSLTP();
                    }
                    if (n == 1) {
                        if (i <= 0) continue;
                        this.copyLineAbove(i);
                        continue;
                    }
                    this.decodeLine(i, this.regionBitmap.getWidth(), this.regionBitmap.getRowStride(), n2);
                }
            }
        }
        return this.regionBitmap;
    }

    private int decodeSLTP() throws IOException {
        switch (this.gbTemplate) {
            case 0: {
                this.cx.setIndex(39717);
                break;
            }
            case 1: {
                this.cx.setIndex(1941);
                break;
            }
            case 2: {
                this.cx.setIndex(229);
                break;
            }
            case 3: {
                this.cx.setIndex(405);
            }
        }
        return this.arithDecoder.decode(this.cx);
    }

    private void decodeLine(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.regionBitmap.getByteIndex(0, n);
        int n6 = n5 - n3;
        switch (this.gbTemplate) {
            case 0: {
                if (!this.useExtTemplates) {
                    this.decodeTemplate0a(n, n2, n3, n4, n5, n6);
                    break;
                }
                this.decodeTemplate0b(n, n2, n3, n4, n5, n6);
                break;
            }
            case 1: {
                this.decodeTemplate1(n, n2, n3, n4, n5, n6);
                break;
            }
            case 2: {
                this.decodeTemplate2(n, n2, n3, n4, n5, n6);
                break;
            }
            case 3: {
                this.decodeTemplate3(n, n2, n3, n4, n5, n6);
            }
        }
    }

    private void copyLineAbove(int n) {
        int n2 = n * this.regionBitmap.getRowStride();
        int n3 = n2 - this.regionBitmap.getRowStride();
        for (int i = 0; i < this.regionBitmap.getRowStride(); ++i) {
            this.regionBitmap.setByte(n2++, this.regionBitmap.getByte(n3++));
        }
    }

    private void decodeTemplate0a(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (n >= 1) {
            n8 = this.regionBitmap.getByteAsInteger(n6);
        }
        if (n >= 2) {
            n9 = this.regionBitmap.getByteAsInteger(n6 - n3) << 6;
        }
        int n10 = n8 & 0xF0 | n9 & 0x3800;
        int n11 = 0;
        while (n11 < n4) {
            int n12;
            byte by = 0;
            int n13 = n11 + 8;
            int n14 = n12 = n2 - n11 > 8 ? 8 : n2 - n11;
            if (n > 0) {
                n8 = n8 << 8 | (n13 < n2 ? this.regionBitmap.getByteAsInteger(n6 + 1) : 0);
            }
            if (n > 1) {
                n9 = n9 << 8 | (n13 < n2 ? this.regionBitmap.getByteAsInteger(n6 - n3 + 1) << 6 : 0);
            }
            for (int i = 0; i < n12; ++i) {
                int n15 = 7 - i;
                if (this.override) {
                    n7 = this.overrideAtTemplate0a(n10, n11 + i, n, by, i, n15);
                    this.cx.setIndex(n7);
                } else {
                    this.cx.setIndex(n10);
                }
                int n16 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n16 << n15);
                n10 = (n10 & 0x7BF7) << 1 | n16 | n8 >> n15 & 0x10 | n9 >> n15 & 0x800;
            }
            this.regionBitmap.setByte(n5++, by);
            ++n6;
            n11 = n13;
        }
    }

    private void decodeTemplate0b(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (n >= 1) {
            n8 = this.regionBitmap.getByteAsInteger(n6);
        }
        if (n >= 2) {
            n9 = this.regionBitmap.getByteAsInteger(n6 - n3) << 6;
        }
        int n10 = n8 & 0xF0 | n9 & 0x3800;
        int n11 = 0;
        while (n11 < n4) {
            int n12;
            byte by = 0;
            int n13 = n11 + 8;
            int n14 = n12 = n2 - n11 > 8 ? 8 : n2 - n11;
            if (n > 0) {
                n8 = n8 << 8 | (n13 < n2 ? this.regionBitmap.getByteAsInteger(n6 + 1) : 0);
            }
            if (n > 1) {
                n9 = n9 << 8 | (n13 < n2 ? this.regionBitmap.getByteAsInteger(n6 - n3 + 1) << 6 : 0);
            }
            for (int i = 0; i < n12; ++i) {
                int n15 = 7 - i;
                if (this.override) {
                    n7 = this.overrideAtTemplate0b(n10, n11 + i, n, by, i, n15);
                    this.cx.setIndex(n7);
                } else {
                    this.cx.setIndex(n10);
                }
                int n16 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n16 << n15);
                n10 = (n10 & 0x7BF7) << 1 | n16 | n8 >> n15 & 0x10 | n9 >> n15 & 0x800;
            }
            this.regionBitmap.setByte(n5++, by);
            ++n6;
            n11 = n13;
        }
    }

    private void decodeTemplate1(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7 = 0;
        int n8 = 0;
        if (n >= 1) {
            n7 = this.regionBitmap.getByteAsInteger(n6);
        }
        if (n >= 2) {
            n8 = this.regionBitmap.getByteAsInteger(n6 - n3) << 5;
        }
        int n9 = n7 >> 1 & 0x1F8 | n8 >> 1 & 0x1E00;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            byte by = 0;
            int n12 = n10 + 8;
            int n13 = n11 = n2 - n10 > 8 ? 8 : n2 - n10;
            if (n >= 1) {
                n7 = n7 << 8 | (n12 < n2 ? this.regionBitmap.getByteAsInteger(n6 + 1) : 0);
            }
            if (n >= 2) {
                n8 = n8 << 8 | (n12 < n2 ? this.regionBitmap.getByteAsInteger(n6 - n3 + 1) << 5 : 0);
            }
            for (int i = 0; i < n11; ++i) {
                if (this.override) {
                    int n14 = this.overrideAtTemplate1(n9, n10 + i, n, by, i);
                    this.cx.setIndex(n14);
                } else {
                    this.cx.setIndex(n9);
                }
                int n15 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n15 << 7 - i);
                int n16 = 8 - i;
                n9 = (n9 & 0xEFB) << 1 | n15 | n7 >> n16 & 8 | n8 >> n16 & 0x200;
            }
            this.regionBitmap.setByte(n5++, by);
            ++n6;
            n10 = n12;
        }
    }

    private void decodeTemplate2(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7 = 0;
        int n8 = 0;
        if (n >= 1) {
            n7 = this.regionBitmap.getByteAsInteger(n6);
        }
        if (n >= 2) {
            n8 = this.regionBitmap.getByteAsInteger(n6 - n3) << 4;
        }
        int n9 = n7 >> 3 & 0x7C | n8 >> 3 & 0x380;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            byte by = 0;
            int n12 = n10 + 8;
            int n13 = n11 = n2 - n10 > 8 ? 8 : n2 - n10;
            if (n >= 1) {
                n7 = n7 << 8 | (n12 < n2 ? this.regionBitmap.getByteAsInteger(n6 + 1) : 0);
            }
            if (n >= 2) {
                n8 = n8 << 8 | (n12 < n2 ? this.regionBitmap.getByteAsInteger(n6 - n3 + 1) << 4 : 0);
            }
            for (int i = 0; i < n11; ++i) {
                if (this.override) {
                    int n14 = this.overrideAtTemplate2(n9, n10 + i, n, by, i);
                    this.cx.setIndex(n14);
                } else {
                    this.cx.setIndex(n9);
                }
                int n15 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n15 << 7 - i);
                int n16 = 10 - i;
                n9 = (n9 & 0x1BD) << 1 | n15 | n7 >> n16 & 4 | n8 >> n16 & 0x80;
            }
            this.regionBitmap.setByte(n5++, by);
            ++n6;
            n10 = n12;
        }
    }

    private void decodeTemplate3(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7 = 0;
        if (n >= 1) {
            n7 = this.regionBitmap.getByteAsInteger(n6);
        }
        int n8 = n7 >> 1 & 0x70;
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            byte by = 0;
            int n11 = n9 + 8;
            int n12 = n10 = n2 - n9 > 8 ? 8 : n2 - n9;
            if (n >= 1) {
                n7 = n7 << 8 | (n11 < n2 ? this.regionBitmap.getByteAsInteger(n6 + 1) : 0);
            }
            for (int i = 0; i < n10; ++i) {
                if (this.override) {
                    int n13 = this.overrideAtTemplate3(n8, n9 + i, n, by, i);
                    this.cx.setIndex(n13);
                } else {
                    this.cx.setIndex(n8);
                }
                int n14 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n14 << 7 - i);
                n8 = (n8 & 0x1F7) << 1 | n14 | n7 >> 8 - i & 0x10;
            }
            this.regionBitmap.setByte(n5++, by);
            ++n6;
            n9 = n11;
        }
    }

    private void updateOverrideFlags() {
        if (this.gbAtX == null || this.gbAtY == null) {
            this.log.info("AT pixels not set");
            return;
        }
        if (this.gbAtX.length != this.gbAtY.length) {
            this.log.info("AT pixel inconsistent, amount of x pixels: " + this.gbAtX.length + ", amount of y pixels:" + this.gbAtY.length);
            return;
        }
        this.gbAtOverride = new boolean[this.gbAtX.length];
        switch (this.gbTemplate) {
            case 0: {
                if (!this.useExtTemplates) {
                    if (this.gbAtX[0] != 3 || this.gbAtY[0] != -1) {
                        this.setOverrideFlag(0);
                    }
                    if (this.gbAtX[1] != -3 || this.gbAtY[1] != -1) {
                        this.setOverrideFlag(1);
                    }
                    if (this.gbAtX[2] != 2 || this.gbAtY[2] != -2) {
                        this.setOverrideFlag(2);
                    }
                    if (this.gbAtX[3] == -2 && this.gbAtY[3] == -2) break;
                    this.setOverrideFlag(3);
                    break;
                }
                if (this.gbAtX[0] != -2 || this.gbAtY[0] != 0) {
                    this.setOverrideFlag(0);
                }
                if (this.gbAtX[1] != 0 || this.gbAtY[1] != -2) {
                    this.setOverrideFlag(1);
                }
                if (this.gbAtX[2] != -2 || this.gbAtY[2] != -1) {
                    this.setOverrideFlag(2);
                }
                if (this.gbAtX[3] != -1 || this.gbAtY[3] != -2) {
                    this.setOverrideFlag(3);
                }
                if (this.gbAtX[4] != 1 || this.gbAtY[4] != -2) {
                    this.setOverrideFlag(4);
                }
                if (this.gbAtX[5] != 2 || this.gbAtY[5] != -1) {
                    this.setOverrideFlag(5);
                }
                if (this.gbAtX[6] != -3 || this.gbAtY[6] != 0) {
                    this.setOverrideFlag(6);
                }
                if (this.gbAtX[7] != -4 || this.gbAtY[7] != 0) {
                    this.setOverrideFlag(7);
                }
                if (this.gbAtX[8] != 2 || this.gbAtY[8] != -2) {
                    this.setOverrideFlag(8);
                }
                if (this.gbAtX[9] != 3 || this.gbAtY[9] != -1) {
                    this.setOverrideFlag(9);
                }
                if (this.gbAtX[10] != -2 || this.gbAtY[10] != -2) {
                    this.setOverrideFlag(10);
                }
                if (this.gbAtX[11] == -3 && this.gbAtY[11] == -1) break;
                this.setOverrideFlag(11);
                break;
            }
            case 1: {
                if (this.gbAtX[0] == 3 && this.gbAtY[0] == -1) break;
                this.setOverrideFlag(0);
                break;
            }
            case 2: {
                if (this.gbAtX[0] == 2 && this.gbAtY[0] == -1) break;
                this.setOverrideFlag(0);
                break;
            }
            case 3: {
                if (this.gbAtX[0] == 2 && this.gbAtY[0] == -1) break;
                this.setOverrideFlag(0);
            }
        }
    }

    private void setOverrideFlag(int n) {
        this.gbAtOverride[n] = true;
        this.override = true;
    }

    private int overrideAtTemplate0a(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        if (this.gbAtOverride[0]) {
            n &= 0xFFEF;
            n = this.gbAtY[0] == 0 && this.gbAtX[0] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[0] & 1) << 4) : (n |= this.getPixel(n2 + this.gbAtX[0], n3 + this.gbAtY[0]) << 4);
        }
        if (this.gbAtOverride[1]) {
            n &= 0xFBFF;
            n = this.gbAtY[1] == 0 && this.gbAtX[1] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[1] & 1) << 10) : (n |= this.getPixel(n2 + this.gbAtX[1], n3 + this.gbAtY[1]) << 10);
        }
        if (this.gbAtOverride[2]) {
            n &= 0xF7FF;
            n = this.gbAtY[2] == 0 && this.gbAtX[2] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[2] & 1) << 11) : (n |= this.getPixel(n2 + this.gbAtX[2], n3 + this.gbAtY[2]) << 11);
        }
        if (this.gbAtOverride[3]) {
            n &= Short.MAX_VALUE;
            n = this.gbAtY[3] == 0 && this.gbAtX[3] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[3] & 1) << 15) : (n |= this.getPixel(n2 + this.gbAtX[3], n3 + this.gbAtY[3]) << 15);
        }
        return n;
    }

    private int overrideAtTemplate0b(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        if (this.gbAtOverride[0]) {
            n &= 0xFFFD;
            n = this.gbAtY[0] == 0 && this.gbAtX[0] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[0] & 1) << 1) : (n |= this.getPixel(n2 + this.gbAtX[0], n3 + this.gbAtY[0]) << 1);
        }
        if (this.gbAtOverride[1]) {
            n &= 0xDFFF;
            n = this.gbAtY[1] == 0 && this.gbAtX[1] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[1] & 1) << 13) : (n |= this.getPixel(n2 + this.gbAtX[1], n3 + this.gbAtY[1]) << 13);
        }
        if (this.gbAtOverride[2]) {
            n &= 0xFDFF;
            n = this.gbAtY[2] == 0 && this.gbAtX[2] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[2] & 1) << 9) : (n |= this.getPixel(n2 + this.gbAtX[2], n3 + this.gbAtY[2]) << 9);
        }
        if (this.gbAtOverride[3]) {
            n &= 0xBFFF;
            n = this.gbAtY[3] == 0 && this.gbAtX[3] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[3] & 1) << 14) : (n |= this.getPixel(n2 + this.gbAtX[3], n3 + this.gbAtY[3]) << 14);
        }
        if (this.gbAtOverride[4]) {
            n &= 0xEFFF;
            n = this.gbAtY[4] == 0 && this.gbAtX[4] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[4] & 1) << 12) : (n |= this.getPixel(n2 + this.gbAtX[4], n3 + this.gbAtY[4]) << 12);
        }
        if (this.gbAtOverride[5]) {
            n &= 0xFFDF;
            n = this.gbAtY[5] == 0 && this.gbAtX[5] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[5] & 1) << 5) : (n |= this.getPixel(n2 + this.gbAtX[5], n3 + this.gbAtY[5]) << 5);
        }
        if (this.gbAtOverride[6]) {
            n &= 0xFFFB;
            n = this.gbAtY[6] == 0 && this.gbAtX[6] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[6] & 1) << 2) : (n |= this.getPixel(n2 + this.gbAtX[6], n3 + this.gbAtY[6]) << 2);
        }
        if (this.gbAtOverride[7]) {
            n &= 0xFFF7;
            n = this.gbAtY[7] == 0 && this.gbAtX[7] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[7] & 1) << 3) : (n |= this.getPixel(n2 + this.gbAtX[7], n3 + this.gbAtY[7]) << 3);
        }
        if (this.gbAtOverride[8]) {
            n &= 0xF7FF;
            n = this.gbAtY[8] == 0 && this.gbAtX[8] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[8] & 1) << 11) : (n |= this.getPixel(n2 + this.gbAtX[8], n3 + this.gbAtY[8]) << 11);
        }
        if (this.gbAtOverride[9]) {
            n &= 0xFFEF;
            n = this.gbAtY[9] == 0 && this.gbAtX[9] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[9] & 1) << 4) : (n |= this.getPixel(n2 + this.gbAtX[9], n3 + this.gbAtY[9]) << 4);
        }
        if (this.gbAtOverride[10]) {
            n &= Short.MAX_VALUE;
            n = this.gbAtY[10] == 0 && this.gbAtX[10] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[10] & 1) << 15) : (n |= this.getPixel(n2 + this.gbAtX[10], n3 + this.gbAtY[10]) << 15);
        }
        if (this.gbAtOverride[11]) {
            n &= 0xFDFF;
            n = this.gbAtY[11] == 0 && this.gbAtX[11] >= -n5 ? (n |= (n4 >> n6 - this.gbAtX[11] & 1) << 10) : (n |= this.getPixel(n2 + this.gbAtX[11], n3 + this.gbAtY[11]) << 10);
        }
        return n;
    }

    private int overrideAtTemplate1(int n, int n2, int n3, int n4, int n5) throws IOException {
        n &= 0x1FF7;
        if (this.gbAtY[0] == 0 && this.gbAtX[0] >= -n5) {
            return n | (n4 >> 7 - (n5 + this.gbAtX[0]) & 1) << 3;
        }
        return n | this.getPixel(n2 + this.gbAtX[0], n3 + this.gbAtY[0]) << 3;
    }

    private int overrideAtTemplate2(int n, int n2, int n3, int n4, int n5) throws IOException {
        n &= 0x3FB;
        if (this.gbAtY[0] == 0 && this.gbAtX[0] >= -n5) {
            return n | (n4 >> 7 - (n5 + this.gbAtX[0]) & 1) << 2;
        }
        return n | this.getPixel(n2 + this.gbAtX[0], n3 + this.gbAtY[0]) << 2;
    }

    private int overrideAtTemplate3(int n, int n2, int n3, int n4, int n5) throws IOException {
        n &= 0x3EF;
        if (this.gbAtY[0] == 0 && this.gbAtX[0] >= -n5) {
            return n | (n4 >> 7 - (n5 + this.gbAtX[0]) & 1) << 4;
        }
        return n | this.getPixel(n2 + this.gbAtX[0], n3 + this.gbAtY[0]) << 4;
    }

    private byte getPixel(int n, int n2) throws IOException {
        if (n < 0 || n >= this.regionBitmap.getWidth()) {
            return 0;
        }
        if (n2 < 0 || n2 >= this.regionBitmap.getHeight()) {
            return 0;
        }
        return this.regionBitmap.getPixel(n, n2);
    }

    protected void setParameters(boolean bl, long l, long l2, int n, int n2) {
        this.isMMREncoded = bl;
        this.dataOffset = l;
        this.dataLength = l2;
        this.regionInfo.setBitmapHeight(n);
        this.regionInfo.setBitmapWidth(n2);
        this.mmrDecompressor = null;
        this.resetBitmap();
    }

    protected void setParameters(boolean bl, byte by, boolean bl2, boolean bl3, short[] sArray, short[] sArray2, int n, int n2, CX cX, ArithmeticDecoder arithmeticDecoder) {
        this.isMMREncoded = bl;
        this.gbTemplate = by;
        this.isTPGDon = bl2;
        this.gbAtX = sArray;
        this.gbAtY = sArray2;
        this.regionInfo.setBitmapWidth(n);
        this.regionInfo.setBitmapHeight(n2);
        if (null != cX) {
            this.cx = cX;
        }
        if (null != arithmeticDecoder) {
            this.arithDecoder = arithmeticDecoder;
        }
        this.mmrDecompressor = null;
        this.resetBitmap();
    }

    protected void setParameters(boolean bl, long l, long l2, int n, int n2, byte by, boolean bl2, boolean bl3, short[] sArray, short[] sArray2) {
        this.dataOffset = l;
        this.dataLength = l2;
        this.regionInfo = new RegionSegmentInformation();
        this.regionInfo.setBitmapHeight(n);
        this.regionInfo.setBitmapWidth(n2);
        this.gbTemplate = by;
        this.isMMREncoded = bl;
        this.isTPGDon = bl2;
        this.gbAtX = sArray;
        this.gbAtY = sArray2;
    }

    protected void resetBitmap() {
        this.regionBitmap = null;
    }

    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IOException {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(this.subInputStream);
        this.parseHeader();
    }

    public RegionSegmentInformation getRegionInfo() {
        return this.regionInfo;
    }

    protected boolean useExtTemplates() {
        return this.useExtTemplates;
    }

    protected boolean isTPGDon() {
        return this.isTPGDon;
    }

    protected byte getGbTemplate() {
        return this.gbTemplate;
    }

    protected boolean isMMREncoded() {
        return this.isMMREncoded;
    }

    protected short[] getGbAtX() {
        return this.gbAtX;
    }

    protected short[] getGbAtY() {
        return this.gbAtY;
    }
}

