/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.entities.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TemplateFieldBindingUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXTENSION = "extension";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";
    public static final String PROPERTY_TEMPLATE = "template";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.nuiton.wikitty.entities.WikittyExtension extension;
    protected com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected java.lang.String template;
    protected TemplateFieldBindingUI templateFieldBindingUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        ListCellRenderer listRenderer = new DefaultListCellRenderer() {
    
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
    
                if (value != null) {
                    value = VradiHelper.getTraduction(extension, (String) value);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        };
    
        JListCellRenderer renderer = new JListCellRenderer(listRenderer);
    
        setContextValue(renderer);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, renderer);
    
        JListCellEditor editor = new JListCellEditor(listRenderer, true);
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
    
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    public void cancel() {
        setFieldsModel(null);
        close();
    }
    
    public void valid() {
        if (getHandler().checkAssociation(this, getExtension(), fieldsModel)) {
            close();
        } else {
            cancel();
        }
    }
    
    public void close() {
        UIHelper.saveComponentDispositionConfig();
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TemplateFieldBindingUI() {
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        cancel();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        valid();
    }

    public void doWindowClosing__on__templateFieldBindingUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.nuiton.wikitty.entities.WikittyExtension getExtension() {
        return extension;
    }

    public com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public java.lang.String getTemplate() {
        return template;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExtension(org.nuiton.wikitty.entities.WikittyExtension newValue) {
        org.nuiton.wikitty.entities.WikittyExtension oldValue = this.extension;
        this.extension = newValue;
        firePropertyChange(PROPERTY_EXTENSION, oldValue, newValue);
    }

    public void setFieldsModel(com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel newValue) {
        com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = newValue;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, newValue);
    }

    public void setTemplate(java.lang.String newValue) {
        java.lang.String oldValue = this.template;
        this.template = newValue;
        firePropertyChange(PROPERTY_TEMPLATE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTemplateFieldBindingUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createExtension() {
        $objectMap.put("extension", extension = null);
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new TemplateFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createTemplate() {
        $objectMap.put("template", template = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTemplateFieldBindingUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        fieldsTable.setModel(fieldsModel);
        // late initializer
        templateFieldBindingUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("templateFieldBindingUI", this);
        createExtension();
        createTemplate();
        createFieldsModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminFormType.template.fieldBinding.label"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of templateFieldBindingUI
        setName("templateFieldBindingUI");
        templateFieldBindingUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminFormType.template.fieldBinding.title"));
        templateFieldBindingUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__templateFieldBindingUI"));
        
        $completeSetup();
    }

}