/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ChangeLogUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeFlooUEQIPwyooNHj9g+AKKSGCKlCrAZiL053h+6Q2Z1x5i1dLsY/wT9B715MvHkyHjx78GL8F4zx4NX4Zlta0LU0toftZt77vve9772d199Izmiyckjj2NFRCDxgzvbG/v5O/ZC5cIcZV3MFUpPWL5Ml2RoZ9zrnBsj1WsXCS214qSwDJUMWnkKvVsiYgWPBjM8YALl8FuEaU6p2wquxivQJa0dUGuvLH9+zL7znr7KExArVDWEry+ehup0MV0iWe0CmsdIRLQkaNlCG5mED9RbtWVlQY+7TgD0lz8hIheQV1UgG5Fr/LSccCT5WQMZdH8uwimw82gJyw5WBcxhpbgKqXZ8Z50hTjzsRd8rdPKUSfB7IZAe9S0MmgMxblbFjmija2a66WgphQza/0IGNuDKERPfsmfyHLIYNzahNm1Bo3uIZ83AsTncsXd8yNZLTER4DWaj9PckHGGrNcOGPGVrCJPprbubzu69vN08GV8Tas6mpp/YODVVaKqaB29IXWlOLgIvSPapWa6RgmMClTZZyKUVYtR1GcVjvooU7Fu7cpcZHitzIl/cf5p58GiLZTTImJPU2qc3fIgXwNboghRer2+uJoonmKD6nrDa01WMHNBJQFtKwHZRIgaPlZHLNo0CX6zz00PBbMXqylOJJR1i98PHnTPXN+okvGdR56Z/pXW9yj0meh4KHLFnp9ramrvC4MizyZHcr0/Y0Y//HVHvx5pPnYlrjeZ/xho+LNb3Wqr9MAb+gegQMu7Wwq0kb9m2lf1ZBj2UENn7l/1lygfSosOGbA5AAB8EGJWniNeMPSJKvS+0x3cOUYh8sRRdvMNiVhtsN7SFpqg8yvFdEFIRmQJpR5nGg9Z4298MzfIDfXA9/+tJil3hPUzWglmITOZLLcw/Hdg7Zb1w0M5mGBwAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.ChangeLogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane changeLogPanel;
    protected ChangeLogUI changeLogUI = this;
    protected javax.swing.JTextArea content;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ChangeLogUI() {
        $initialize();
    }

    public ChangeLogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doWindowClosing__on__changeLogUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JScrollPane getChangeLogPanel() {
        return changeLogPanel;
    }

    public javax.swing.JTextArea getContent() {
        return content;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToChangeLogPanel() {
        if (!allComponentsCreated) {
            return;
        }
        changeLogPanel.getViewport().add(content);
    }

    protected void addChildrenToChangeLogUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(changeLogPanel);
    }

    protected void createChangeLogPanel() {
        $objectMap.put("changeLogPanel", changeLogPanel = new javax.swing.JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED));
        
        changeLogPanel.setName("changeLogPanel");
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JTextArea());
        
        content.setName("content");
        content.setColumns(15);
        content.setLineWrap(true);
        content.setWrapStyleWord(true);
        content.setCaretPosition(0);
        content.setColumns(60);
        content.setEditable(false);
        content.setLineWrap(true);
        content.setWrapStyleWord(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToChangeLogUI();
        addChildrenToChangeLogPanel();
        
        // apply 4 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        changeLogPanel.setBorder(null);
        content.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 11));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("changeLogUI", this);
        createChangeLogPanel();
        createContent();
        // inline creation of changeLogUI
        setName("changeLogUI");
        SwingUtil.setComponentHeight(changeLogUI,600);
        changeLogUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.changelog.title"));
        SwingUtil.setComponentWidth(changeLogUI,800);
        changeLogUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__changeLogUI"));
        
        $completeSetup();
    }

}