/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.jta.utils.XAHelper;
import java.util.Vector;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RecoveryXids {
    private Xid[] _scanN;
    private Xid[] _scanM;
    private XAResource _xares;
    private int _scanHoldNumber;
    private static final int MAX_SCAN_HOLD = 10;

    public RecoveryXids(XAResource xares) {
        this._xares = xares;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecoveryXids) {
            try {
                return ((RecoveryXids)obj)._xares.isSameRM(this._xares);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final void nextScan(Xid[] trans) {
        ++this._scanHoldNumber;
        if (this._scanHoldNumber > 10) {
            this._scanM = null;
        }
        if (this._scanM == null) {
            this._scanM = this._scanN;
        } else if (this._scanM != null && this._scanN != null) {
            int newArraySize = this._scanM.length + this._scanN.length;
            Xid[] copy = new Xid[newArraySize];
            System.arraycopy(this._scanM, 0, copy, 0, this._scanM.length);
            System.arraycopy(this._scanN, 0, copy, this._scanM.length, this._scanN.length);
            this._scanM = copy;
        }
        this._scanN = trans;
    }

    public final Object[] toRecover() {
        int numScanM;
        int numScanN = this._scanN == null ? 0 : this._scanN.length;
        int numScan = Math.min(numScanN, numScanM = this._scanM == null ? 0 : this._scanM.length);
        if (numScan == 0) {
            return null;
        }
        Vector<Xid> workingVector = new Vector<Xid>();
        for (int count = 0; count < numScan; ++count) {
            if (!XAHelper.sameXID(this._scanN[count], this._scanM[count])) continue;
            workingVector.add(this._scanN[count]);
        }
        return workingVector.toArray();
    }

    public final boolean isSameRM(XAResource xares) {
        try {
            if (xares == null) {
                return false;
            }
            return xares.isSameRM(this._xares);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean contains(Xid xid) {
        int i;
        if (this._scanN != null) {
            for (i = 0; i < this._scanN.length; ++i) {
                if (!XAHelper.sameXID(xid, this._scanN[i])) continue;
                return true;
            }
        }
        if (this._scanM != null) {
            for (i = 0; i < this._scanM.length; ++i) {
                if (!XAHelper.sameXID(xid, this._scanM[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean updateIfEquivalentRM(XAResource xaResource, Xid[] xids) {
        if (xids == null || xids.length == 0) {
            return false;
        }
        for (int i = 0; i < xids.length; ++i) {
            if (!this.contains(xids[i])) continue;
            this._xares = xaResource;
            return true;
        }
        return false;
    }
}

