/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.nuiton.i18n.I18n;

public class VradiConstants {
    public static final Pattern XML_STREAM_IMPORT_TIME = Pattern.compile("^(\\d{1,2})\\:(\\d{1,2})$");
    public static final String CHANNEL = "channel";
    public static final String ENTRY = "entry";
    public static final String ITEM = "item";
    public static final String USER_ONLY_DECORATOR = "userOnly";
    public static final SimpleDateFormat FORM_ID_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DEFAULT_SENDING_PARAGRAPH = "";
    public static final int DEFAULT_SENDING_STATUS = 0;

    public static enum FileType {
        TEMPLATE,
        EMBEDDED_FORM_FILES,
        ATTACHMENTS_FORM_FILES,
        ATTACHMENTS_SESSION_FILES,
        PDF("application/pdf"),
        WEB_HARVEST,
        QUERY_HISTORY("application/rss+xml"),
        TEMP_FILE;

        private final String mineType;

        private FileType() {
            this("application/octet-stream");
        }

        private FileType(String mineType) {
            this.mineType = mineType;
        }

        public String getMineType() {
            return this.mineType;
        }
    }

    public static enum FormTypeTemplateEnum {
        FIELDS_ELEMENT("fields"),
        FIELD_ELEMENT("field"),
        FIELD_TEMPLATE_ATTRIBUTE("template"),
        FIELD_EXTENSION_ATTRIBUTE("extension");

        private final String value;

        private FormTypeTemplateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SessionStatus {
        ACTIVE(I18n._((String)"vradi.sessionStatus.active")),
        STOPPED(I18n._((String)"vradi.sessionStatus.stopped")),
        SENT(I18n._((String)"vradi.sessionStatus.sent")),
        ERROR(I18n._((String)"vradi.sessionStatus.error"));

        protected final String description;

        private SessionStatus(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public static SessionStatus getStatus(int i) {
            SessionStatus result = null;
            for (SessionStatus status : SessionStatus.values()) {
                if (status.ordinal() != i) continue;
                result = status;
            }
            return result;
        }

        public int getValue() {
            return this.ordinal();
        }

        public static boolean isActive(Session session) {
            if (session == null) {
                return false;
            }
            int status = session.getStatus();
            return status == ACTIVE.getValue();
        }

        public static boolean isSent(Session session) {
            int status = session.getStatus();
            return status == SENT.getValue();
        }

        public static boolean isStopped(Session session) {
            int status = session.getStatus();
            return status == STOPPED.getValue();
        }

        public static boolean isToRestart(Session session) {
            int status = session.getStatus();
            return status == STOPPED.getValue() || status == ERROR.getValue();
        }

        public static boolean isToSend(Session session) {
            int status = session.getStatus();
            return status == ACTIVE.getValue() || status == STOPPED.getValue() || status == ERROR.getValue();
        }
    }

    public static enum SendingStatus {
        DELETED(I18n._((String)"vradi.email.status.deleted")),
        TO_SEND(I18n._((String)"vradi.email.status.toSend")),
        SENT(I18n._((String)"vradi.email.status.sent")),
        WAITING_RECEPTION_PROOF(I18n._((String)"vradi.email.status.waitingReceptionProof")),
        RECEIVED(I18n._((String)"vradi.email.status.received")),
        ERROR(I18n._((String)"vradi.email.status.error"));

        private final String description;

        private SendingStatus(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int getValue() {
            return this.ordinal() - 1;
        }

        public static SendingStatus getStatus(int i) {
            for (SendingStatus status : SendingStatus.values()) {
                if (status.getValue() != i) continue;
                return status;
            }
            return null;
        }

        public static boolean isSent(Sending sending) {
            int status = sending.getStatus();
            return status == SENT.getValue() || status == WAITING_RECEPTION_PROOF.getValue() || status == RECEIVED.getValue();
        }

        public static boolean isDeleted(Sending sending) {
            int status = sending.getStatus();
            return status == DELETED.getValue();
        }

        public static boolean isToSend(Sending sending) {
            int status = sending.getStatus();
            return status == TO_SEND.getValue() || status == ERROR.getValue();
        }

        public static boolean isWaitingReceptionProof(Sending sending) {
            int status = sending.getStatus();
            return status == WAITING_RECEPTION_PROOF.getValue();
        }

        public static boolean isInError(Sending sending) {
            int status = sending.getStatus();
            return status == ERROR.getValue();
        }

        public static boolean isClosed(Sending sending) {
            return SendingStatus.isDeleted(sending) || SendingStatus.isSent(sending);
        }
    }

    public static enum FormStatus {
        NON_TRAITE(I18n.n_((String)"vradi.status.nontraite.name"), I18n.n_((String)"vradi.status.nontraite.description")),
        NON_SELECTIONNE(I18n.n_((String)"vradi.status.nonselectionne.name"), I18n.n_((String)"vradi.status.nonselectionne.description")),
        PRESELECTIONNE(I18n.n_((String)"vradi.status.preselectionne.name"), I18n.n_((String)"vradi.status.preselectionne.description")),
        SELECTIONNE(I18n.n_((String)"vradi.status.selectionne.name"), I18n.n_((String)"vradi.status.selectionne.description"));

        private String name;
        private String description;

        private FormStatus(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

