/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ThesaurusTreeTableNodeLoadors.java 1824 2010-12-15 13:59:21Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/thesaurus/loadors/ThesaurusTreeTableNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.thesaurus.loadors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.jurismarches.vradi.ui.thesaurus.ThesaurusDataProvider;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;

/**
 * @author letellier
 */
public class ThesaurusTreeTableNodeLoadors extends NavTreeTableNodeChildLoador<String, Thesaurus, VradiTreeTableNode> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** Logger */
    static private final Log log =
            LogFactory.getLog(ThesaurusTreeTableNodeLoadors.class);

    public ThesaurusTreeTableNodeLoadors() {
        super(Thesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // ne recupere pas seulement les id pour les mettre en cache
        Collection<Thesaurus> thesauruses = ((ThesaurusDataProvider)dataProvider).getChildrenThesaurus(parentId);

        if (log.isDebugEnabled()) {
            if (RootThesaurus.class.equals(parentClass)) {
                RootThesaurus root = ThesaurusDataHelper.restoreRootThesaurus(parentId);
                for (Thesaurus thesaurus : thesauruses) {
                    log.debug("Children of root thesaurus " + root.getName() + " find : " + thesaurus.getName());
                }
            }
            else {
                Thesaurus root = ThesaurusDataHelper.restoreThesaurus(parentId);
                for (Thesaurus thesaurus : thesauruses) {
                    log.debug("Children of root thesaurus " + root.getName() + " find : " + thesaurus.getName());
                }
            } 
        }

        return extractIds(thesauruses);
    }

    @Override
    public VradiTreeTableNode createNode(String id, NavDataProvider dataProvider) {

        return new VradiTreeTableNode(
                    getBeanType(),
                    id,
                    null,
                    NavHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)
            );
    }

    protected List<String> extractIds(Collection<? extends BusinessEntity> entities) {
        List<String> ids = new ArrayList<String>();
        for (BusinessEntity e : entities) {
            ids.add(e.getWikittyId());
        }
        return ids;
    }
}