/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public class SingletonComparison
extends BinaryExpression {
    private AtomicComparer comparer;

    public SingletonComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public void setComparator(Comparator comparator, XPathContext xPathContext) {
        this.comparer = comparator instanceof AtomicComparer ? (AtomicComparer)comparator : new AtomicComparer(comparator, xPathContext);
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return false;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return false;
        }
        try {
            return GeneralComparison.compare(atomicValue, this.operator, atomicValue2, this.comparer, xPathContext);
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    protected String displayOperator() {
        return "singleton " + super.displayOperator();
    }
}

