/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.java;

import com.sun.star.lib.uno.Proxy;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;

public final class java_environment
implements IEnvironment {
    private static final Registry localObjects = new Registry();
    private final Object context;
    private final Registry proxies = new Registry();

    public java_environment(Object object) {
        this.context = object;
    }

    public Object getContext() {
        return this.context;
    }

    public String getName() {
        return "java";
    }

    public Object registerInterface(Object object, String[] stringArray, Type type) {
        if (stringArray[0] == null) {
            stringArray[0] = UnoRuntime.generateOid((Object)object);
        }
        return (this.isProxy(object) ? this.proxies : localObjects).register(object, stringArray[0], type);
    }

    public void revokeInterface(String string, Type type) {
        if (!this.proxies.revoke(string, type)) {
            localObjects.revoke(string, type);
        }
    }

    public Object getRegisteredInterface(String string, Type type) {
        Object object = this.proxies.get(string, type);
        if (object == null) {
            object = localObjects.get(string, type);
        }
        return object;
    }

    public String getRegisteredObjectIdentifier(Object object) {
        return UnoRuntime.generateOid((Object)object);
    }

    public void list() {
    }

    public void revokeAllProxies() {
        this.proxies.clear();
    }

    public boolean equals(Object object) {
        return false;
    }

    private boolean isProxy(Object object) {
        return object instanceof Proxy;
    }

    private static final class Registry {
        private final HashMap map = new HashMap();
        private final ReferenceQueue queue = new ReferenceQueue();

        private Registry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object register(Object object, String string, Type type) {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                Object t;
                Level2Entry level2Entry;
                this.cleanUp();
                Level1Entry level1Entry = this.getLevel1Entry(string);
                if (level1Entry != null && (level2Entry = level1Entry.get(type)) != null && (t = level2Entry.get()) != null) {
                    level2Entry.acquire();
                    return t;
                }
                if (level1Entry == null) {
                    level1Entry = new Level1Entry();
                    this.map.put(string, level1Entry);
                }
                level1Entry.add(new Level2Entry(string, type, object, this.queue));
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean revoke(String string, Type type) {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                Level1Entry level1Entry = this.getLevel1Entry(string);
                Level2Entry level2Entry = null;
                if (level1Entry != null && (level2Entry = level1Entry.get(type)) != null && level2Entry.release()) {
                    this.removeLevel2Entry(string, level1Entry, level2Entry);
                }
                this.cleanUp();
                return level2Entry != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(String string, Type type) {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                Level1Entry level1Entry = this.getLevel1Entry(string);
                return level1Entry == null ? null : level1Entry.find(type);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.clear();
                this.cleanUp();
            }
        }

        private void cleanUp() {
            Level2Entry level2Entry;
            while ((level2Entry = (Level2Entry)this.queue.poll()) != null) {
                String string = level2Entry.getOid();
                Level1Entry level1Entry = this.getLevel1Entry(string);
                if (level1Entry == null || level1Entry.get(level2Entry.getType()) != level2Entry) continue;
                this.removeLevel2Entry(string, level1Entry, level2Entry);
            }
        }

        private Level1Entry getLevel1Entry(String string) {
            return (Level1Entry)this.map.get(string);
        }

        private void removeLevel2Entry(String string, Level1Entry level1Entry, Level2Entry level2Entry) {
            if (level1Entry.remove(level2Entry)) {
                this.map.remove(string);
            }
        }

        private static final class Level2Entry
        extends WeakReference {
            private final String oid;
            private final Type type;
            private int count = 1;

            public Level2Entry(String string, Type type, Object object, ReferenceQueue referenceQueue) {
                super(object, referenceQueue);
                this.oid = string;
                this.type = type;
            }

            public String getOid() {
                return this.oid;
            }

            public Type getType() {
                return this.type;
            }

            public void acquire() {
                ++this.count;
            }

            public boolean release() {
                return --this.count == 0;
            }
        }

        private static final class Level1Entry {
            private final LinkedList list = new LinkedList();

            private Level1Entry() {
            }

            public Level2Entry get(Type type) {
                for (Level2Entry level2Entry : this.list) {
                    if (!level2Entry.getType().equals((Object)type)) continue;
                    return level2Entry;
                }
                return null;
            }

            public Object find(Type type) {
                Object t;
                for (Level2Entry level2Entry : this.list) {
                    if (!level2Entry.getType().equals((Object)type) || (t = level2Entry.get()) == null) continue;
                    return t;
                }
                for (Level2Entry level2Entry : this.list) {
                    if (!type.isSupertypeOf(level2Entry.getType()) || (t = level2Entry.get()) == null) continue;
                    return t;
                }
                return null;
            }

            public void add(Level2Entry level2Entry) {
                this.list.add(level2Entry);
            }

            public boolean remove(Level2Entry level2Entry) {
                this.list.remove(level2Entry);
                return this.list.isEmpty();
            }
        }
    }
}

