/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class WikittyServiceTransaction
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceTransaction.class);
    protected WikittyService ws;
    protected WikittyService tx;
    protected List<WikittyEvent> events;
    protected int autoCommit = -1;

    public WikittyServiceTransaction(ApplicationConfig config, WikittyService ws) {
        this.ws = ws;
        this.tx = WikittyServiceFactory.buildWikittyServiceTransaction(config);
        this.events = new LinkedList<WikittyEvent>();
    }

    public void setAutoCommit(int autoCommit) {
        this.autoCommit = autoCommit;
    }

    public int getAutoCommit() {
        return this.autoCommit;
    }

    protected void addEvent(String securityToken, WikittyEvent e) {
        this.events.add(e);
        if (this.autoCommit > 0 && this.events.size() >= this.autoCommit) {
            this.commit(securityToken);
        }
    }

    public void commit(String securityToken) {
        this.ws.replay(securityToken, this.events, false);
        this.tx.clear(null);
        this.events.clear();
    }

    public void rollback(String securityToken) {
        this.tx.clear(null);
        this.events.clear();
    }

    @Override
    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("You try to add listener on WikittyServiceTransaction,this is an error desgin, you must add WikittyServiceNotifierfront of your WikittyServiceTransaction.");
    }

    @Override
    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("You try to remove listener on WikittyServiceTransaction,this is an error desgin, you must add WikittyServiceNotifierfront of your WikittyServiceTransaction.");
    }

    @Override
    public String login(String login, String password) {
        return this.ws.login(login, password);
    }

    @Override
    public void logout(String securityToken) {
        this.ws.logout(securityToken);
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        WikittyEvent e = this.tx.clear(securityToken);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return true;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return true;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        boolean result = this.tx.exists(securityToken, wikittyId);
        if (!result) {
            result = this.ws.canRead(securityToken, wikittyId);
        }
        return result;
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        WikittyEvent e = this.tx.replay(securityToken, events, force);
        events.add(e);
        return e;
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        WikittyEvent e = this.tx.store(securityToken, wikitties, force);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(this.tx.getAllExtensionIds(securityToken));
        tmp.addAll(this.ws.getAllExtensionIds(securityToken));
        ArrayList<String> result = new ArrayList<String>(tmp);
        return result;
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(this.tx.getAllExtensionsRequires(securityToken, extensionName));
        tmp.addAll(this.ws.getAllExtensionsRequires(securityToken, extensionName));
        ArrayList<String> result = new ArrayList<String>(tmp);
        return result;
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyEvent e = this.tx.storeExtension(securityToken, exts);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        WikittyEvent e = this.tx.deleteExtension(securityToken, extNames);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        WikittyExtension result = this.tx.restoreExtension(securityToken, extensionId);
        if (result == null) {
            result = this.ws.restoreExtension(securityToken, extensionId);
        }
        return result;
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyExtension result = this.tx.restoreExtensionLastVersion(securityToken, name);
        if (result == null) {
            result = this.ws.restoreExtensionLastVersion(securityToken, name);
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        List<Wikitty> resultWS = this.ws.restore(securityToken, ids);
        List<Wikitty> resultTx = this.tx.restore(securityToken, ids);
        Wikitty[] result = resultWS.toArray(new Wikitty[resultWS.size()]);
        int i = 0;
        for (Wikitty w : resultTx) {
            String id = ids.get(i);
            if (w != null || this.tx.exists(securityToken, id)) {
                result[i] = w;
            }
            ++i;
        }
        return Arrays.asList(result);
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        List<Wikitty> wikitties = this.ws.restore(securityToken, new ArrayList<String>(ids));
        this.tx.store(securityToken, wikitties, true);
        WikittyEvent e = this.tx.delete(securityToken, ids);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        PagedResult<String> resultTx = this.tx.findAllByCriteria(securityToken, criteria);
        PagedResult<String> resultWs = this.ws.findAllByCriteria(securityToken, criteria);
        LinkedHashSet<String> ids = new LinkedHashSet<String>(resultTx.size() + resultWs.size());
        ids.addAll(resultTx.getAll());
        for (String id : resultWs.getAll()) {
            if (this.tx.exists(securityToken, id) && this.tx.isDeleted(securityToken, id)) continue;
            ids.add(id);
        }
        int firstIndice = resultWs.getFirstIndice();
        int numFound = resultTx.getNumFound() + resultWs.getNumFound();
        String queryString = resultWs.getQueryString();
        Map<String, List<FacetTopic>> facets = resultWs.getFacets();
        ArrayList results = new ArrayList(ids);
        PagedResult<String> result = new PagedResult<String>(firstIndice, numFound, queryString, facets, results);
        return result;
    }

    @Override
    public String findByCriteria(String securityToken, Criteria criteria) {
        String result = null;
        Criteria criteriaLimit = Search.query(criteria).criteria().setFirstIndex(0).setEndIndex(1);
        PagedResult<String> ids = this.findAllByCriteria(securityToken, criteriaLimit);
        if (ids.size() > 0) {
            result = ids.getFirst();
        }
        return result;
    }

    @Override
    public WikittyTree restoreTree(String securityToken, String wikittyId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map.Entry<String, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void syncSearchEngine(String securityToken) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean exists(String securityToken, String wikittyId) {
        boolean result = this.tx.exists(securityToken, wikittyId);
        if (!result && !this.tx.isDeleted(securityToken, wikittyId)) {
            result = this.ws.exists(securityToken, wikittyId);
        }
        return result;
    }

    @Override
    public boolean isDeleted(String securityToken, String wikittyId) {
        boolean result = this.tx.isDeleted(securityToken, wikittyId);
        if (!result && !this.tx.exists(securityToken, wikittyId)) {
            result = this.ws.isDeleted(securityToken, wikittyId);
        }
        return result;
    }
}

