/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.MUCAdmin;
import org.jivesoftware.smackx.packet.MUCUser;

public class Occupant {
    private String affiliation;
    private String role;
    private String jid;
    private String nick;

    Occupant(MUCAdmin.Item item) {
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        this.nick = item.getNick();
    }

    Occupant(Presence presence) {
        MUCUser mucUser = (MUCUser)presence.getExtension("x", "http://jabber.org/protocol/muc#user");
        MUCUser.Item item = mucUser.getItem();
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        this.nick = StringUtils.parseResource((String)presence.getFrom());
    }

    public String getJid() {
        return this.jid;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public String getRole() {
        return this.role;
    }

    public String getNick() {
        return this.nick;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Occupant)) {
            return false;
        }
        Occupant occupant = (Occupant)obj;
        return this.jid.equals(occupant.jid);
    }

    public int hashCode() {
        int result = this.affiliation.hashCode();
        result = 17 * result + this.role.hashCode();
        result = 17 * result + this.jid.hashCode();
        result = 17 * result + (this.nick != null ? this.nick.hashCode() : 0);
        return result;
    }
}

