/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.thesaurus.helpers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.xwork.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;

public class ThesaurusDataHelper {
    private static final Log log = LogFactory.getLog(ThesaurusDataHelper.class);

    public static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static Thesaurus restoreThesaurus(String thesaurusId) {
        return (Thesaurus)ThesaurusDataHelper.getProxy().restore(Thesaurus.class, thesaurusId);
    }

    public static List<Thesaurus> restoreThesaurus(List<String> thesaurusIds) {
        return ThesaurusDataHelper.getProxy().restore(Thesaurus.class, thesaurusIds);
    }

    public static List<Thesaurus> restoreThesaurus(Set<String> thesaurusIds) {
        return ThesaurusDataHelper.restoreThesaurus(new ArrayList<String>(thesaurusIds));
    }

    public static RootThesaurus restoreRootThesaurus(String rootThesaurusId) {
        return (RootThesaurus)ThesaurusDataHelper.getProxy().restore(RootThesaurus.class, rootThesaurusId);
    }

    public static List<RootThesaurus> restoreRootThesaurus(List<String> rootThesaurusIds) {
        return ThesaurusDataHelper.getProxy().restore(RootThesaurus.class, rootThesaurusIds);
    }

    public static String getNamePath(Thesaurus thesaurus, String pathSeparator) {
        if (thesaurus == null) {
            return "";
        }
        String parentId = thesaurus.getParent();
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            return ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus()).getName() + pathSeparator + ThesaurusDataHelper.concateOrderName(thesaurus);
        }
        Thesaurus parentThesaurus = ThesaurusDataHelper.restoreThesaurus(parentId);
        return ThesaurusDataHelper.getNamePath(parentThesaurus, pathSeparator) + pathSeparator + ThesaurusDataHelper.concateOrderName(thesaurus);
    }

    public static String concateOrderName(Thesaurus thesaurus) {
        String result = thesaurus.getName();
        int order = thesaurus.getOrder();
        if (order != 0) {
            result = order + " - " + result;
        }
        return result;
    }

    public static String getTagsAsString(Thesaurus thesaurus) {
        if (thesaurus == null) {
            return "";
        }
        String result = thesaurus.getTags() != null ? StringUtils.join((Collection)thesaurus.getTags(), (String)" ,") : "";
        return result;
    }

    public static void setTagsAsString(Thesaurus thesaurus, String tagsAsString) {
        if (tagsAsString != null) {
            thesaurus.clearTags();
            for (String tag : tagsAsString.split(",")) {
                thesaurus.addTags(tag.trim());
            }
        }
    }

    public static int getNbFormsForThesaurus(Thesaurus thesaurus) {
        Map.Entry entry = ThesaurusDataHelper.getProxy().restoreNode(Thesaurus.class, thesaurus.getWikittyId(), null);
        if (entry == null) {
            return 0;
        }
        return (Integer)entry.getValue();
    }

    protected static List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }

    public static String getParentPath(Thesaurus thesaurus, String pathSeparator) {
        if (thesaurus == null) {
            return pathSeparator;
        }
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus());
            return rootThesaurus.getName();
        }
        String parentId = thesaurus.getParent();
        Thesaurus parentThesaurus = ThesaurusDataHelper.restoreThesaurus(parentId);
        return ThesaurusDataHelper.getParentPath(parentThesaurus, pathSeparator) + pathSeparator + ThesaurusDataHelper.concateOrderName(parentThesaurus);
    }

    public static int getDepth(Thesaurus thesaurus) {
        if (thesaurus == null) {
            return 0;
        }
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            return 2;
        }
        String parentId = thesaurus.getParent();
        Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(parentId);
        return 1 + ThesaurusDataHelper.getDepth(parent);
    }

    public static boolean isFirstChild(Thesaurus thesaurus) {
        String rootThesaurus = thesaurus.getRootThesaurus();
        String parent = thesaurus.getParent();
        return parent != null && parent.equals(rootThesaurus);
    }

    public static String getRequestName(Thesaurus thesaurus) {
        String rootId = thesaurus.getRootThesaurus();
        RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(rootId);
        return rootThesaurus.getName() + ":\"" + thesaurus.getName() + "\"";
    }
}

