/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.loadors.AbstractEmailNodeLoador;
import com.jurismarches.vradi.ui.email.loadors.EmailFormNodeLoadors;
import com.jurismarches.vradi.ui.email.loadors.EmailGroupNodeLoadors;
import com.jurismarches.vradi.ui.email.loadors.EmailGroupUsersNodeLoadors;
import com.jurismarches.vradi.ui.email.loadors.EmailUsersNodeLoadors;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.helpers.VradiTreeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class EmailNavigationTreeHelper
extends VradiTreeHelper {
    private static final Log log = LogFactory.getLog(EmailNavigationTreeHelper.class);
    protected List<Session> sessions;
    protected Date searchDate;
    public static String PATH_SEPARATOR = "/";
    protected EmailFilterEnum filter = EmailFilterEnum.FILTER_BY_USER;

    public EmailNavigationTreeHelper(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.REMOTE);
    }

    @Override
    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public WikittyProxy getProxy() {
        return this.getDataProvider().getWikittyProxy();
    }

    protected EmailHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, EmailHandler.class);
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public boolean isByForm() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_FORM);
    }

    public boolean isByUser() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_USER);
    }

    public boolean isByGroup() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_GROUP);
    }

    public Session getSelectedActiveSession() {
        Session session;
        Session activeSession = null;
        VradiTreeNode selectedNode = (VradiTreeNode)this.getSelectedNode();
        if (selectedNode != null && VradiConstants.SessionStatus.isToSend((Session)(session = EmailNavigationTreeHelper.getParentSession(selectedNode)))) {
            activeSession = session;
        }
        return activeSession;
    }

    public void updateTree(List<Session> sessions, EmailFilterEnum filter, Date searchDate) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("update data, nb sessions : " + sessions.size()));
        }
        this.filter = filter;
        this.sessions = sessions;
        this.searchDate = searchDate;
        VradiTreeNode rootNode = new VradiTreeNode(String.class, "Root node", null, null);
        for (Session session : sessions) {
            rootNode.add(this.createSessionNode(session));
        }
        DefaultTreeModel model = this.createModel(rootNode, new Object[0]);
        ((NavTreeBridge)this.getBridge()).setRoot((NavTreeNode)rootNode);
        rootNode.populateChilds(this.getBridge(), this.getDataProvider());
        ((JTree)this.getUI()).setModel(model);
    }

    public VradiTreeNode createSessionNode(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createSession node " + session.getSessionDate() + " num " + session.getNum()));
        }
        String sessionId = session.getWikittyId();
        AbstractEmailNodeLoador nodeLoador = null;
        if (this.isByForm()) {
            nodeLoador = new EmailFormNodeLoadors();
        } else if (this.isByUser()) {
            nodeLoador = new EmailUsersNodeLoadors();
        } else if (this.isByGroup()) {
            nodeLoador = new EmailGroupNodeLoadors();
        }
        return new VradiTreeNode(Session.class, sessionId, null, nodeLoador);
    }

    public Session getSessionSelected() {
        return this.getSessionToDisplay((VradiTreeNode)this.getSelectedNode());
    }

    public Session getSessionToDisplay(VradiTreeNode node) {
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        return session;
    }

    public Sending getSendingToDisplay(VradiTreeNode node) {
        String id = node.getId();
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        return EmailDataHelper.getUserSending(session, id);
    }

    public List<Sending> getSendingListToDisplay(VradiTreeNode node) {
        HashMap<String, Sending> result = new HashMap<String, Sending>();
        Class type = node.getInternalClass();
        String id = node.getId();
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        if (type.equals(Form.class)) {
            List<Sending> sendings = this.getSendingByForm(session, id);
            this.addSendingToMap(result, sendings);
        }
        return new ArrayList<Sending>(result.values());
    }

    protected void addSendingToMap(Map<String, Sending> result, List<Sending> sendings) {
        for (Sending sending : sendings) {
            result.put(sending.getWikittyId(), sending);
        }
    }

    protected List<Sending> getSendingByForm(Session session, String formId) {
        Set sendingIdsSet = session.getSending();
        ArrayList<Sending> result = new ArrayList<Sending>();
        if (sendingIdsSet == null) {
            return result;
        }
        List sendings = this.getProxy().restore(Sending.class, new ArrayList(sendingIdsSet));
        for (Sending sending : sendings) {
            if (sending == null) continue;
            Set formIdsSet = SendingHelper.extractForms((WikittyProxy)VradiService.getWikittyProxy(), (Collection)sending.getGroupForms());
            if (formIdsSet == null) {
                return result;
            }
            if (!formIdsSet.contains(formId)) continue;
            result.add(sending);
        }
        return result;
    }

    protected List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }

    public static Session getParentSession(VradiTreeNode node) {
        VradiTreeNode sessionNode = EmailNavigationTreeHelper.getParentSessionNode(node);
        if (sessionNode == null) {
            return null;
        }
        return (Session)VradiService.getWikittyProxy().restore(Session.class, sessionNode.getId());
    }

    public static VradiTreeNode getParentSessionNode(VradiTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getInternalClass().equals(Session.class)) {
            return node;
        }
        VradiTreeNode parent = (VradiTreeNode)node.getParent();
        return EmailNavigationTreeHelper.getParentSessionNode(parent);
    }

    protected void refresh(VradiTreeNode node) {
        if (node == null) {
            return;
        }
        ((NavTreeBridge)this.getBridge()).nodeChanged((TreeNode)((Object)node));
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[Email] put wikitty");
        }
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains("Session")) {
                VradiTreeNode existingNode;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[Session] put wikitty");
                }
                if ((existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId})) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Session] Modification case :  " + existingNode.getId()));
                    }
                    this.refresh(existingNode);
                } else {
                    Session session = (Session)this.getProxy().restore(Session.class, wikittyId);
                    if (session == null) {
                        return;
                    }
                    if (0 == DateUtil.getDifferenceInDays((Date)this.searchDate, (Date)session.getSessionDate())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("[Session] Creation case :  " + session.getSessionDate()));
                        }
                        VradiTreeNode newSessionNode = this.createSessionNode(session);
                        this.insertNode(this.getRootNode(), (NavNode)newSessionNode);
                        this.refresh(newSessionNode);
                    }
                }
            }
            if (!wikittyExtensions.contains("Sending")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"[Sending] put wikitty");
            }
            Sending sending = (Sending)VradiService.getWikittyProxy().restore(Sending.class, wikittyId);
            this.updateSendingInTree(sending);
        }
    }

    protected void updateSendingInTree(Sending sending) {
        block22: {
            VradiTreeNode sessionNode;
            block21: {
                if (sending == null) {
                    return;
                }
                Session session = null;
                String wikittyId = sending.getWikittyId();
                try {
                    session = VradiService.getVradiDataService().getSessionOfSending(wikittyId);
                }
                catch (VradiException eee) {
                    log.error((Object)("Can't find session for sending '" + wikittyId + "'"), (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                if (session == null) {
                    return;
                }
                sessionNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{session.getWikittyId()});
                if (sessionNode == null) {
                    return;
                }
                if (!this.isByForm()) break block21;
                Set formsIds = SendingHelper.extractForms((WikittyProxy)VradiService.getWikittyProxy(), (Collection)sending.getGroupForms());
                if (formsIds == null) break block22;
                for (String formId : formsIds) {
                    VradiTreeNode formNode = (VradiTreeNode)this.findNode((NavNode)sessionNode, new String[]{formId});
                    if (formNode != null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] add form " + formId));
                    }
                    this.createNode(sessionNode, Form.class, formId, null);
                }
                break block22;
            }
            if (this.isByUser()) {
                String userId = sending.getUser();
                VradiTreeNode userNode = (VradiTreeNode)this.findNode((NavNode)sessionNode, new String[]{userId});
                if (userNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] refresh user " + userId));
                    }
                    this.refresh(userNode);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] create user " + userId));
                    }
                    this.createNode(sessionNode, User.class, userId, null);
                }
            } else if (this.isByGroup()) {
                String userId = sending.getUser();
                VradiTreeNode userNode = (VradiTreeNode)this.findNode((NavNode)sessionNode, new String[]{userId});
                if (userNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] refresh user " + userId));
                    }
                    this.refresh(userNode);
                } else {
                    List groupList = VradiService.getVradiDataService().findUserGroups(userId);
                    for (Group group : groupList) {
                        String groupId = group.getWikittyId();
                        VradiTreeNode groupNode = (VradiTreeNode)this.findNode((NavNode)sessionNode, new String[]{groupId});
                        if (groupNode != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("[Sending] create user " + userId));
                            }
                            this.createNode(sessionNode, User.class, userId, null);
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("[Sending] create group " + userId));
                        }
                        this.createNode(sessionNode, Group.class, groupId, EmailGroupUsersNodeLoadors.class);
                    }
                }
            }
        }
    }

    protected void createNode(VradiTreeNode sessionNode, Class typeNode, String id, Class<? extends AbstractEmailNodeLoador<?>> loadorClass) {
        AbstractEmailNodeLoador nodeLoador = null;
        if (loadorClass != null) {
            nodeLoador = (AbstractEmailNodeLoador)NavHelper.getChildLoador(loadorClass);
        }
        VradiTreeNode newNode = new VradiTreeNode(typeNode, id, null, nodeLoador);
        sessionNode.add(newNode);
        ((NavTreeBridge)this.getBridge()).notifyNodeInserted((NavTreeNode)newNode);
    }

    public static enum EmailFilterEnum {
        FILTER_BY_USER(I18n._((String)"vradi.email.userFilter")),
        FILTER_BY_GROUP(I18n._((String)"vradi.email.groupFilter")),
        FILTER_BY_FORM(I18n._((String)"vradi.email.formFilter"));

        protected int value;
        protected String text;

        private EmailFilterEnum(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

