/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_GROUP_USER_HANDLER = "groupUserHandler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_BUTTON_ENABLED = "createButton.enabled";
    public static final String BINDING_GROUP_NAME_TEXT = "groupName.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.entities.Group bean;
    protected javax.swing.JButton createButton;
    protected javax.swing.JTextField groupName;
    protected com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler groupUserHandler;
    protected jaxx.runtime.swing.ListSelectorUI< User > groupUsers;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected javax.swing.JLabel title;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminGroupUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(groupUsers.getCombo(), EntityRenderer.getInstance());
    
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    
        groupUserHandler = new UserListSelectorHandler(groupUsers);
        groupUsers.setHandler(groupUserHandler);
    }
    
    /**
     * Fill groups and users ListSelectorUI.
     */
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        requestListUI.setBean(bean); 
        groupUserHandler.setBean(bean);
        if (bean == null) {
        
            // Clear all user
            groupUsers.init(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    
            // Clear all requests
            requestListUI.init();
    
            return;
        }
    
        Set<String> users = bean.getUser();
    
        java.util.List<User> toUserList = new java.util.ArrayList<User>();
        if (users != null){
            for (String user : users){
                User userToAdd = VradiService.getWikittyProxy().restore(User.class, user);
                toUserList.add(userToAdd);
            }
        }
    
        java.util.List<User> toUserCombo = new java.util.ArrayList<User>(getHandler().getAllUsers());
    
        toUserCombo.removeAll(toUserList);
    
        // Sort
        Collections.sort(toUserList, VradiComparators.USER_COMPARATOR);
        Collections.sort(toUserCombo, VradiComparators.USER_COMPARATOR);
    
        groupUsers.init(toUserCombo, toUserList);
    
        requestListUI.setBean(bean);
        requestListUI.init();
        groupUserHandler.setBean(bean);
    }
    
    @Override
    public void save() {
        setModified(false);
    
        //Use new list to avoid empty queries after clearing
        Group bean = requestListUI.getBean();
        java.util.List<String> queries = null;
        if (bean.getQueries()!=null){
            queries = new java.util.ArrayList<String>(requestListUI.getBean().getQueries());
        }
    
        //Store queries
        bean.clearQueries();
        if (queries!=null){
            for (String query : queries) {
                bean.addQueries(query);
            }
        }
    
        //Store users
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            log.debug("Store user : " + user.getName());
            bean.addUser(user.getWikittyId());
        }
    
        //Set modified to false just before saving to avoid multiple confirmation
        setModified(false);
        Group group = getHandler().saveGroup(this, getHelper(), bean);
    
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setBean(null);
        setBean(group);
    
        groupUsers.setModified(false);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        groupName.setText("");
        groupUsers.init(null, null);
    }
    
    protected String updateTitle(String name) {
        return _("vradi.adminGroup.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this);setModified(true);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        getBean().setName(groupName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.entities.Group getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler getGroupUserHandler() {
        return groupUserHandler;
    }

    public jaxx.runtime.swing.ListSelectorUI< User > getGroupUsers() {
        return groupUsers;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Group newValue) {
        com.jurismarches.vradi.entities.Group oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setGroupUserHandler(com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler newValue) {
        com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler oldValue = this.groupUserHandler;
        this.groupUserHandler = newValue;
        firePropertyChange(PROPERTY_GROUP_USER_HANDLER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("name", groupName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(SwingUtil.boxComponentWithJxLayer(groupName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 1, 1, 1, 1.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(requestListUI, new GridBagConstraints(0, 2, 2, 1, 1.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminGroup.createGroup"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUserHandler() {
        $objectMap.put("groupUserHandler", groupUserHandler = null);
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< User >());
        
        groupUsers.setName("groupUsers");
        groupUsers.setShowHidor(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        
        requestListUI.setName("requestListUI");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group >(com.jurismarches.vradi.entities.Group.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        createButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.delete"));
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeUser"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setHandler(groupUserHandler);
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createValidator();
        createBean();
        createGroupUserHandler();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdminGroupForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUP_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}