/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Unchainable;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ChainingInterceptor.class);
    protected Collection<String> excludes;
    protected Collection<String> includes;
    protected ReflectionProvider reflectionProvider;

    @Inject
    public void setReflectionProvider(ReflectionProvider prov) {
        this.reflectionProvider = prov;
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        ValueStack stack = invocation.getStack();
        CompoundRoot root = stack.getRoot();
        if (root.size() > 1) {
            ArrayList list = new ArrayList(root);
            list.remove(0);
            Collections.reverse(list);
            Map<String, Object> ctxMap = invocation.getInvocationContext().getContextMap();
            Iterator iterator = list.iterator();
            int index = 1;
            while (iterator.hasNext()) {
                ++index;
                Object o = iterator.next();
                if (o != null) {
                    if (o instanceof Unchainable) continue;
                    this.reflectionProvider.copy(o, invocation.getAction(), ctxMap, this.excludes, this.includes);
                    continue;
                }
                LOG.warn("compound root element at index " + index + " is null", new String[0]);
            }
        }
        return invocation.invoke();
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes = excludes;
    }

    public Collection<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection<String> includes) {
        this.includes = includes;
    }
}

