/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.Util;

@Unsupported
public class SIZE
extends Protocol {
    final Vector members = new Vector();
    @Property
    boolean print_msg = false;
    @Property
    boolean raw_buffer = false;
    @Property
    long min_size = 0L;
    final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(65535);
    final ExposedDataOutputStream out = new ExposedDataOutputStream(this.out_stream);

    @Override
    public void init() {
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                int payload_size = msg.getLength();
                if (this.raw_buffer) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("size of message buffer is " + payload_size + ", " + this.numHeaders(msg) + " headers");
                    }
                } else {
                    int serialized_size = this.sizeOf(msg);
                    if ((long)serialized_size > this.min_size && this.log.isTraceEnabled()) {
                        this.log.trace("size of serialized message is " + serialized_size + ", " + this.numHeaders(msg) + " headers");
                    }
                }
                if (!this.print_msg || !this.log.isTraceEnabled()) break;
                this.log.trace("headers are " + msg.printHeaders() + ", payload size=" + payload_size);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                payload_size = msg.getLength();
                if (this.raw_buffer) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("size of message buffer is " + payload_size + ", " + this.numHeaders(msg) + " headers");
                    }
                } else {
                    int serialized_size = this.sizeOf(msg);
                    if ((long)serialized_size > this.min_size && this.log.isTraceEnabled()) {
                        this.log.trace("size of serialized message is " + serialized_size + ", " + this.numHeaders(msg) + " headers");
                    }
                }
                if (!this.print_msg || !this.log.isTraceEnabled()) break;
                this.log.trace("headers are " + msg.printHeaders() + ", payload size=" + payload_size);
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sizeOf(Message msg) {
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = this.out_stream;
        synchronized (exposedByteArrayOutputStream) {
            int n;
            try {
                this.out_stream.reset();
                this.out.reset();
                msg.writeTo(this.out);
                this.out.flush();
                n = this.out_stream.size();
            }
            catch (Exception e) {
                int n2;
                try {
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    Util.close(this.out);
                    throw throwable;
                }
                Util.close(this.out);
                return n2;
            }
            Util.close(this.out);
            return n;
        }
    }

    int numHeaders(Message msg) {
        if (msg == null) {
            return 0;
        }
        return msg.getNumHeaders();
    }
}

