/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: GroupListSelectorHandler.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/widget/GroupListSelectorHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.widget;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import jaxx.runtime.swing.ListSelectorUI;
import org.nuiton.wikitty.WikittyProxy;
import java.util.List;
import java.util.Set;

public class GroupListSelectorHandler extends AdminListSelectorHandler<Group> {

    protected User bean;

    public GroupListSelectorHandler(ListSelectorUI<Group> listSelector) {
        super(listSelector);
    }

    public User getBean() {
        return bean;
    }

    public void setBean(User bean) {
        this.bean = bean;
    }

    @Override
    public void putWikitty(String wikittyId, Set<String> wikittyExtensions) {
        if (bean == null) {
            return;
        }
        WikittyProxy proxy = VradiService.getWikittyProxy();
        if (wikittyExtensions.contains(Group.EXT_GROUP)) {

            Group group = proxy.restore(Group.class, wikittyId);
            getCombo().addItem(group);

        } else if (wikittyExtensions.contains(User.EXT_USER)) {
            if (wikittyId.equals(bean.getWikittyId())) {

                // Fill list with groups
                List<Group> groups = VradiService.getVradiDataService().findUserGroups(wikittyId);
                setListDatas(groups);
            }
        }
    }

    @Override
    public void removeWikitty(String wikittyId) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        if (idsInCombo.contains(wikittyId)) {
            idsInCombo.remove(wikittyId);
            List<Group> groups = proxy.restore(Group.class, idsInCombo);
            setComboDatas(groups);
        }
        if (idsInList.contains(wikittyId)) {
            idsInList.remove(wikittyId);
            List<Group> groups = proxy.restore(Group.class, idsInList);
            setListDatas(groups);
        }
    }
}
