/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.models;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public abstract class EmailEntityModel<E extends BusinessEntity>
extends DefaultListModel
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(EmailEntityModel.class);
    protected EmailFormsListCellRenderer renderer;
    protected Map<String, E> datas;
    protected Session session;
    protected Form form;

    public EmailEntityModel(EmailFormsListCellRenderer renderer, Session session, Form form) {
        this.renderer = renderer;
        this.datas = new HashMap<String, E>();
        this.session = session;
        this.form = form;
        this.updateModel(session, form);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    @Override
    public int getSize() {
        return this.datas.size();
    }

    public abstract void updateModel(Session var1, Form var2);

    @Override
    public Object getElementAt(int index) {
        ArrayList<String> keys = new ArrayList<String>(this.datas.keySet());
        return this.datas.get(keys.get(index));
    }

    protected void updateDatas(List<E> datas) {
        if (datas == null) {
            return;
        }
        for (BusinessEntity data : datas) {
            if (data == null) continue;
            this.datas.put(data.getWikittyId(), data);
        }
        this.renderer.clearCaches();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    protected void refresh() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refresh datas");
        }
        this.session = (Session)VradiService.getWikittyProxy().restore(Session.class, this.session.getWikittyId());
        this.updateModel(this.session, this.form);
    }

    public void putWikitty(final WikittyServiceEvent event) {
        final Map idAndExtensions = event.getIdExtensions();
        if (idAndExtensions != null) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    boolean mustBeRefresh = false;
                    for (String wikittyId : event.getIds()) {
                        Session restoredSession;
                        Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
                        if (!wikittyExtensions.contains("Sending")) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Receive wikitty service put event : " + event));
                        }
                        if (!(restoredSession = VradiService.getVradiDataService().getSessionBySending(wikittyId)).equals(EmailEntityModel.this.session)) continue;
                        mustBeRefresh = true;
                    }
                    if (mustBeRefresh) {
                        EmailEntityModel.this.refresh();
                    }
                }
            });
        }
    }

    public void removeWikitty(final WikittyServiceEvent event) {
        final Map idAndExtensions = event.getIdExtensions();
        if (idAndExtensions != null) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    boolean mustBeRefresh = false;
                    for (String wikittyId : event.getIds()) {
                        Session restoredSession;
                        Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
                        if (!wikittyExtensions.contains("Sending")) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Receive wikitty service remove event : " + event));
                        }
                        if (!(restoredSession = VradiService.getVradiDataService().getSessionBySending(wikittyId)).equals(EmailEntityModel.this.session)) continue;
                        mustBeRefresh = true;
                    }
                    if (mustBeRefresh) {
                        EmailEntityModel.this.refresh();
                    }
                }
            });
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
    }

    public void removeExtension(WikittyServiceEvent event) {
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

