/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminNavUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;
import com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI;
import com.jurismarches.vradi.ui.admin.content.AdminGroupUI;
import com.jurismarches.vradi.ui.admin.content.AdminStatusUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FieldSelectUI;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.admin.models.FieldTypeModel;
import com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.admin.popups.AdminRequestUI;
import com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.helpers.XmlStreamHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.sun.star.uno.RuntimeException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdom.Element;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.webharvest.gui.Ide;

public class AdminHandler {
    private static final Log log = LogFactory.getLog(AdminHandler.class);
    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;
    public static final Map<String, Element> XML_STREAM_FIELDS_CACHE = new HashMap<String, Element>();

    public AdminPopupUI init(JAXXContext rootContext) {
        AdminPopupUI adminPopupUI = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(rootContext);
        if (adminPopupUI == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            VradiMainUI mainUI = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
            adminPopupUI = new AdminPopupUI((JAXXContext)context, mainUI);
            VradiContext.ADMIN_UI_ENTRY_DEF.setContextValue(rootContext, (Object)adminPopupUI);
        }
        return adminPopupUI;
    }

    protected AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI)context;
        }
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    protected void close(JAXXContext context) {
        AdminPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    public void openUI(AdminNavUI ui, VradiTreeNode node) {
        Class editType = node.getInternalClass();
        String id = node.getId();
        this.openUI(ui, id, editType);
    }

    public void openUI(AdminNavUI ui, String id, Class editType) {
        if (editType.equals(String.class)) {
            Class<?> uiClass = AdminBeanConstant.getUIClass(id);
            this.showUI(ui, null, uiClass);
        } else {
            Class<?> uiClass = AdminBeanConstant.getUIClass(editType);
            Object bean = AdminBeanConstant.getConstantByBeanClass(editType).getBean(new VradiDataProvider(), id);
            this.showUI(ui, bean, uiClass);
        }
    }

    protected <B> void showUI(AdminNavUI navUI, B bean, Class<? extends AdminContentUI> uiClass) {
        CardLayout2 contentLayout = navUI.getContentLayout();
        JPanel content = navUI.getContent();
        AdminContentUI ui = UIHelper.getContentIfExist(contentLayout, content, uiClass);
        String contentName = uiClass.getName();
        if (ui == null) {
            try {
                Constructor<? extends AdminContentUI> constructor = uiClass.getConstructor(JAXXContext.class);
                ui = constructor.newInstance(navUI);
            }
            catch (Exception eee) {
                log.error((Object)eee);
                ErrorDialogUI.showError((Exception)eee);
            }
            content.add((Component)ui, contentName);
        }
        ui.setBean(null);
        ui.setBean(bean);
        contentLayout.show((Container)content, contentName);
    }

    public Group saveGroup(JAXXContext parentUI, AdminNavigationTreeHelper helper, Group group) {
        String login = ((VradiUser)parentUI.getContextValue(VradiUser.class)).getLogin();
        ModificationTag clientTag = (ModificationTag)VradiService.getWikittyProxy().cast((BusinessEntity)group, ModificationTag.class);
        clientTag.setLastModified(new Date());
        clientTag.setLastModifier(login);
        try {
            VradiService.getVradiStorageService().archiveQueries((QueryMaker)group);
        }
        catch (VradiException eee) {
            log.error((Object)"Cant archive query : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        if (log.isDebugEnabled()) {
            Set users;
            log.debug((Object)("Save group '" + group.getName() + "'"));
            if (group.getQueries() != null) {
                for (String query : group.getQueries()) {
                    log.debug((Object)("Save group '" + group.getName() + "' with query : " + query));
                }
            }
            if ((users = group.getUser()) != null) {
                for (String user : users) {
                    log.debug((Object)("Saving group " + group.getName() + " with user : " + user));
                }
            }
        }
        Group newGroup = (Group)VradiService.getWikittyProxy().store((BusinessEntity)group);
        helper.createAndSelectGroupNode(group.getWikittyId());
        return newGroup;
    }

    protected Collection<Group> saveGroups(JAXXContext parentUI, AdminNavigationTreeHelper helper, List<Group> groups) {
        ArrayList<Group> newGroups = new ArrayList<Group>();
        for (Group group : groups) {
            Group savedGroup = this.saveGroup(parentUI, helper, group);
            newGroups.add(savedGroup);
        }
        return newGroups;
    }

    protected <E extends XmlStream> E saveStream(E xmlStream, List<XmlFieldBinding> bindings) {
        List newXmlFieldBinding = VradiService.getWikittyProxy().store(bindings);
        xmlStream.clearXmlFieldBinding();
        for (XmlFieldBinding binding : newXmlFieldBinding) {
            xmlStream.addXmlFieldBinding(binding.getWikittyId());
        }
        XmlStream newXmlStream = (XmlStream)VradiService.getWikittyProxy().store(xmlStream);
        return (E)newXmlStream;
    }

    public Client saveClient(JAXXContext parentUI, AdminNavigationTreeHelper helper, Client client, Collection<Group> groups) {
        try {
            String login = ((VradiUser)parentUI.getContextValue(VradiUser.class)).getLogin();
            ModificationTag clientTag = (ModificationTag)VradiService.getWikittyProxy().cast((BusinessEntity)client, ModificationTag.class);
            clientTag.setLastModified(new Date());
            clientTag.setLastModifier(login);
            client = (Client)VradiService.getWikittyProxy().store((BusinessEntity)client);
            if (groups != null && !groups.isEmpty()) {
                this.saveGroups(parentUI, helper, new ArrayList<Group>(groups));
            }
            helper.createAndSelectClientNode(client.getWikittyId());
        }
        catch (Exception e) {
            log.error((Object)"Cant save client : ", (Throwable)e);
        }
        return client;
    }

    public User saveUser(JAXXContext parentUI, AdminNavigationTreeHelper helper, User user, Collection<Group> groups) {
        try {
            helper.createAndSelectUserNode(user.getWikittyId(), user.getClient());
            String login = ((VradiUser)parentUI.getContextValue(VradiUser.class)).getLogin();
            ModificationTag userTag = (ModificationTag)VradiService.getWikittyProxy().cast((BusinessEntity)user, ModificationTag.class);
            userTag.setLastModified(new Date());
            userTag.setLastModifier(login);
            WikittyProxy proxy = VradiService.getWikittyProxy();
            user = (User)proxy.store((BusinessEntity)user);
            if (groups != null && !groups.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Save groups");
                }
                this.saveGroups(parentUI, helper, new ArrayList<Group>(groups));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cant save user : ", (Throwable)e);
        }
        return user;
    }

    public void exportClientUsersDBCSV(AdminNavUI adminNavUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.admin.exportTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.admin.exportButtonText"));
                int returnVal = chooser.showOpenDialog(adminNavUI);
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporting groups to : " + selectedFile.getAbsolutePath()));
                    }
                    VradiStorageService vradiStorageService = VradiService.getVradiStorageService();
                    String vscContent = vradiStorageService.exportClientDB();
                    FileUtils.writeStringToFile((File)selectedFile, (String)vscContent);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't export groups", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't export groups", (Throwable)eee);
            }
        }
    }

    public void importClientUsersDBCSV(AdminNavUI adminNavUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.admin.importTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.admin.importButtonText"));
                int returnVal = chooser.showOpenDialog(adminNavUI);
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Importing file : " + selectedFile.getAbsolutePath()));
                    }
                    String uri = VradiService.getFileService().uploadTempFile(selectedFile);
                    VradiService.getVradiStorageService().importAsCSV(uri);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import file", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't import file", (Throwable)eee);
            }
        }
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content == null) {
            return true;
        }
        VradiTreeNode selected = null;
        if (content.getHelper() != null && content.getHelper().getSelectedNode() != null) {
            selected = (VradiTreeNode)content.getHelper().getSelectedNode();
        }
        return this.answerToSave(content, selected);
    }

    public boolean answerToSave(AdminContentUI<?> content, VradiTreeNode oldNode) {
        if (content == null) {
            return true;
        }
        if (content.isModified().booleanValue()) {
            int n = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.saveAnswer") + VradiHelper.getEntityName(content.getBean()) + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
            switch (n) {
                case 1: {
                    this.cancel(content, oldNode, false);
                    break;
                }
                case 0: {
                    content.setModified(false);
                    content.save();
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean confirmDeletion(AdminContentUI<?> content) {
        int confirm = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.confirmDelete", (Object[])new Object[]{VradiHelper.getEntityName(content.getBean())}), I18n._((String)"vradi.admin.deleteTitle"), 0);
        return confirm != 1;
    }

    public <B> void delete(AdminContentUI<B> content, AdminNavigationTreeHelper helper, B bean) {
        if (!this.confirmDeletion(content)) {
            return;
        }
        try {
            VradiTreeNode selectedNode = (VradiTreeNode)helper.getSelectedNode();
            helper.selectNode((NavNode)selectedNode.getParent());
            content.setModified(false);
            content.setBean(null);
            BusinessEntity entity = (BusinessEntity)bean;
            String id = entity.getWikittyId();
            Wikitty modified = VradiService.getWikittyProxy().restore(id);
            if (modified == null) {
                helper.removeNode((NavNode)selectedNode);
                return;
            }
            if (bean instanceof Client) {
                VradiService.getVradiStorageService().deleteClient(id);
            }
            if (bean instanceof User) {
                VradiService.getVradiStorageService().deleteUser(id);
            }
            if (bean instanceof Group) {
                VradiService.getVradiStorageService().deleteGroup(id);
            }
        }
        catch (Exception eee) {
            log.error((Object)eee.getMessage(), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content, VradiTreeNode oldNode, boolean trigerredByCancelButton) {
        int confirm = -1;
        if (trigerredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.cancel.message"), I18n._((String)"vradi.admin.cancel.title"), 0, 2);
        }
        if (!trigerredByCancelButton || confirm == 0) {
            try {
                B bean = content.getBean();
                String id = null;
                VradiDataProvider vradiDataProvider = content.getHelper().getDataProvider();
                Class<?> uiClass = content.getClass();
                AdminBeanConstant beanClass = AdminBeanConstant.getConstantByUIClass(uiClass);
                content.setModified(false);
                if (bean instanceof BusinessEntity) {
                    this.cancelIfCreation(content, oldNode, (BusinessEntity)bean);
                } else if (bean instanceof WikittyExtension) {
                    id = ((WikittyExtension)bean).getId();
                }
                if (id != null) {
                    Object beanCanceled = beanClass.getBean(vradiDataProvider, id);
                    content.setBean(null);
                    content.setBean(beanCanceled);
                }
                if (oldNode != null) {
                    content.getHelper().refresh((VradiTreeNode)oldNode.getParent());
                    UIHelper.selectNodeLater((NavHelper)content.getHelper(), oldNode.getId());
                }
            }
            catch (Exception eee) {
                log.error((Object)"Cant cancel editing", (Throwable)eee);
                ErrorDialogUI.showError((Exception)eee);
            }
        }
    }

    protected <B> void cancelIfCreation(AdminContentUI<B> content, VradiTreeNode oldNode, BusinessEntity bean) {
        String id;
        VradiDataProvider vradiDataProvider = content.getHelper().getDataProvider();
        Class<?> uiClass = content.getClass();
        AdminBeanConstant beanClass = AdminBeanConstant.getConstantByUIClass(uiClass);
        Object beanCanceled = beanClass.getBean(vradiDataProvider, id = bean.getWikittyId());
        if (beanCanceled == null) {
            AdminNavigationTreeHelper helper = content.getHelper();
            if (oldNode != null) {
                VradiTreeNode parent = (VradiTreeNode)oldNode.getParent();
                helper.refresh(parent);
                helper.selectNode((NavNode)parent);
            }
            content.setModified(false);
        }
    }

    public ComboBoxModel getTypesModel() {
        FieldTypeModel model = new FieldTypeModel();
        return model;
    }

    public void openRequest(JAXXContext rootContext, Thesaurus thesaurus) {
        String request = ThesaurusDataHelper.getRequestName(thesaurus);
        QueryBean requestBean = null;
        try {
            requestBean = new QueryBean("\"" + request + "\"");
        }
        catch (IOException eee) {
            log.error((Object)("Cant parse query : " + request), (Throwable)eee);
        }
        this.openRequest(rootContext, requestBean, thesaurus, true);
    }

    public void openRequest(JAXXContext rootContext, QueryBean request) {
        this.openRequest(rootContext, request, null, false);
    }

    public void openRequest(final JAXXContext rootContext, QueryBean request, Thesaurus thesaurus, boolean isShowImply) {
        AdminRequestUI requestUI = this.createAdminRequestUI(rootContext, request, thesaurus);
        SearchHandler searchHandler = requestUI.getContextValue(SearchHandler.class);
        SearchUI searchUI = requestUI.getSearchUI();
        OfferListTableModel offerListTableModel = requestUI.getContextValue(OfferListTableModel.class);
        String query = requestUI.getRequest();
        FormPagedResult formPageDTO = new FormPagedResult();
        searchHandler.executeQuery((JAXXContext)searchUI, searchUI.getCriterias(), formPageDTO, null, query);
        offerListTableModel.setFormPagedResult(formPageDTO);
        requestUI.addPropertyChangeListener("request", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String newValue = (String)evt.getNewValue();
                RequestSelectUI ui = (RequestSelectUI)rootContext;
                QueryBean bean = ui.getBean();
                ui.setBean(bean.setQuery(newValue));
            }
        });
        if (isShowImply) {
            requestUI.setModal(true);
            requestUI.getSearchUI().getCriterias().setVisible(false);
            requestUI.getSearchPanel().setVisible(false);
            requestUI.getSearchUI().executeQuery();
        }
        requestUI.setVisible(true);
    }

    public AdminRequestUI createAdminRequestUI(JAXXContext rootContext, QueryBean request, Thesaurus thesaurus) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        SearchHandler searchHandler = new SearchHandler();
        OfferListTableModel offerListTableModel = new OfferListTableModel();
        OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        context.add((Object)searchHandler);
        context.add((Object)offerListTableModel);
        context.add((Object)offerListColumnFactory);
        AdminRequestUI requestUI = new AdminRequestUI((JAXXContext)context);
        OfferTable listTable = requestUI.getResultTable();
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
        MouseListener offerListTableMouseListener = UIHelper.getHandler((JAXXContext)context, OfferListHandler.class).getOfferListTableMouseListener();
        listTable.addMouseListener(offerListTableMouseListener);
        TableModelListener offerListTableModelListener = this.getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        listTable.setDefaultRenderer(XmlStream.class, renderer);
        listTable.setDefaultRenderer(Status.class, renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        SearchUI searchUI = searchHandler.initCloneUI((JAXXContext)context, offerListTableModel, thesaurus);
        String query = null;
        if (request != null) {
            query = request.getQuery();
            searchUI.setRequest(query);
        } else if (thesaurus != null) {
            requestUI.setCanSave(false);
            searchUI.setHidable(false);
        }
        requestUI.getSearchPanel().add((Component)((Object)searchUI), "Center");
        return requestUI;
    }

    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    public static List<Status> getAllStatuses() {
        try {
            ArrayList<Object> all = new ArrayList<Status>(VradiService.getVradiDataService().findAllStatus());
            if (all.isEmpty()) {
                log.info((Object)"No status found, creating default one");
                all = new ArrayList(VradiService.getVradiDataService().createDefaultStatuses());
            }
            Collections.sort(all, VradiComparators.STATUSES_COMPARATOR);
            return all;
        }
        catch (Exception eee) {
            log.error((Object)"Cant get all status : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
            return new ArrayList<Status>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStatuses(AdminStatusUI adminStatusUI) {
        List<Status> statuses = adminStatusUI.getStatuses();
        ArrayList<Status> toSave = new ArrayList<Status>();
        List<Status> deleted = adminStatusUI.getDeleted();
        int i = 0;
        for (Status status : statuses) {
            status.setValue(++i);
            toSave.add(status);
        }
        ArrayList<String> idsToDelete = new ArrayList<String>();
        for (Status toDelete : deleted) {
            log.info((Object)("Delete status " + toDelete.getName()));
            idsToDelete.add(toDelete.getWikittyId());
        }
        try {
            if (!VradiService.getVradiStorageService().deleteStatus(idsToDelete)) {
                List statusesNotDeleted = VradiService.getWikittyProxy().restore(Status.class, idsToDelete);
                for (Status s : statusesNotDeleted) {
                    String name = s.getName();
                    log.error((Object)("Abord delete status, status " + name + " is in use"));
                    JOptionPane.showMessageDialog(adminStatusUI, I18n._((String)"vradi.admin.isInUse", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.isInUse.title"), 1);
                }
            }
            VradiService.getWikittyProxy().store(toSave);
        }
        catch (VradiException eee) {
            log.error((Object)"Cant save status : ", (Throwable)eee);
        }
        finally {
            adminStatusUI.createStatuses(false);
        }
    }

    protected void createEntity(AdminNavUI ui, Class clazz) {
        ui.resetFilter();
        Class<?> uiClass = AdminBeanConstant.getUIClass(clazz);
        Object bean = AdminBeanConstant.getConstantByBeanClass(clazz).getBean(new VradiDataProvider(), null);
        this.showUI(ui, bean, uiClass);
    }

    public void createClient(AdminClientUI context) {
        AdminNavUI ui = this.getUI((JAXXContext)context).getClientAdminNavUI();
        this.createEntity(ui, Client.class);
    }

    public void createUser(JAXXContext context, Client clientConcerned) {
        if (clientConcerned == null) {
            return;
        }
        AdminNavUI ui = this.getUI(context).getClientAdminNavUI();
        ui.resetFilter();
        Class<?> uiClass = AdminBeanConstant.getUIClass(User.class);
        Object bean = AdminBeanConstant.getConstantByBeanClass(User.class).getBean(new VradiDataProvider(), null);
        User user = (User)bean;
        user.setClient(clientConcerned.getWikittyId());
        this.showUI(ui, bean, uiClass);
    }

    public void createGroup(AdminGroupUI context) {
        AdminNavUI ui = this.getUI((JAXXContext)context).getGroupAdminNavUI();
        this.createEntity(ui, Group.class);
    }

    public List<Client> getAllClients() {
        List values = VradiService.getVradiDataService().findAllClients();
        Collections.sort(values, VradiComparators.CLIENT_COMPARATOR);
        return values;
    }

    public List<Group> getAllGroups() {
        List values = VradiService.getVradiDataService().findAllGroups();
        Collections.sort(values, VradiComparators.GROUP_COMPARATOR);
        return values;
    }

    public List<User> getAllUsers() {
        List values = VradiService.getVradiDataService().findAllUsers();
        Collections.sort(values, VradiComparators.USER_COMPARATOR);
        return values;
    }

    public void createFormType(AdminFormTypeUI context, AdminNavigationTreeHelper helper) {
        String formTypeName = JOptionPane.showInputDialog(this.getUI((JAXXContext)context), I18n._((String)"vradi.adminFormType.askName"), I18n._((String)"vradi.adminFormType.askNameTitle"), 3);
        try {
            if (formTypeName != null) {
                if (!formTypeName.matches("\\w+")) {
                    JOptionPane.showMessageDialog(this.getUI((JAXXContext)context), I18n._((String)"vradi.adminFormType.askNameInvalid"), I18n._((String)"vradi.adminFormType.askNameTitle"), 0);
                } else {
                    this.getUI((JAXXContext)context).getFormAdminNavUI().resetFilter();
                    WikittyExtension extension = VradiService.getVradiDataService().createFormType(formTypeName);
                    helper.createAndSelectFormTypeNode(extension.getId());
                }
            }
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create new form type", (Throwable)ex);
            }
            throw new RuntimeException("Can't create new form type", (Object)ex);
        }
    }

    public void createForms(JAXXContext context) {
        final AdminXmlStreamUI xmlStreamUI = this.getXmlStreamUI(context);
        final XmlStream xmlStream = xmlStreamUI.getBean();
        if (xmlStream == null || xmlStream.getFormTypeName() == null) {
            JOptionPane.showMessageDialog(xmlStreamUI, I18n._((String)"vradi.admin.formsCreated.missingFormType"), I18n._((String)"vradi.admin.formsCreated.title"), 2);
            return;
        }
        VradiTask<XmlStreamImportResult> task = new VradiTask<XmlStreamImportResult>(context){

            @Override
            public XmlStreamImportResult doAction() throws Exception {
                return AdminHandler.this.createForms(xmlStream);
            }

            @Override
            public void doWhenDone() throws Exception {
                xmlStreamUI.getCreateForms().setEnabled(true);
                XmlStreamImportResult xmlStreamImportResult = (XmlStreamImportResult)this.get();
                AdminHandler.this.showFormCreationResults(xmlStreamUI, xmlStreamImportResult);
            }

            @Override
            public void doWhenError(Exception eee) {
                throw new RuntimeException("Can't import forms", (Object)eee);
            }
        };
        xmlStreamUI.getCreateForms().setEnabled(false);
        task.execute();
    }

    public XmlStreamImportResult createForms(XmlStream xmlStream) throws VradiException {
        VradiStorageService service = VradiService.getVradiStorageService();
        if (xmlStream instanceof WebHarvestStream) {
            return service.importFormsFromWebHarvestStream((WebHarvestStream)xmlStream);
        }
        return service.importFormsFromXmlStream(xmlStream);
    }

    protected void showFormCreationResults(AdminXmlStreamUI xmlStreamUI, XmlStreamImportResult xmlStreamImportResult) {
        int nbFormCreated = xmlStreamImportResult.getCreatedFormCount();
        int alreadyExisting = xmlStreamImportResult.getAlreadyExistsFormCount();
        int dateErrorParsing = xmlStreamImportResult.getDateParsingError();
        int numberErrorParsing = xmlStreamImportResult.getNumberParsingError();
        String optionMessage = I18n._((String)"vradi.admin.formsCreated.message.allWarning", (Object[])new Object[]{nbFormCreated, alreadyExisting, dateErrorParsing, numberErrorParsing});
        int messageType = 1;
        if (dateErrorParsing > 0 || numberErrorParsing > 0) {
            messageType = 2;
        }
        JOptionPane.showMessageDialog(xmlStreamUI, I18n._((String)"vradi.admin.formsCreated.message") + optionMessage, I18n._((String)"vradi.admin.formsCreated.title"), messageType);
    }

    public void saveFormType(AdminFormTypeUI context, AdminNavigationTreeHelper helper) {
        try {
            ArrayList<FieldSelectModel> fields = new ArrayList<FieldSelectModel>();
            VBox contentPanel = context.getContent();
            for (Component component : contentPanel.getComponents()) {
                fields.add(((FieldSelectUI)((Object)component)).getBean());
            }
            WikittyExtension uiExtension = context.getBean();
            WikittyExtension newFormType = new WikittyExtension(uiExtension.getName(), uiExtension.getVersion(), uiExtension.getRequires(), null);
            for (int i = 0; i < fields.size(); ++i) {
                FieldSelectModel model = (FieldSelectModel)fields.get(i);
                String name = model.getNameValue();
                if (name == null || model.getType() == null) continue;
                FieldType fieldType = model.getType().getFieldType();
                if (model.getDescValue() != null && !model.getDescValue().isEmpty()) {
                    fieldType.addTagValue("description", model.getDescValue());
                }
                fieldType.addTagValue("rank", String.valueOf(i));
                newFormType.addField(name, fieldType);
            }
            Date now = new Date();
            newFormType.addTagValue("lastModifiedDate", String.format("%1$td/%1$tm/%1$ty", now));
            newFormType.addTagValue("lastModifiedTime", String.format("%1$tk:%1$tM:%1$tS", now));
            newFormType.addTagValue("lastModifiedBy", context.getContextValue(VradiUser.class).getLogin());
            String templateName = (String)context.getTemplateChoice().getSelectedItem();
            WikittyExtension extension = VradiService.getVradiDataService().updateFormType(newFormType, templateName);
            helper.createAndSelectFormTypeNode(extension.getId());
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return VradiService.getVradiStorageService().getFormType(extensionName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void createWebHarvestStream(AdminXmlStreamUI context) {
        AdminNavUI ui = this.getUI((JAXXContext)context).getXmlStreamAdminNavUI();
        ui.resetFilter();
        this.createEntity(ui, WebHarvestStream.class);
    }

    public void createXmlStream(AdminXmlStreamUI context) {
        AdminNavUI ui = this.getUI((JAXXContext)context).getXmlStreamAdminNavUI();
        ui.resetFilter();
        this.createEntity(ui, XmlStream.class);
    }

    public void openWebHarvestEditor(JAXXContext context) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Ide().createAndShowGUI();
            }
        });
    }

    public void addWebHarvestScript(JAXXContext context, WebHarvestStream stream) {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this.getXmlStreamUI(context));
        if (returnVal == 0) {
            String url = null;
            try {
                url = VradiService.getFileService().uploadWebHarvestScript(chooser.getSelectedFile());
            }
            catch (VradiException eee) {
                log.error((Object)"Cant upload script : ", (Throwable)eee);
            }
            log.info((Object)("Script uploaded to " + url));
            stream.setScriptUrl(url);
        }
    }

    public void initScriptComboBox(JComboBox combo, WebHarvestStream bean) {
        VradiStorageService service = VradiService.getVradiStorageService();
        List webHarvestScripts = service.getAllWebHarvestScripts();
        combo.setModel(new DefaultComboBoxModel<Object>(webHarvestScripts.toArray()));
        combo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return new JLabel("");
                }
                String fileName = (String)value;
                return new JLabel(fileName);
            }
        });
        if (bean != null) {
            String fileToSelect = bean.getScriptUrl();
            combo.setSelectedItem(fileToSelect);
        }
    }

    public <E extends XmlStream> E saveStream(AdminXmlStreamUI ui, AdminNavigationTreeHelper helper, E xmlStream, List<XmlFieldBinding> bindings) {
        try {
            xmlStream = this.saveStream(xmlStream, bindings);
        }
        catch (Exception eee) {
            log.error((Object)eee.getMessage(), (Throwable)eee);
        }
        helper.createAndSelectStreamNode(xmlStream.getWikittyId());
        ui.setModified(false);
        return xmlStream;
    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        try {
            ArrayList xmlFieldBindingIds = new ArrayList();
            if (xmlStream.getXmlFieldBinding() != null) {
                xmlFieldBindingIds.addAll(xmlStream.getXmlFieldBinding());
            }
            List result = VradiService.getWikittyProxy().restore(XmlFieldBinding.class, xmlFieldBindingIds);
            return result;
        }
        catch (WikittyException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<XmlFieldBinding>();
        }
    }

    private <E extends XmlStream> WikittyExtension getFormType(E xmlStream) {
        if (xmlStream == null) {
            return null;
        }
        String formTypeName = xmlStream.getFormTypeName();
        if (formTypeName == null) {
            return null;
        }
        WikittyExtension formType = this.getExtension(formTypeName);
        return formType;
    }

    public void openAdminXmlStreamUI(final AdminXmlStreamUI xmlStreamUI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"openAdminXmlStreamUI(xmlStreamUI)");
        }
        xmlStreamUI.setModified(false);
        VradiTask<Void> task = new VradiTask<Void>((JAXXContext)xmlStreamUI){

            @Override
            public Void doAction() throws Exception {
                AdminHandler.this.updateXmlStreamFieldModel((JAXXContext)xmlStreamUI);
                return null;
            }

            @Override
            public void doWhenDone() throws Exception {
                xmlStreamUI.setModified(false);
                xmlStreamUI.setCursor(null);
                xmlStreamUI.validate();
            }
        };
        task.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateXmlStreamFieldModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlStreamFieldModel(context)");
        }
        AdminXmlStreamUI xmlStreamUI = (AdminXmlStreamUI)context;
        XmlStreamFieldTableModel fieldsModel = xmlStreamUI.getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);
        fieldsModel.clear();
        try {
            XmlStream bean = xmlStreamUI.getBean();
            if (bean == null) {
                return;
            }
            String url = bean.getUrl();
            if (bean instanceof WebHarvestStream) {
                final WebHarvestStream webHarvest = (WebHarvestStream)bean;
                if (webHarvest.getScriptUrl() == null) {
                    return;
                }
                VradiTask<String> createPreview = new VradiTask<String>(context){

                    @Override
                    public String doAction() throws Exception {
                        return VradiService.getVradiStorageService().getWebHarvestPreviewURL(webHarvest);
                    }
                };
                createPreview.execute();
                url = (String)createPreview.get();
            }
            if (url == null || url.trim().isEmpty()) {
                return;
            }
            WikittyExtension formType = this.getFormType(bean);
            if (formType == null) {
                return;
            }
            Set<String> xmlFieldNames = this.getXmlFieldNames(url);
            List<XmlFieldBinding> bindings = this.getXmlStreamFields(bean);
            LinkedHashMap<String, XmlFieldBinding> fieldNames = this.getAllBindingFields(formType);
            if (bindings != null && !bindings.isEmpty()) {
                boolean empty = xmlFieldNames.isEmpty();
                for (XmlFieldBinding binding : bindings) {
                    Set xmlFields;
                    String formField = binding.getFormField();
                    if (!fieldNames.containsKey(formField)) continue;
                    fieldNames.put(formField, binding);
                    if (!empty || (xmlFields = binding.getXmlField()) == null) continue;
                    xmlFieldNames.addAll(xmlFields);
                }
            }
            ArrayList<String> xmlFieldList = new ArrayList<String>(xmlFieldNames);
            xmlStreamUI.getContextValue(JListCellEditor.class).updateUniverse(xmlFieldList);
            xmlStreamUI.getContextValue(JListCellRenderer.class).updateUniverse(xmlFieldList);
            Collection<XmlFieldBinding> bindingCollection = fieldNames.values();
            fieldsModel.setBindings(bindingCollection);
            JXTable fieldsTable = xmlStreamUI.getFieldsTable();
            if (!xmlFieldNames.isEmpty()) {
                fieldsTable.setRowHeight(19 * xmlFieldNames.size());
            } else {
                fieldsTable.setRowHeight(19);
            }
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }

    private LinkedHashMap<String, XmlFieldBinding> getAllBindingFields(WikittyExtension formType) {
        LinkedHashMap<String, XmlFieldBinding> fieldMap = new LinkedHashMap<String, XmlFieldBinding>();
        fieldMap.put("Infogene.objet", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.description", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Form.datePub", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Form.datePeremption", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.entity", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.sourceText", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.sourceURL", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.country", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.department", (XmlFieldBinding)new XmlFieldBindingImpl());
        Collection fieldNames = formType.getFieldNames();
        for (String string : fieldNames) {
            fieldMap.put(formType.getName() + "." + string, (XmlFieldBinding)new XmlFieldBindingImpl());
        }
        for (Map.Entry entry : fieldMap.entrySet()) {
            XmlFieldBinding value = (XmlFieldBinding)entry.getValue();
            value.setFormField((String)entry.getKey());
        }
        return fieldMap;
    }

    private Set<String> getXmlFieldNames(String url) throws VradiException {
        Set<Object> xmlFieldNames = new LinkedHashSet();
        Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        Element element = xmlStreamFields.get(url);
        if (element == null) {
            try {
                Element firstElement = XmlStreamHelper.getFirstElement(url);
                xmlFieldNames = XmlStreamHelper.getRSSFields(firstElement);
                xmlStreamFields.put(url, firstElement);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            xmlFieldNames = XmlStreamHelper.getRSSFields(element);
        }
        return xmlFieldNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplateFieldTableModel(TemplateFieldBindingUI context, WikittyExtension extension, String templateName) {
        context.setTemplate(templateName);
        context.setExtension(extension.getName());
        TemplateFieldTableModel model = context.getFieldsModel();
        model.setValueIsAdjusting(true);
        model.clear();
        LinkedList<String> fieldNames = new LinkedList<String>();
        fieldNames.add("Infogene.id");
        fieldNames.add("Infogene.objet");
        fieldNames.add("Infogene.description");
        fieldNames.add("Infogene.creationDate");
        fieldNames.add("Form.datePub");
        fieldNames.add("Form.datePeremption");
        fieldNames.add("Infogene.entity");
        fieldNames.add("Infogene.sourceText");
        fieldNames.add("Infogene.sourceURL");
        fieldNames.add("Infogene.country");
        fieldNames.add("Infogene.department");
        for (String fieldName : extension.getFieldNames()) {
            fieldNames.add(extension.getName() + "." + fieldName);
        }
        context.getContextValue(JListCellEditor.class).updateUniverse(fieldNames);
        context.getContextValue(JListCellRenderer.class).updateUniverse(fieldNames);
        if (fieldNames.size() > 0) {
            context.getFieldsTable().setRowHeight(19 * fieldNames.size());
        }
        try {
            HashMap<String, String> fieldMap = VradiService.getVradiStorageService().getAssociatedFields(extension.getName(), templateName);
            if (fieldMap == null || fieldMap.isEmpty()) {
                fieldMap = new HashMap<String, String>();
                List templateFields = VradiService.getVradiStorageService().getDocumentFields(extension, templateName);
                for (String field : templateFields) {
                    fieldMap.put(field, null);
                }
            }
            model.setData(fieldMap);
        }
        catch (Exception eee) {
            log.error((Object)"Cant update template", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        finally {
            model.fireTableDataChanged();
            model.setValueIsAdjusting(false);
        }
    }

    public void saveTemplateFieldBinding(TemplateFieldBindingUI context) {
        TemplateFieldTableModel model = context.getFieldsModel();
        Map<String, String> fieldMap = model.getData();
        try {
            String extension = context.getExtension();
            String template = context.getTemplate();
            VradiService.getVradiStorageService().setAssociatedFields(extension, template, fieldMap);
            context.dispose();
        }
        catch (Exception eee) {
            log.error((Object)"Cant save template ", (Throwable)eee);
        }
    }

    private AdminXmlStreamUI getXmlStreamUI(JAXXContext context) {
        if (context instanceof AdminXmlStreamUI) {
            return (AdminXmlStreamUI)context;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstElementPreview(JAXXContext context, XmlStream bean) {
        if (bean == null || bean instanceof WebHarvestStream) {
            return "";
        }
        String url = bean.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return "";
        }
        Element firstElement = null;
        Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        if (xmlStreamFields.get(url) == null) {
            AdminXmlStreamUI ui = this.getXmlStreamUI(context);
            try {
                ui.setCursor(Cursor.getPredefinedCursor(3));
                firstElement = XmlStreamHelper.getFirstElement(url);
                xmlStreamFields.put(url, firstElement);
            }
            catch (Exception eee) {
                log.error((Object)"Can't get preview", (Throwable)eee);
            }
            finally {
                ui.setCursor(null);
            }
        } else {
            firstElement = xmlStreamFields.get(url);
        }
        if (firstElement == null) {
            return "";
        }
        Map<String, String> elementValues = XmlStreamHelper.getFirstElementValues(firstElement);
        StringBuffer result = new StringBuffer();
        result.append("<html>");
        for (Map.Entry<String, String> entry : elementValues.entrySet()) {
            result.append("<strong>").append(entry.getKey()).append("</strong>").append(" : ");
            String value = entry.getValue();
            if (value.length() > 500) {
                value = StringUtils.replace((String)value, (String)"\r", (String)"");
                value = StringUtils.replace((String)value, (String)"\n\n", (String)"\n");
                value = StringUtils.abbreviate((String)value, (int)500);
                value = StringUtils.replace((String)value, (String)"\n", (String)"<br/>");
            }
            result.append(value).append("<br/>");
        }
        result.append("</html>");
        return result.toString();
    }

    public ComboBoxModel getTemplateComboBoxModel(WikittyExtension extension) {
        Collection fileNames;
        DefaultComboBoxModel<Object> result = null;
        if (extension != null && CollectionUtils.isNotEmpty((Collection)(fileNames = VradiService.getVradiStorageService().getTemplateFilenames(extension)))) {
            result = new DefaultComboBoxModel<String>(fileNames.toArray(new String[fileNames.size()]));
        }
        if (result == null) {
            result = new DefaultComboBoxModel();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTemplateExample(AdminFormTypeUI context) {
        WikittyExtension extension = context.getBean();
        FormPagedResult formPage = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters();
        queryParameters.setExtension(extension);
        formPage = VradiHelper.executeQuery(queryParameters, formPage);
        if (formPage.getTotalFoundFormNb() > 0) {
            Form form = (Form)formPage.getFormsToShow().get(0);
            try {
                context.setCursor(new Cursor(3));
                String uri = VradiService.getVradiStorageService().generatePDF(form, false);
                File exampleFile = VradiService.getFileService().downloadPDF(uri);
                Desktop.getDesktop().open(exampleFile);
            }
            catch (VradiException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                ErrorDialogUI.showError((Exception)((Object)e));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                context.setCursor(null);
            }
        } else {
            JOptionPane.showMessageDialog(context, I18n._((String)"vradi.adminFormType.template.showExample.error.message"), I18n._((String)"vradi.adminFormType.template.showExample.error.title"), 0);
        }
    }

    public boolean uploadNewTemplate(AdminFormTypeUI adminFormTypeUI) {
        boolean result = false;
        try {
            File template = FileUtil.getFile((Component)adminFormTypeUI, (FileFilter[])new FileFilter[0]);
            if (template != null) {
                String extensionName = adminFormTypeUI.getBean().getName();
                String uri = VradiService.getFileService().uploadTemplate(template, extensionName);
                JComboBox templates = adminFormTypeUI.getTemplateChoice();
                templates.addItem(uri);
                templates.setSelectedItem(uri);
                result = true;
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"Can't upload file"), (Throwable)ex);
            }
            ErrorDialogUI.showError((Exception)ex);
        }
        return result;
    }

    public void downloadTemplate(AdminFormTypeUI adminFormTypeUI) {
        try {
            String selectedTemplate = (String)adminFormTypeUI.getTemplateChoice().getSelectedItem();
            if (StringUtils.isEmpty((String)selectedTemplate)) {
                return;
            }
            File savedTemplate = FileUtil.getFile((Component)adminFormTypeUI, (FileFilter[])new FileFilter[0]);
            if (savedTemplate != null) {
                String extensionName = adminFormTypeUI.getBean().getName();
                File downloadedFile = VradiService.getFileService().downloadTemplate(extensionName, selectedTemplate);
                FileUtils.copyFile((File)downloadedFile, (File)savedTemplate);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"Can't download file"), (Throwable)eee);
            }
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    public void showHistory(String id) {
        try {
            String url = VradiService.getFileService().getRequestHistoryURL(id + ".rss");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening request history : " + url));
            }
            try {
                UIHelper.browseURI(url);
            }
            catch (IOException eee) {
                log.error((Object)("Cannot display history for group : " + id));
                JOptionPane.showMessageDialog(null, I18n._((String)"vradi.message.cannot.display.history"));
            }
        }
        catch (VradiException eee) {
            if (log.isErrorEnabled()) {
                log.warn((Object)I18n._((String)"Can't download file"), (Throwable)eee);
            }
            JOptionPane.showConfirmDialog(new JFrame(), I18n._((String)"vradi.error.cantOpenHistory"), I18n._((String)"vradi.error.cantOpenHistory.title"), 0);
        }
    }
}

