/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import com.jurismarches.vradi.ui.task.ProgressBarUI;
import java.awt.*;
import java.awt.CardLayout;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminXmlStreamUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<XmlStream> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_XML_STREAM_UI_ENABLED = "adminXmlStreamUI.enabled";
    public static final String BINDING_CREATE_FORMS_ENABLED = "createForms.enabled";
    public static final String BINDING_CREATE_XML_STREAM_ENABLED = "createXmlStream.enabled";
    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATE_URL_ENABLED = "validateUrl.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_WEB_HARVEST_STREAM_URL_TEXT = "webHarvestStreamUrl.text";
    public static final String BINDING_XML_STREAM_CONFIG_BEAN = "xmlStreamConfig.bean";
    public static final String BINDING_XML_STREAM_NAME_TEXT = "xmlStreamName.text";
    public static final String BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT = "xmlStreamPreview.toolTipText";
    public static final String BINDING_XML_STREAM_URL_TEXT = "xmlStreamUrl.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_SIZE = "$JLabel0.size";
    private static final String BINDING_$JLABEL1_SIZE = "$JLabel1.size";
    private static final String BINDING_$JLABEL2_SIZE = "$JLabel2.size";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminXmlStreamForm;
    protected AdminXmlStreamUI adminXmlStreamUI = this;
    protected com.jurismarches.vradi.entities.XmlStream bean;
    protected javax.swing.JPanel cards;
    protected javax.swing.JButton createForms;
    protected javax.swing.JButton createWebHarvestStream;
    protected javax.swing.JButton createXmlStream;
    protected com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected javax.swing.JComboBox formTypeCombo;
    protected javax.swing.ComboBoxModel formTypeSelectionModel;
    protected javax.swing.JLabel lblName;
    protected javax.swing.JButton openWebHarvestEditor;
    protected javax.swing.JButton openWebHarvestScript;
    protected javax.swing.JLabel title;
    protected javax.swing.JButton validateUrl;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.XmlStream > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JComboBox webHarvestScript;
    protected javax.swing.JTextField webHarvestStreamUrl;
    protected com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI xmlStreamConfig;
    protected javax.swing.JTextField xmlStreamName;
    protected javax.swing.JLabel xmlStreamPreview;
    protected javax.swing.JButton xmlStreamSite;
    protected javax.swing.JTextField xmlStreamUrl;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    final static String XML_STREAM_PANEL = "vradi.adminXmlStream.xmlPanel";
    final static String WEB_HARVEST_PANEL = "vradi.adminXmlStream.webHarvestPanel";
    protected ActionListener comboListener;
    protected TableModelListener tableModelListener;
    
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
            n_("vradi.adminXmlStream.table.field.name"),
            n_("vradi.adminXmlStream.table.field.name.tip"),
            n_("vradi.adminXmlStream.table.field.values"),
            n_("vradi.adminXmlStream.table.field.values.tip"),
            n_("vradi.adminXmlStream.table.field.defaultValue"),
            n_("vradi.adminXmlStream.table.field.defaultValue.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value,
                      boolean isSelected, boolean hasFocus, int row, int column) {
    
                String sTranslatedValue = null;
                if (column == 0 && value != null) {
                    String sValue = (String) value;
                    int dot = sValue.lastIndexOf(".");
                    String extName = sValue.substring(0, dot);
                    if (Infogene.EXT_INFOGENE.equals(extName) || Form.EXT_FORM.equals(extName)) {
                        sTranslatedValue = _(sValue);
                    } else {
                        sTranslatedValue = sValue.substring(dot + 1);
                    }
                }
                return super.getTableCellRendererComponent(table, sTranslatedValue, isSelected, hasFocus, row, column);
            }
        };
    
        JListCellRenderer render = new JListCellRenderer(fieldsTable.getDefaultRenderer(String.class));
        setContextValue(render);
    
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, tbc);
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, render);
    
        JListCellEditor editor = new JListCellEditor();
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
    
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
            HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
        errorTable.registerValidator(validator);
    }
    
    @Override
    protected void postLoadBean() {
        if (bean == null) {
            return;
        }
        
        getHandler().openAdminXmlStreamUI(this);
    
        if (comboListener == null) {
            jaxx.runtime.JAXXUtil.assignment(comboListener = new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    WikittyExtension extension = (WikittyExtension) formTypeCombo.getSelectedItem();
                    if (extension != null && bean != null) {
                        bean.setFormTypeName(extension.getName());
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override
                            public void run() {
                                validateFormTypeChoice();
                            }
                        });
                        setModified(true);
                    }
                }
            }, "comboListener", com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI.this);
        }
        formTypeCombo.addActionListener(comboListener);
    
        if (tableModelListener == null) {
            jaxx.runtime.JAXXUtil.assignment(tableModelListener = new TableModelListener() {
                @Override
                public void tableChanged(TableModelEvent e) {
                    setModified(true);
                }
            }, "tableModelListener", com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI.this);
        }
        fieldsModel.addTableModelListener(tableModelListener);
    }
    
    protected void validateFormTypeChoice() {
        stopEditing();
        boolean modified = isModified();
        getHandler().updateXmlStreamFieldModel(this);
        setModified(modified);
        validate();
    }
    
    @Override
    public void save() {
        stopEditing();
        
        // add modification info
        String login = getContextValue(VradiUser.class).getLogin();
        ModificationTag xmlStreamTag = VradiService.getWikittyProxy().cast(bean, ModificationTag.class);
        xmlStreamTag.setLastModified(new Date());
        xmlStreamTag.setLastModifier(login);
    
        setModified(false);
    
        XmlStream bean = getBean();
    
        setBean(null);
        
        bean = getHandler().saveStream(this, getHelper(), bean, fieldsModel.getBindings());
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        xmlStreamName.setText("");
        xmlStreamUrl.setText("");
        webHarvestStreamUrl.setText("");
    }
    
    protected void initScriptComboBox() {
        getHandler().initScriptComboBox(webHarvestScript, (WebHarvestStream)getBean());
    }
    
    protected void stopEditing() {
        //FIXME-TC20091116 il faut pouvoir annuler l'édition si on sort du tableau
        if (fieldsTable.getCellEditor() != null) {
            fieldsTable.getCellEditor().stopCellEditing();
        }
        formTypeCombo.removeActionListener(comboListener);
        fieldsModel.removeTableModelListener(tableModelListener);
    }
    
    protected void createForms() {
        getHandler().createForms(this);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminXmlStream.title", SwingUtil.getStringValue(name));
    }
    
    protected void browseURI(String url) {
        try {
            UIHelper.browseURI(url);
        } catch (IOException eee){
            log.error("Cannot display XMLStream : " + url);
            JOptionPane.showMessageDialog(null,
                    _("vradi.message.cannot.display.stream"));
    
        }
    }
    
    protected String getCardToDisplay() {
        if (getBean() instanceof WebHarvestStream) {
            return WEB_HARVEST_PANEL;
        }
        return XML_STREAM_PANEL;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminXmlStreamUI() {
        super();
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.XmlStream > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createForms(java.awt.event.ActionEvent event) {
        createForms();
    }

    public void doActionPerformed__on__createWebHarvestStream(java.awt.event.ActionEvent event) {
        getHandler().createWebHarvestStream(this);
    }

    public void doActionPerformed__on__createXmlStream(java.awt.event.ActionEvent event) {
        getHandler().createXmlStream(this);
    }

    public void doActionPerformed__on__openWebHarvestEditor(java.awt.event.ActionEvent event) {
        getHandler().openWebHarvestEditor(this);
    }

    public void doActionPerformed__on__openWebHarvestScript(java.awt.event.ActionEvent event) {
        getHandler().addWebHarvestScript(this, (WebHarvestStream)getBean());initScriptComboBox();
    }

    public void doActionPerformed__on__validateUrl(java.awt.event.ActionEvent event) {
        validateFormTypeChoice();
    }

    public void doActionPerformed__on__xmlStreamSite(java.awt.event.ActionEvent event) {
        browseURI(getBean().getUrl());
    }

    public void doKeyReleased__on__webHarvestStreamUrl(java.awt.event.KeyEvent event) {
        getBean().setUrl(webHarvestStreamUrl.getText().matches("\\w+://.*") ? webHarvestStreamUrl.getText() : "http://" + webHarvestStreamUrl.getText());
    }

    public void doKeyReleased__on__xmlStreamName(java.awt.event.KeyEvent event) {
        getBean().setName(xmlStreamName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__xmlStreamUrl(java.awt.event.KeyEvent event) {
        getBean().setUrl(xmlStreamUrl.getText().matches("\\w+://.*") ? xmlStreamUrl.getText() : "http://" + xmlStreamUrl.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminXmlStreamForm() {
        return adminXmlStreamForm;
    }

    public com.jurismarches.vradi.entities.XmlStream getBean() {
        return bean;
    }

    public javax.swing.JPanel getCards() {
        return cards;
    }

    public javax.swing.JButton getCreateForms() {
        return createForms;
    }

    public javax.swing.JButton getCreateWebHarvestStream() {
        return createWebHarvestStream;
    }

    public javax.swing.JButton getCreateXmlStream() {
        return createXmlStream;
    }

    public com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public javax.swing.JComboBox getFormTypeCombo() {
        return formTypeCombo;
    }

    public javax.swing.ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public javax.swing.JLabel getLblName() {
        return lblName;
    }

    public javax.swing.JButton getOpenWebHarvestEditor() {
        return openWebHarvestEditor;
    }

    public javax.swing.JButton getOpenWebHarvestScript() {
        return openWebHarvestScript;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public javax.swing.JButton getValidateUrl() {
        return validateUrl;
    }

    public javax.swing.JComboBox getWebHarvestScript() {
        return webHarvestScript;
    }

    public javax.swing.JTextField getWebHarvestStreamUrl() {
        return webHarvestStreamUrl;
    }

    public com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI getXmlStreamConfig() {
        return xmlStreamConfig;
    }

    public javax.swing.JTextField getXmlStreamName() {
        return xmlStreamName;
    }

    public javax.swing.JLabel getXmlStreamPreview() {
        return xmlStreamPreview;
    }

    public javax.swing.JButton getXmlStreamSite() {
        return xmlStreamSite;
    }

    public javax.swing.JTextField getXmlStreamUrl() {
        return xmlStreamUrl;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.XmlStream newValue) {
        com.jurismarches.vradi.entities.XmlStream oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setFormTypeSelectionModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = newValue;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("formTypeName", formTypeCombo);
        validator.setFieldRepresentation("name", xmlStreamName);
        validator.setFieldRepresentation("url", xmlStreamUrl);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminXmlStreamForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminXmlStreamForm.add(lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(cards, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(formTypeCombo), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(validateUrl, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(xmlStreamConfig, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminXmlStreamForm, BorderLayout.NORTH);
        body.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToCards() {
        if (!allComponentsCreated) {
            return;
        }
        cards.add($Table0, XML_STREAM_PANEL);
        cards.add($Table1, WEB_HARVEST_PANEL);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminXmlStreamForm() {
        $objectMap.put("adminXmlStreamForm", adminXmlStreamForm = new jaxx.runtime.swing.Table());
        
        adminXmlStreamForm.setName("adminXmlStreamForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCards() {
        $objectMap.put("cards", cards = new javax.swing.JPanel());
        
        cards.setName("cards");
        cards.setLayout(new CardLayout());
    }

    protected void createCreateForms() {
        $objectMap.put("createForms", createForms = new javax.swing.JButton());
        
        createForms.setName("createForms");
        createForms.setText(_("vradi.adminXmlStream.createForms"));
        createForms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForms"));
    }

    protected void createCreateWebHarvestStream() {
        $objectMap.put("createWebHarvestStream", createWebHarvestStream = new javax.swing.JButton());
        
        createWebHarvestStream.setName("createWebHarvestStream");
        createWebHarvestStream.setText(_("vradi.adminXmlStream.createWebHarvestStream"));
        createWebHarvestStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createWebHarvestStream"));
    }

    protected void createCreateXmlStream() {
        $objectMap.put("createXmlStream", createXmlStream = new javax.swing.JButton());
        
        createXmlStream.setName("createXmlStream");
        createXmlStream.setText(_("vradi.adminXmlStream.createXmlStream"));
        createXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createXmlStream"));
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createFormTypeCombo() {
        $objectMap.put("formTypeCombo", formTypeCombo = new javax.swing.JComboBox());
        
        formTypeCombo.setName("formTypeCombo");
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = UIHelper.getFormTypesModel());
    }

    protected void createLblName() {
        $objectMap.put("lblName", lblName = new javax.swing.JLabel());
        
        lblName.setName("lblName");
        lblName.setText(_("vradi.adminXmlStream.name"));
    }

    protected void createOpenWebHarvestEditor() {
        $objectMap.put("openWebHarvestEditor", openWebHarvestEditor = new javax.swing.JButton());
        
        openWebHarvestEditor.setName("openWebHarvestEditor");
        openWebHarvestEditor.setToolTipText(_("vradi.adminXmlStream.createNewWebHarvest.toolTip"));
        openWebHarvestEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openWebHarvestEditor"));
    }

    protected void createOpenWebHarvestScript() {
        $objectMap.put("openWebHarvestScript", openWebHarvestScript = new javax.swing.JButton());
        
        openWebHarvestScript.setName("openWebHarvestScript");
        openWebHarvestScript.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openWebHarvestScript"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidateUrl() {
        $objectMap.put("validateUrl", validateUrl = new javax.swing.JButton());
        
        validateUrl.setName("validateUrl");
        validateUrl.setText(_("vradi.adminXmlStream.validateUrl"));
        validateUrl.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateUrl"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.XmlStream >(com.jurismarches.vradi.entities.XmlStream.class, null));
    }

    protected void createWebHarvestScript() {
        $objectMap.put("webHarvestScript", webHarvestScript = new javax.swing.JComboBox());
        
        webHarvestScript.setName("webHarvestScript");
    }

    protected void createWebHarvestStreamUrl() {
        $objectMap.put("webHarvestStreamUrl", webHarvestStreamUrl = new javax.swing.JTextField());
        
        webHarvestStreamUrl.setName("webHarvestStreamUrl");
        webHarvestStreamUrl.setColumns(15);
        webHarvestStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__webHarvestStreamUrl"));
    }

    protected void createXmlStreamConfig() {
        $objectMap.put("xmlStreamConfig", xmlStreamConfig = new com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI());
        
        xmlStreamConfig.setName("xmlStreamConfig");
    }

    protected void createXmlStreamName() {
        $objectMap.put("xmlStreamName", xmlStreamName = new javax.swing.JTextField());
        
        xmlStreamName.setName("xmlStreamName");
        xmlStreamName.setColumns(15);
        xmlStreamName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamName"));
    }

    protected void createXmlStreamPreview() {
        $objectMap.put("xmlStreamPreview", xmlStreamPreview = new javax.swing.JLabel());
        
        xmlStreamPreview.setName("xmlStreamPreview");
    }

    protected void createXmlStreamSite() {
        $objectMap.put("xmlStreamSite", xmlStreamSite = new javax.swing.JButton());
        
        xmlStreamSite.setName("xmlStreamSite");
        xmlStreamSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__xmlStreamSite"));
    }

    protected void createXmlStreamUrl() {
        $objectMap.put("xmlStreamUrl", xmlStreamUrl = new javax.swing.JTextField());
        
        xmlStreamUrl.setName("xmlStreamUrl");
        xmlStreamUrl.setColumns(15);
        xmlStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamUrl"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createXmlStream);
        $JPanel0.add(createWebHarvestStream);
        $JPanel0.add(createForms);
        $JPanel0.add($JButton0);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminXmlStreamForm();
        addChildrenToCards();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(xmlStreamUrl), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(xmlStreamPreview, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(xmlStreamSite, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webHarvestStreamUrl, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webHarvestScript, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(openWebHarvestScript, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(openWebHarvestEditor, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 16 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        createXmlStream.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.add"));
        createWebHarvestStream.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.delete"));
        $HidorButton0.setHideTip(_("vradi.adminXmlStream.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminXmlStream.showForm"));
        $HidorButton0.setTarget(adminXmlStreamForm);
        $HidorButton0.setTargetVisible(true);
        adminXmlStreamForm.setMinimumSize(SwingUtil.newMinDimension());
        xmlStreamPreview.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.magnify"));
        xmlStreamSite.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        openWebHarvestScript.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("open"));
        openWebHarvestEditor.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        formTypeCombo.setModel(formTypeSelectionModel);
        formTypeCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        fieldsTable.setModel(fieldsModel);
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminXmlStreamUI", this);
        createBean();
        createFieldsModel();
        createFormTypeSelectionModel();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateXmlStream();
        createCreateWebHarvestStream();
        createCreateForms();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminXmlStream.deleteXmlStream"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        createAdminXmlStreamForm();
        createLblName();
        createXmlStreamName();
        createCards();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.url"));
        createXmlStreamUrl();
        createXmlStreamPreview();
        createXmlStreamSite();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminXmlStream.startUrl"));
        createWebHarvestStreamUrl();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminXmlStream.webHarvestScript"));
        createWebHarvestScript();
        createOpenWebHarvestScript();
        createOpenWebHarvestEditor();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminXmlStream.formType"));
        createFormTypeCombo();
        createValidateUrl();
        createXmlStreamConfig();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of adminXmlStreamUI
        setName("adminXmlStreamUI");
        ((jaxx.runtime.swing.Table) adminXmlStreamUI.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 16 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 16 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_XML_STREAM_UI_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_XML_STREAM_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createXmlStream.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_FORMS_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                createForms.setEnabled(isEnabled() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamName, getBean().getName());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel0.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    javax.swing.JLabel $target = ((javax.swing.JLabel) $bindingSources.remove("lblName"));
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(java.awt.event.ComponentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_URL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamUrl, getBean().getUrl());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                xmlStreamPreview.setToolTipText(_(getHandler().getFirstElementPreview(AdminXmlStreamUI.this, getBean())));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel1.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    javax.swing.JLabel $target = ((javax.swing.JLabel) $bindingSources.remove("lblName"));
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(java.awt.event.ComponentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_WEB_HARVEST_STREAM_URL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(webHarvestStreamUrl, getBean().getUrl());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u2"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel2.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    javax.swing.JLabel $target = ((javax.swing.JLabel) $bindingSources.remove("lblName"));
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u2"));
                    }
                }
            }
        
            public void $pr$u2(java.awt.event.ComponentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    formTypeCombo.setSelectedItem(getHandler().getExtension(getBean().getFormTypeName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATE_URL_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                validateUrl.setEnabled(isEnabled() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_CONFIG_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                xmlStreamConfig.setBean(getBean());
            }
        });
    }

}