/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.thesaurus.models;

import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.TreeNode;

public class ThesaurusCartographyTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(ThesaurusCartographyTreeTableModel.class);
    protected SortedMap<String, List<RootThesaurus>> rootThesaurusCache = new TreeMap<String, List<RootThesaurus>>();
    protected Map<Thesaurus, Integer> formCountCache = new HashMap<Thesaurus, Integer>();
    protected SortedMap<String, List<Thesaurus>> thesaurusCache = new TreeMap<String, List<Thesaurus>>();
    protected QueryParameters queryParameters;

    public ThesaurusCartographyTreeTableModel(QueryParameters queryParameters) {
        super((Object)"1");
        this.queryParameters = queryParameters;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        String columnName = null;
        if (column == 0) {
            columnName = I18n._((String)"vradi.thesaurus.name");
        } else if (column == 1) {
            columnName = I18n._((String)"vradi.thesaurus.nbforms");
        } else if (column == 2) {
            columnName = I18n._((String)"vradi.thesaurus.tags");
        }
        return columnName;
    }

    public Object getValueAt(Object node, int column) {
        Object result = null;
        if (node instanceof RootThesaurus) {
            RootThesaurus treeNode = (RootThesaurus)node;
            if (column == 0) {
                result = treeNode.getName();
            }
        } else if (node instanceof Thesaurus) {
            Thesaurus treeNode = (Thesaurus)node;
            if (column == 0) {
                result = treeNode;
            } else if (column == 1) {
                result = this.formCountCache.get(treeNode);
            } else if (column == 2) {
                Set<String> tags = treeNode.getTags();
                result = StringUtils.join(tags, (char)',');
            }
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result;
        block4: {
            result = null;
            try {
                if (parent == this.getRoot()) {
                    result = ((List)this.rootThesaurusCache.get("root")).get(index);
                } else {
                    TreeNode thesaurus = (TreeNode)parent;
                    result = ((List)this.thesaurusCache.get(thesaurus.getWikittyId())).get(index);
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't get children thesaurus", (Throwable)ex);
            }
        }
        return result;
    }

    public int getChildCount(Object parent) {
        int result;
        block6: {
            result = 0;
            try {
                if (parent == this.getRoot()) {
                    if (this.rootThesaurusCache.get("root") == null) {
                        List rootThesauruses = VradiService.getVradiDataService().getRootThesaurus();
                        this.rootThesaurusCache.put("root", rootThesauruses);
                    }
                    result = ((List)this.rootThesaurusCache.get("root")).size();
                } else {
                    TreeNode thesaurus = (TreeNode)parent;
                    if (this.thesaurusCache.get(thesaurus.getWikittyId()) == null) {
                        Map results = VradiService.getVradiDataService().getChildrenCartography(thesaurus.getWikittyId(), this.queryParameters);
                        this.formCountCache.putAll(results);
                        this.thesaurusCache.put(thesaurus.getWikittyId(), new ArrayList(results.keySet()));
                    }
                    result = ((List)this.thesaurusCache.get(thesaurus.getWikittyId())).size();
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't get children thesaurus", (Throwable)ex);
            }
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;
        return result;
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
    }

    public class CartographieTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String toolTip = null;
            if (value instanceof TreeNode) {
                TreeNode node = (TreeNode)value;
                value = node.getName();
            }
            JComponent component = (JComponent)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            component.setToolTipText(toolTip);
            return component;
        }
    }
}

