/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.models;

import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.binding.DefaultJAXXBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.WikittyExtension;

public class OfferListTableModel
extends AbstractTableModel {
    private static final Log log = LogFactory.getLog(OfferListTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PAGE_TO_SHOW = "pageToShow";
    public static final String PROPERTY_NB_FORMS_PER_PAGE = "nbFormsPerPage";
    public static final String PROPERTY_BINDING_CHANGE = "bindings";
    public static final String PROPERTY_TOTAL_FORMS = "totalFoundFormNb";
    public static final String PROPERTY_NB_PAGES = "nbPagesAsText";
    public static final String PROPERTY_LAST_PAGE = "lastPage";
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected final List<Column> columns = new ArrayList<Column>();
    protected FormPagedResult formPagedResult = new FormPagedResult();
    protected boolean showThesaurusToolTip = false;

    public OfferListTableModel() {
        this(false);
    }

    public OfferListTableModel(boolean showThesaurusToolTip) {
        this.initColumns();
        this.formPagedResult.setPageToShow(1);
        this.formPagedResult.setNbFormsToShow(10);
        this.showThesaurusToolTip = showThesaurusToolTip;
    }

    public OfferListTableModel(FormPagedResult formPage) {
        this(formPage, false);
    }

    public OfferListTableModel(FormPagedResult formPagedResult, boolean showThesaurusToolTip) {
        this.initColumns();
        formPagedResult.setPageToShow(formPagedResult.getPageToShow());
        formPagedResult.setNbFormsToShow(formPagedResult.getNbFormsToShow());
        this.setFormPagedResult(formPagedResult);
        this.showThesaurusToolTip = showThesaurusToolTip;
    }

    public void setFormPagedResult(FormPagedResult formPagedResult) {
        if (formPagedResult == null) {
            throw new IllegalArgumentException("formPageDTO is null");
        }
        this.formPagedResult = formPagedResult;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_TOTAL_FORMS, null, (Object)formPagedResult.getTotalFoundFormNb());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NB_PAGES, null, (Object)this.getNbPages());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_LAST_PAGE, null, (Object)this.isLastPage());
        this.fireTableDataChanged();
    }

    public FormPagedResult getFormPagedResult() {
        return this.formPagedResult;
    }

    protected void initColumns() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String fieldName : InfogeneImpl.extensionInfogene.getFieldNames()) {
            fieldNames.add("Infogene." + fieldName);
        }
        fieldNames.add("Form.datePub");
        fieldNames.add("Form.datePeremption");
        fieldNames.add("Form.xmlStream");
        for (String fqFieldName : fieldNames) {
            int dot = fqFieldName.lastIndexOf(".");
            String extensionName = fqFieldName.substring(0, dot);
            String fieldName = fqFieldName.substring(dot + 1);
            WikittyExtension extension = extensionName.equals("Infogene") ? InfogeneImpl.extensionInfogene : FormImpl.extensionForm;
            FieldType fieldType = extension.getFieldType(fieldName);
            Class columnClass = fieldType.getType() == FieldType.TYPE.BOOLEAN ? Boolean.class : (fieldType.getType() == FieldType.TYPE.DATE ? Date.class : (fieldType.getType() == FieldType.TYPE.NUMERIC ? Double.class : (fieldName.equals("status") ? Status.class : (fieldName.equals("xmlStream") ? XmlStream.class : String.class))));
            Column column = new Column(extensionName, fieldName, columnClass);
            this.columns.add(column);
        }
    }

    public Integer getNbFormsPerPage() {
        return this.formPagedResult.getNbFormsToShow();
    }

    public void setNbFormsPerPage(Integer nbFormsPerPage) {
        Integer pageToShow;
        Integer nbFormsToShow = this.formPagedResult.getNbFormsToShow();
        int topRow = nbFormsToShow * (this.formPagedResult.getPageToShow() - 1);
        if ((pageToShow = Integer.valueOf((int)Math.ceil((double)(++topRow) / nbFormsPerPage.doubleValue()))) < 1) {
            pageToShow = 1;
        }
        this.formPagedResult.setNbFormsToShow(nbFormsPerPage.intValue());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NB_FORMS_PER_PAGE, nbFormsToShow, nbFormsPerPage);
        this.setPageToShow(pageToShow);
    }

    public int getPageToShow() {
        return this.formPagedResult.getPageToShow();
    }

    public void setPageToShow(int pageToShow) {
        int oldValue = this.formPagedResult.getPageToShow();
        this.formPagedResult.setPageToShow(pageToShow);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PAGE_TO_SHOW, oldValue, pageToShow);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_BINDING_CHANGE, Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isLastPage() {
        int pageToShow;
        int nbPages = this.getNbPages();
        boolean result = nbPages == (pageToShow = this.formPagedResult.getPageToShow());
        return result;
    }

    public String getNbPagesAsText() {
        int nbPages = this.getNbPages();
        return " / " + String.valueOf(nbPages);
    }

    protected int getNbPages() {
        int nbFormsPerPage;
        int totalFoundFormNb = this.formPagedResult.getTotalFoundFormNb();
        int nbPages = (int)Math.ceil((double)totalFoundFormNb / (double)(nbFormsPerPage = this.formPagedResult.getNbFormsToShow()));
        if (nbPages <= 0) {
            nbPages = 1;
        }
        return nbPages;
    }

    public String getFieldToSort() {
        return this.formPagedResult.getFieldToSort();
    }

    public void setFieldToSort(String fieldToSort) {
        if (fieldToSort != null) {
            this.formPagedResult.setFieldToSort(fieldToSort);
        }
    }

    public boolean isAscending() {
        return this.formPagedResult.isAscending();
    }

    public void setAscending(boolean ascending) {
        this.formPagedResult.setAscending(ascending);
    }

    public int getTotalFoundFormNb() {
        return this.formPagedResult.getTotalFoundFormNb();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        Column column = this.columns.get(col);
        return column.i18name;
    }

    @Override
    public int getRowCount() {
        return this.formPagedResult.getFormsToShow() != null ? this.formPagedResult.getFormsToShow().size() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        List formsToShow = this.formPagedResult.getFormsToShow();
        if (formsToShow == null) {
            return null;
        }
        if (row >= formsToShow.size()) {
            return null;
        }
        Form form = (Form)formsToShow.get(row);
        if (form == null) {
            return null;
        }
        String fqColumnName = this.getColumnFqName(col);
        int indexOf = fqColumnName.indexOf(46);
        String extension = fqColumnName.substring(0, indexOf);
        String fieldName = fqColumnName.substring(indexOf + 1);
        if (fieldName.equals("status")) {
            Status status;
            String statusId = form.getStatus();
            try {
                status = (Status)VradiService.getWikittyProxy().restore(Status.class, statusId);
            }
            catch (Exception eee) {
                log.error((Object)eee);
                return null;
            }
            return status;
        }
        if (fieldName.equals("xmlStream")) {
            XmlStream stream;
            String xmlSreamId = form.getXmlStream();
            try {
                stream = (XmlStream)VradiService.getWikittyProxy().restore(XmlStream.class, xmlSreamId);
            }
            catch (Exception eee) {
                log.error((Object)eee);
                return null;
            }
            return stream;
        }
        Object field = form.getField(extension, fieldName);
        FieldType fieldType = form.getFieldType(extension, fieldName);
        Object result = fieldType.getValidValue(field);
        return result;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        Column column = this.columns.get(col);
        return column.columnClass;
    }

    public String getColumnFqName(int col) {
        Column column = this.columns.get(col);
        return column.fqName;
    }

    public String getToolTip(int row) {
        List formsToShow = this.formPagedResult.getFormsToShow();
        if (formsToShow == null) {
            return null;
        }
        if (row >= formsToShow.size()) {
            return null;
        }
        Form form = (Form)formsToShow.get(row);
        if (this.showThesaurusToolTip) {
            return ToolTipHelper.getEmailThesaurusToolTip(form);
        }
        return ToolTipHelper.getToolTip(form);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public static class OfferListTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue = value == null ? null : (value instanceof Date ? DateFormat.getDateTimeInstance(3, 3, Locale.FRANCE).format((Date)value) : (value instanceof Status ? I18n._((String)((Status)value).getName()) : (value instanceof XmlStream ? I18n._((String)((XmlStream)value).getName()) : String.valueOf(value))));
            OfferListTableModel model = (OfferListTableModel)table.getModel();
            this.setToolTipText(model.getToolTip(table.convertRowIndexToModel(row)));
            return super.getTableCellRendererComponent(table, stringValue, isSelected, hasFocus, row, column);
        }
    }

    public static abstract class OfferListTableModelBinding
    extends DefaultJAXXBinding {
        protected OfferListTableModel model;

        public OfferListTableModelBinding(JAXXObject source, String id, OfferListTableModel model) {
            super(source, id, false);
            this.model = model;
        }

        public void applyDataBinding() {
            if (this.model != null) {
                this.model.addPropertyChangeListener(OfferListTableModel.PROPERTY_BINDING_CHANGE, (PropertyChangeListener)((Object)this));
            }
        }

        public void removeDataBinding() {
            if (this.model != null) {
                this.model.removePropertyChangeListener(OfferListTableModel.PROPERTY_BINDING_CHANGE, (PropertyChangeListener)((Object)this));
            }
        }
    }

    static class Column {
        private static final String I18N_COLUMN_PREFIX = "vradi.offer.";
        final String i18name;
        final Class<?> columnClass;
        final String fqName;

        Column(String extension, String name, Class<?> columnClass) {
            this.fqName = extension + "." + name;
            this.columnClass = columnClass;
            this.i18name = I18n._((String)(I18N_COLUMN_PREFIX + this.fqName));
        }
    }
}

