/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.ThesaurusCartography;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.EntityModel;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusCartographyUI;
import com.jurismarches.vradi.ui.offer.thesaurus.models.ThesaurusCartographyModel;
import com.jurismarches.vradi.ui.search.CriteriaField;
import com.jurismarches.vradi.ui.search.CriteriaUI;
import com.jurismarches.vradi.ui.search.SearchUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.WikittyExtension;

public class SearchHandler {
    private static final Log log = LogFactory.getLog(SearchHandler.class);
    public static final String CSV_FILE_EXTENSION = ".csv";
    public static final String DATE_CRITERIA_I18N_PREFIX = "vradi.criteria.typeDate.";

    public SearchUI initUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        SearchUI ui = this.getUI(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
            context.add((Object)this);
            context.add((Object)resultTableModel);
            ui = new SearchUI((JAXXContext)context);
            this.initCriteria((JAXXContext)ui);
            VradiContext.SEARCH_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)ui);
        }
        return ui;
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        return this.initCloneUI(rootContext, resultTableModel, null);
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel, Thesaurus thesaurus) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        context.add((Object)resultTableModel);
        SearchUI ui = new SearchUI((JAXXContext)context);
        if (thesaurus != null) {
            ArrayList<Thesaurus> criteriaList = new ArrayList<Thesaurus>();
            criteriaList.add(thesaurus);
            this.initCriteria((JAXXContext)ui, criteriaList);
        }
        return ui;
    }

    SearchUI getUI(JAXXContext context) {
        if (context instanceof SearchUI) {
            return (SearchUI)context;
        }
        SearchUI ui = (SearchUI)((Object)VradiContext.SEARCH_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get()));
        return ui;
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public void executeQuery(JAXXContext context) {
        final SearchUI searchUI = this.getUI(context);
        if (searchUI != null) {
            final String query = searchUI.getRequest();
            final JComboBox combo = searchUI.isOfferListUI() != false ? searchUI.getRequests() : null;
            final CriteriaUI criterias = searchUI.getCriterias().isVisible() ? searchUI.getCriterias() : null;
            final OfferListTableModel listTableModel = searchUI.getResultTableModel();
            final FormPagedResult formPageDTO = listTableModel.getFormPagedResult();
            VradiTask<FormPagedResult> task = new VradiTask<FormPagedResult>(context, false){

                @Override
                public FormPagedResult doAction() throws Exception {
                    return SearchHandler.this.executeQuery((JAXXContext)searchUI, criterias, formPageDTO, combo, query);
                }

                @Override
                public void doWhenDone() throws Exception {
                    searchUI.getRootPane().setCursor(null);
                    FormPagedResult formPageDTO2 = (FormPagedResult)this.get();
                    listTableModel.setFormPagedResult(formPageDTO2);
                }
            };
            task.execute();
        } else {
            log.warn((Object)"searchUI is null !");
        }
    }

    public void executeQuery(JAXXContext context, int pageToShow) {
        SearchUI searchUI = this.getUI(context);
        if (searchUI != null) {
            OfferListTableModel listTableModel = searchUI.getResultTableModel();
            listTableModel.setPageToShow(pageToShow);
        } else {
            log.warn((Object)"searchUI is null !");
        }
    }

    public List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public JPanel getCriteriaPanel(JAXXContext context) {
        SearchUI ui = this.getUI(context);
        CriteriaUI criterias = ui.getCriterias();
        return criterias.getCriteriaPanel();
    }

    public CriteriaUI getCriterias(JAXXContext context) {
        return this.getUI(context).getCriterias();
    }

    public void initCriteria(JAXXContext context) {
        this.initCriteria(context, null);
    }

    public void initCriteria(JAXXContext context, List<Thesaurus> thesaurus) {
        this.getCriteriaPanel(context).removeAll();
        List<String> rootThesaurusListCriteria = VradiHelper.getVradiListRootCriteria();
        for (String value : rootThesaurusListCriteria) {
            this.addCriteria(context, value, true);
        }
        List<String> thesaurusListCriteria = VradiHelper.getVradiListCriteria();
        for (String value : thesaurusListCriteria) {
            this.addCriteria(context, value, true);
        }
        if (thesaurus != null) {
            for (Thesaurus t : thesaurus) {
                this.addUnmodifiableCriteria(context, t);
            }
        }
    }

    public void removeCriteria(JAXXContext context, CriteriaField criteriaField) {
        this.getCriteriaPanel(context).remove((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    public void removeCriteriaAndPersist(JAXXContext context, Thesaurus bean) {
        CriteriaField criteriaField = (CriteriaField)context;
        VradiHelper.removeVradiListCriteria(bean);
        this.removeCriteria(context, criteriaField);
        this.getUI(context).validate();
    }

    public void removeRootCriteriaAndPersist(JAXXContext context, RootThesaurus bean) {
        CriteriaField criteriaField = (CriteriaField)context;
        VradiHelper.removeVradiListRootCriteria(bean);
        this.removeCriteria(context, criteriaField);
        this.getUI(context).validate();
    }

    public void addUnmodifiableCriteria(JAXXContext context, Thesaurus thesaurus) {
        CriteriaField criteriaField;
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            RootThesaurus root = ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus());
            criteriaField = this.addCriteria(context, root, false, false);
        } else {
            Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(thesaurus.getParent());
            criteriaField = this.addCriteria(context, parent, false, false);
        }
        JComboBox combo = criteriaField.getCombo();
        combo.getModel().setSelectedItem(thesaurus);
        combo.setSelectedItem(thesaurus);
    }

    public void addAndPersistCriteria(JAXXContext context, Thesaurus thesaurus) {
        VradiHelper.addVradiListCriteria(thesaurus);
        this.addCriteria(context, thesaurus, true, true);
    }

    protected void addRootCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        if (wikittyId == null || wikittyId.isEmpty()) {
            return;
        }
        RootThesaurus criteriaThe = ThesaurusDataHelper.restoreRootThesaurus(wikittyId);
        if (criteriaThe != null) {
            this.addCriteria(context, criteriaThe, deletable, true);
        }
    }

    protected void addCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        if (wikittyId == null || wikittyId.isEmpty()) {
            return;
        }
        Thesaurus criteriaThe = ThesaurusDataHelper.restoreThesaurus(wikittyId);
        if (criteriaThe != null) {
            this.addCriteria(context, criteriaThe, deletable, true);
        }
    }

    protected CriteriaField addCriteria(JAXXContext context, RootThesaurus thesCriteria, boolean deletable, boolean enabled) {
        CriteriaField criteriaField = new CriteriaField(context);
        criteriaField.setLabelName(thesCriteria.getName());
        criteriaField.setRootThesaurus(thesCriteria);
        List<Thesaurus> children = ThesaurusDataHelper.getChildrenOfRootThesaurus(thesCriteria.getWikittyId());
        this.initCriteriaField(context, criteriaField, children, deletable, enabled);
        return criteriaField;
    }

    protected CriteriaField addCriteria(JAXXContext context, Thesaurus thesCriteria, boolean deletable, boolean enabled) {
        CriteriaField criteriaField = new CriteriaField(context);
        criteriaField.setLabelName(thesCriteria.getName());
        criteriaField.setThesaurus(thesCriteria);
        List<Thesaurus> children = ThesaurusDataHelper.getChildrenOfThesaurus(thesCriteria.getWikittyId());
        this.initCriteriaField(context, criteriaField, children, deletable, enabled);
        return criteriaField;
    }

    protected void initCriteriaField(JAXXContext context, CriteriaField criteriaField, List<Thesaurus> children, boolean deletable, boolean enabled) {
        criteriaField.setDeletable(deletable);
        criteriaField.setActif(enabled);
        JComboBox combo = criteriaField.getCombo();
        combo.setModel(new EntityModel<Thesaurus>(Thesaurus.class, "Thesaurus", children, true));
        combo.setMaximumRowCount(30);
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        criteriaField.init();
        JPanel criteriaPanel = this.getCriteriaPanel(context);
        criteriaPanel.add((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Infogene.creationDate");
        result.add("Form.datePub");
        result.add("Form.datePeremption");
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() != FieldType.TYPE.DATE) continue;
                result.add(formType.getName() + "." + name);
            }
        }
        return result;
    }

    public DefaultComboBoxModel updateDateSelectionModel(WikittyExtension selected) {
        List<String> datas = this.getDateFormType(selected);
        return new DefaultComboBoxModel<String>(datas.toArray(new String[datas.size()]));
    }

    public FormPagedResult executeQuery(JAXXContext context, CriteriaUI criterias, FormPagedResult formPagedResult, JComboBox combo, String request) {
        if (criterias == null) {
            formPagedResult = VradiHelper.executeQuery(request, null, null, null, null, null, null, null, formPagedResult);
        } else {
            Component[] thesaurusCriteria = this.getCriteriaPanel(context).getComponents();
            ArrayList<Thesaurus> thesaurus = new ArrayList<Thesaurus>();
            for (int i = 0; i < thesaurusCriteria.length; ++i) {
                Thesaurus tn = (Thesaurus)((CriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (tn == null || tn.getName().trim().isEmpty()) continue;
                String wikittyId = tn.getWikittyId();
                Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                thesaurus.add(parent);
            }
            formPagedResult = this.executeQuery(request, criterias, thesaurus, formPagedResult);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Total forms found        : " + formPagedResult.getTotalFoundFormNb()));
            log.info((Object)("Number of forms per page : " + formPagedResult.getNbFormsToShow()));
            log.info((Object)("Actual page              : " + formPagedResult.getPageToShow()));
        }
        if (this.getUI(context).getParentContainer(OfferListUI.class) != null) {
            VradiHelper.addRequestToProperties(request);
        }
        if (combo != null) {
            ((DefaultComboBoxModel)combo.getModel()).removeElement(request);
            combo.insertItemAt(request, 0);
            combo.setSelectedIndex(0);
        }
        return formPagedResult;
    }

    public void executeCartography(final SearchUI searchUI) {
        final String query = searchUI.getRequest();
        final JComboBox combo = searchUI.isOfferListUI() != false ? searchUI.getRequests() : null;
        final CriteriaUI criterias = searchUI.getCriterias().isVisible() ? searchUI.getCriterias() : null;
        VradiTask<ThesaurusCartography> task = new VradiTask<ThesaurusCartography>((JAXXContext)searchUI){

            @Override
            public ThesaurusCartography doAction() throws Exception {
                return SearchHandler.this.executeCartography(searchUI, criterias, combo, query);
            }

            @Override
            public void doWhenDone() throws Exception {
                searchUI.getRootPane().setCursor(null);
                ThesaurusCartography cartography = (ThesaurusCartography)this.get();
                if (cartography != null) {
                    ThesaurusCartographyModel cartographyModel = new ThesaurusCartographyModel(cartography);
                    DefaultJAXXContext context = new DefaultJAXXContext();
                    context.setContextValue((Object)cartographyModel);
                    ThesaurusCartographyUI cartographyUI = new ThesaurusCartographyUI((JAXXContext)context);
                    cartographyUI.setVisible(true);
                }
            }
        };
        task.execute();
    }

    ThesaurusCartography executeCartography(SearchUI searchUI, CriteriaUI criterias, JComboBox combo, String request) throws VradiException, UnsupportedQueryException {
        ThesaurusCartography cartography = null;
        if (criterias == null) {
            cartography = VradiService.getVradiDataService().getThesaurusCartography(request, null, null, null, null, null, null, null);
        } else {
            Component[] thesaurusCriteria = this.getCriteriaPanel((JAXXContext)searchUI).getComponents();
            ArrayList<String> thesaurus = new ArrayList<String>();
            for (int i = 0; i < thesaurusCriteria.length; ++i) {
                TreeNodeImpl tn = (TreeNodeImpl)((CriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (tn == null || tn.getName().trim().isEmpty()) continue;
                String wikittyId = tn.getWikittyId();
                Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                thesaurus.addAll(ThesaurusDataHelper.getChildrenRecursif(parent));
            }
            GregorianCalendar beginDate = new GregorianCalendar();
            beginDate.setTime(criterias.getFromDate().getDate());
            beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
            beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
            GregorianCalendar endDate = new GregorianCalendar();
            endDate.setTime(criterias.getToDate().getDate());
            endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
            endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
            WikittyExtension extension = (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem();
            String dateType = (String)criterias.getDateTypeSelection().getSelectedItem();
            XmlStream xmlStream = (XmlStream)criterias.getXmlStreamSelection().getSelectedItem();
            String realRequest = request;
            Object[] statuses = criterias.getStatusSelection().getSelectedValues();
            String[] statusIds = new String[statuses.length];
            for (int i = 0; i < statuses.length; ++i) {
                statusIds[i] = ((Status)statuses[i]).getWikittyId();
            }
            String streamId = null;
            if (xmlStream != null) {
                streamId = xmlStream.getWikittyId();
            }
            cartography = VradiService.getVradiDataService().getThesaurusCartography(request, extension, dateType, beginDate.getTime(), endDate.getTime(), streamId, thesaurus, statusIds);
        }
        return cartography;
    }

    public FormPagedResult executeQuery(String request, CriteriaUI criterias, List<Thesaurus> thesauruses, FormPagedResult formPagedResult) {
        GregorianCalendar beginDate = new GregorianCalendar();
        beginDate.setTime(criterias.getFromDate().getDate());
        beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
        beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
        GregorianCalendar endDate = new GregorianCalendar();
        endDate.setTime(criterias.getToDate().getDate());
        endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
        endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
        WikittyExtension extension = (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem();
        String dateType = (String)criterias.getDateTypeSelection().getSelectedItem();
        XmlStream xmlStream = (XmlStream)criterias.getXmlStreamSelection().getSelectedItem();
        Object[] statuses = criterias.getStatusSelection().getSelectedValues();
        String[] statusIds = new String[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            statusIds[i] = ((Status)statuses[i]).getWikittyId();
        }
        String streamId = null;
        if (xmlStream != null) {
            streamId = xmlStream.getWikittyId();
        }
        ArrayList<String> thesaurusIds = new ArrayList<String>();
        for (Thesaurus thesaurus : thesauruses) {
            thesaurusIds.addAll(ThesaurusDataHelper.getChildrenRecursif(thesaurus));
        }
        return VradiHelper.executeQuery(request, extension, dateType, beginDate.getTime(), endDate.getTime(), streamId, thesaurusIds, statusIds, formPagedResult);
    }

    public ListCellRenderer getDateTypeComboBoxRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = -1967943679031854092L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = null;
                if (value != null) {
                    int dot;
                    stringValue = value.toString();
                    String extName = stringValue.substring(0, dot = stringValue.lastIndexOf("."));
                    stringValue = "Infogene".equals(extName) || "Form".equals(extName) ? I18n._((String)(SearchHandler.DATE_CRITERIA_I18N_PREFIX + stringValue)) : stringValue.substring(dot + 1);
                }
                return super.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
            }
        };
    }

    public void exportToCSV(JAXXContext context) {
        SearchUI searchUI = this.getUI(context);
        File file = UIHelper.openFileChooser(CSV_FILE_EXTENSION, I18n._((String)"vradi.export.filter.csv"), (Component)((Object)searchUI), I18n._((String)"vradi.export.validate.label"));
        if (file != null) {
            FormPagedResult formPageDTO = new FormPagedResult();
            formPageDTO.setNbFormsToShow(-1);
            formPageDTO.setPageToShow(1);
            OfferListTableModel tableModel = new OfferListTableModel(formPageDTO);
            if (searchUI != null) {
                CriteriaUI criterias = searchUI.getCriterias();
                String request = searchUI.getRequest();
                this.executeQuery(context, criterias, formPageDTO, null, request);
            } else {
                this.executeQuery(context, null, formPageDTO, null, null);
            }
            UIHelper.exportToCSV(file, tableModel);
        }
    }
}

