package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TextEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<String, TextEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONVERT_TO_ISO_ENABLED = "convertToIso.enabled";
    public static final String BINDING_CONVERT_TO_UTF_ENABLED = "convertToUtf.enabled";
    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_REMOVE_END_LINE_BUTTON_ENABLED = "removeEndLineButton.enabled";
    public static final String BINDING_REMOVE_XML_ENABLED = "removeXML.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRCdmDjBmECIlUAECBMiGtA5AgRFEB9JiEjkBIRNFOGG9d0m3mjv9tjdcy4UiJ/AT4CeBomOClFQU9Ag/gJCFLSI2TvbZ4MxBru4s3bmvXlvbmdefoG0knB6h4ShJQNPM5daqzc3N+9Ud6itl6iyJfO1kBD/hlKQqkDWaZ0rDWcqRQMvNOCFReH6wqNeG3q+CAeU3uNU1SjVGk52ImylCqVWeD70A9lkbYnqxvr829fUM+fpixRA6KO6LFrJ/w2VOBkuQoo5GiawUp0UOPG2UYZk3jbqHTNni5wotU5c+giewGgRRnwikUzDTP+WI44IH/oaxmY3JHHYLYdhzpyGC7ZwrZ1AMuUSadeosuombgXMEltbVFo0ylRWmYY6Rvl+RDeiIe0Kh3INV/6dZM0gE6ZMnXDmEAxoONfRwVbAUrvYGatknhvNw4RhLK6xKDwddWjC9C9sgFbvEq+93HicXLKl4NzENBztyE8iBjHRAo7EQA2THenG101JicmaTJJnNxZEOBdxtzmKMSbUyZ2T1BV1estzisyjC4HW6AVyHYXiUwM43sIdtIVXp1KXxYoS5iz/p/h9vdUlnonrbq4V24MSjneoxhmxkhlJLvFQBdIywGMNxyq/j9U9DMUDdeyXgTKEUfTHVO7jm8+vl5tTNI61J7umti0BvN2+FD7aYqb04XiEAs14YY348xXIKMpxg0Qb4kQXYaVGGMVhvSMGbhm4dZuoGlKkRz+9fTf18MM+SC3DAS6Is0xM/gpkdE1iFwR3Qv/6jUjRwd39RrjRhp+dkz2B3wkOXcU7SvJV5jn48a6F2IQTXZrQUlLNvP+eK7260WzEEAqb/mN60oz0AxhhHsdLEy2Uxq7oukCyvqKBI5Kd0G1LDJl3zm+My/noOdfN6XRNSPYYbynh8cAsEHlXcGbvGcjFMDCvS5ET8+9yRDzVB3HWZR5zA7fEHtMeVNN9UA1rnM0BOUapR6qcOj1oTv2Vxhwv4V66Gn+qPNG46quBptf+lxH7pIXgZeaXGx7XBxG30sPeTH/2emjoj6E0MEMvF7MDu+iPoZeL/hh6uTg7sIv+GHq5MAw/AWcFjRK8CQAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.TextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton convertToIso;
    protected javax.swing.JButton convertToUtf;
    protected javax.swing.JTextArea editor;
    protected javax.swing.JScrollPane editorScrollPane;
    protected com.jurismarches.vradi.ui.offer.editors.TextEditorModel model;
    protected javax.swing.JButton removeEndLineButton;
    protected javax.swing.JButton removeXML;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.TextEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TextEditor $VradiEditor0 = this;
    private jaxx.runtime.swing.VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }
            void $afterCompleteSetup() {
                // scroll more efficiently
                editorScrollPane.getVerticalScrollBar().setBlockIncrement(100);
                editorScrollPane.getVerticalScrollBar().setUnitIncrement(50);
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TextEditor() {
        super();
        $initialize();
    }

    public TextEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.TextEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__convertToIso(java.awt.event.ActionEvent event) {
        model.convertToIso();
    }

    public void doActionPerformed__on__convertToUtf(java.awt.event.ActionEvent event) {
        model.convertToUtf();
    }

    public void doActionPerformed__on__removeEndLineButton(java.awt.event.ActionEvent event) {
        model.removeEndLine();
    }

    public void doActionPerformed__on__removeXML(java.awt.event.ActionEvent event) {
        model.removeXML();
    }

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());revalidate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getConvertToIso() {
        return convertToIso;
    }

    public javax.swing.JButton getConvertToUtf() {
        return convertToUtf;
    }

    public javax.swing.JTextArea getEditor() {
        return editor;
    }

    public javax.swing.JScrollPane getEditorScrollPane() {
        return editorScrollPane;
    }

    public com.jurismarches.vradi.ui.offer.editors.TextEditorModel getModel() {
        return model;
    }

    public javax.swing.JButton getRemoveEndLineButton() {
        return removeEndLineButton;
    }

    public javax.swing.JButton getRemoveXML() {
        return removeXML;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editorScrollPane, BorderLayout.CENTER);
        editorContent.add($VBox0, BorderLayout.EAST);
    }

    protected void addChildrenToEditorScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        editorScrollPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(editor));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
        validator.setFieldRepresentation("value", editor);
    }

    protected void createConvertToIso() {
        $objectMap.put("convertToIso", convertToIso = new javax.swing.JButton());
        
        convertToIso.setName("convertToIso");
        convertToIso.setText(_("vradi.editor.convertToIso"));
        convertToIso.setToolTipText(_("vradi.editor.convertToIsoToolTip"));
        convertToIso.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__convertToIso"));
    }

    protected void createConvertToUtf() {
        $objectMap.put("convertToUtf", convertToUtf = new javax.swing.JButton());
        
        convertToUtf.setName("convertToUtf");
        convertToUtf.setText(_("vradi.editor.convertToUtf"));
        convertToUtf.setToolTipText(_("vradi.editor.convertToUtfToolTip"));
        convertToUtf.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__convertToUtf"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextArea());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createEditorScrollPane() {
        $objectMap.put("editorScrollPane", editorScrollPane = new javax.swing.JScrollPane());
        
        editorScrollPane.setName("editorScrollPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.offer.editors.TextEditorModel());
    }

    protected void createRemoveEndLineButton() {
        $objectMap.put("removeEndLineButton", removeEndLineButton = new javax.swing.JButton());
        
        removeEndLineButton.setName("removeEndLineButton");
        removeEndLineButton.setText(_("vradi.editor.removeEndLine"));
        removeEndLineButton.setToolTipText(_("vradi.editor.removeEndLineToolTip"));
        removeEndLineButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeEndLineButton"));
    }

    protected void createRemoveXML() {
        $objectMap.put("removeXML", removeXML = new javax.swing.JButton());
        
        removeXML.setName("removeXML");
        removeXML.setText(_("vradi.editor.removeXML"));
        removeXML.setToolTipText(_("vradi.editor.removeXMLToolTip"));
        removeXML.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeXML"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.TextEditorModel >(com.jurismarches.vradi.ui.offer.editors.TextEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        addChildrenToEditorScrollPane();
        // inline complete setup of $VBox0
        $VBox0.add(removeEndLineButton);
        $VBox0.add(convertToIso);
        $VBox0.add(convertToUtf);
        $VBox0.add(removeXML);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        editorScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        editor.setMinimumSize(new Dimension(0,56));
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditorScrollPane();
        createEditor();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        createRemoveEndLineButton();
        createConvertToIso();
        createConvertToUtf();
        createRemoveXML();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_END_LINE_BUTTON_ENABLED, true ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    removeEndLineButton.setEnabled(getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONVERT_TO_ISO_ENABLED, true ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    convertToIso.setEnabled(getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONVERT_TO_UTF_ENABLED, true ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    convertToUtf.setEnabled(getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_XML_ENABLED, true ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    removeXML.setEnabled(getValue() != null && !getValue().isEmpty());
                }
            }
        });
    }

}